/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamCopier {
    private InputStream in;
    private OutputStream out;
    private byte[] buf;
    private boolean closeWhenFinished;
    private boolean isFinished;

    public StreamCopier(InputStream inputStream, OutputStream outputStream, int n, boolean bl) {
        this.in = inputStream;
        this.out = outputStream;
        this.buf = new byte[Math.max(n, 1024)];
        this.closeWhenFinished = bl;
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        StreamCopier.copy(inputStream, outputStream, 50000, bl);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n, boolean bl) throws IOException {
        StreamCopier streamCopier = new StreamCopier(inputStream, outputStream, n, bl);
        while (!streamCopier.isFinished()) {
            streamCopier.copyBlock();
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public int copyBlock() throws IOException {
        if (this.isFinished()) {
            return -1;
        }
        int n = this.in.read(this.buf);
        if (n == -1) {
            this.isFinished = true;
            if (this.closeWhenFinished) {
                this.in.close();
                this.out.close();
            }
            return n;
        }
        this.out.write(this.buf, 0, n);
        return n;
    }
}

