/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import java.io.BufferedInputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarClassTester
extends URLClassLoader {
    private JarFile jarFile;

    public JarClassTester(String string, boolean bl) throws IOException {
        super(new URL[]{new URL("file://" + string)});
        this.jarFile = new JarFile(string);
        this.searchForClasses(bl);
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        ZipEntry zipEntry = this.jarFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        try {
            return this.prepareInputStream(string);
        }
        catch (IOException iOException) {
            JarClassTester.println("Found an entry for " + string + " in jar file " + this.jarFile.getName() + " but could not open an InputStream for the resource.", iOException);
            return null;
        }
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        String string2 = this.fixClassname(string);
        byte[] byArray = null;
        try {
            byArray = this.loadClassData(string2);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string2, iOException);
        }
        Class<?> clazz = this.defineClass(string2, byArray, 0, byArray.length);
        return clazz;
    }

    public boolean containsClass(String string) {
        String string2 = this.fixClassname(string);
        try {
            String string3 = string2.replace('.', '/') + ".class";
            JarEntry jarEntry = this.jarFile.getJarEntry(string3);
            return jarEntry != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private byte[] loadClassData(String string) throws IOException {
        String string2 = this.fixClassname(string);
        String string3 = string2.replace('.', '/') + ".class";
        JarEntry jarEntry = this.jarFile.getJarEntry(string3);
        if (jarEntry == null) {
            throw new FileNotFoundException("Object " + string3 + " not found.");
        }
        InputStream inputStream = this.prepareInputStream(jarEntry.getName());
        int n = (int)jarEntry.getSize();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray, n2, n - n2)) >= 0) {
        }
        inputStream.close();
        return byArray;
    }

    protected void searchForClasses(boolean bl) {
        Class<Externalizable> clazz = Externalizable.class;
        try {
            Enumeration<JarEntry> enumeration = this.jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                boolean bl2;
                Object object;
                String string;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !(string = zipEntry.getName()).endsWith(".class") || string.indexOf("$") > -1) continue;
                String string2 = string.substring(0, string.length() - 6);
                string2 = string2.replace('/', '.');
                Class<?> clazz2 = this.loadClass(string2);
                Class[] classArray = this.getAllInterfaces(clazz2);
                for (int i = 0; i < classArray.length; ++i) {
                    if (!Serializable.class.equals((Object)classArray[i])) continue;
                    ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz2);
                    JarClassTester.println("!!! " + clazz2.getName() + " is marked 'Serializable'," + " serialVersionUID = " + objectStreamClass.getSerialVersionUID());
                }
                if (!clazz.isAssignableFrom(clazz2)) continue;
                long l = 0L;
                boolean bl3 = false;
                try {
                    object = null;
                    object = clazz2.getDeclaredField("serialVersionUID");
                    ((Field)object).setAccessible(true);
                    Long l2 = (Long)((Field)object).get(clazz2);
                    l = l2;
                    bl3 = false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    bl3 = true;
                }
                if (bl3) {
                    object = ObjectStreamClass.lookup(clazz2);
                    l = ((ObjectStreamClass)object).getSerialVersionUID();
                    JarClassTester.println("!!! " + clazz2.getName() + " needs declaration: " + "private static final long serialVersionUID = " + l + "L;");
                }
                boolean bl4 = bl2 = ((n = clazz2.getModifiers()) & 0x400) > 0;
                if (clazz2.isInterface() || bl2) continue;
                try {
                    clazz2.newInstance();
                    if (!bl) continue;
                    JarClassTester.println("    " + clazz2.getName() + " is Externalizable, serialVersionUID = " + l);
                }
                catch (Exception exception) {
                    JarClassTester.println("!!! " + clazz2.getName() + ": is Externalizable, but missing" + " a public no-arg constructor.");
                }
            }
        }
        catch (Exception exception) {
            JarClassTester.println("Error scanning the jar file's classes", exception);
        }
    }

    private Class[] getAllInterfaces(Class clazz) {
        HashSet hashSet = new HashSet();
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            hashSet.addAll(Arrays.asList(clazz2.getInterfaces()));
        }
        Class[] classArray = new Class[hashSet.size()];
        hashSet.toArray(classArray);
        return classArray;
    }

    protected String fixClassname(String string) {
        int n = string.indexOf("[L");
        if (n > -1) {
            return string.substring(n + 2, string.length() - 1);
        }
        return string;
    }

    protected InputStream prepareInputStream(String string) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.jarFile.getName())));
        while ((zipEntry = zipInputStream.getNextEntry()) != null && !zipEntry.getName().equals(string)) {
        }
        if (zipEntry == null) {
            throw new IOException("File not found within Jar: " + string);
        }
        return zipInputStream;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            JarClassTester.printHelp();
            return;
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-verbose")) {
                bl = true;
                continue;
            }
            File file = new File(stringArray[i]);
            if (!file.exists()) continue;
            try {
                new JarClassTester(file.getName(), bl);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Unable to examine jar file " + stringArray[i]);
                exception.printStackTrace();
            }
        }
    }

    public static void printHelp() {
        System.out.println("This utility examines the objects within a Jar File and for each object");
        System.out.println("\tthat extends VersionedObject, this utility verifies that the class");
        System.out.println("\tcontains a public no-arg constructor.");
        System.out.println("Please supply the name of a Jar File on the command line.");
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private static void println(String string, Throwable throwable) {
        System.out.println(string);
        throwable.printStackTrace();
    }
}

