/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.InterruptibleProcess;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpClientSession
implements InterruptibleProcess {
    private Map<String, String> cookieMap = new HashMap<String, String>();
    private String charset;
    private int lastStatus;
    public static final String HTTP_GET = "GET";
    public static final String HTTP_POST = "POST";
    private boolean interrupted = false;

    @Override
    public boolean wasInterrupted() {
        return this.interrupted;
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    public int getLastStatus() {
        return this.lastStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fetch(URL uRL, String string) throws IOException {
        this.interrupted = false;
        this.lastStatus = 0;
        HttpURLConnection httpURLConnection = this.openConnection(uRL, string);
        this.updateCookies(httpURLConnection);
        this.lastStatus = httpURLConnection.getResponseCode();
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            bufferedReader = this.charset == null ? new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream())) : new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), this.charset));
            while (!this.interrupted) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    break;
                }
                stringBuilder.append(string2);
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Throwable throwable) {}
        }
        return stringBuilder.toString();
    }

    private void updateCookies(HttpURLConnection httpURLConnection) throws IOException {
        List<String> list = httpURLConnection.getHeaderFields().get("Set-Cookie");
        if (list == null || list.size() == 0) {
            return;
        }
        for (String string : list) {
            String[] stringArray = string.split(";");
            if (stringArray.length == 0) continue;
            stringArray = stringArray[0].split("=");
            String string2 = null;
            String string3 = null;
            if (stringArray.length == 0) continue;
            string2 = stringArray[0];
            if (stringArray.length > 1) {
                string3 = stringArray[1];
            }
            if (string3 == null) {
                this.cookieMap.remove(string2);
                continue;
            }
            this.cookieMap.put(string2, string3);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            HttpClientSession.printHelp();
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(stringArray[0]);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("The URL " + stringArray[0] + " doesn't appear to be valid.");
            System.err.println(malformedURLException.getClass().getName() + ": " + malformedURLException.getMessage());
            return;
        }
        String string = HTTP_GET;
        if (stringArray.length > 1) {
            string = stringArray[1];
        }
        HttpClientSession httpClientSession = new HttpClientSession();
        try {
            System.out.println(httpClientSession.fetch(uRL, string));
        }
        catch (Exception exception) {
            System.err.println("An error occurred while trying to perform the HTTP action.");
            exception.printStackTrace();
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public static void printHelp() {
        System.out.println("Need 1 or more params: URL HttpMode [username password]");
        System.out.println("\tURL is the url to be retrieved.");
        System.out.println("\tHttpMode can be either GET (default) or POST.");
    }

    protected HttpURLConnection openConnection(URL uRL, String string) throws IOException {
        if (uRL == null) {
            throw new NullPointerException("The URL passed in was null.");
        }
        if (string == null) {
            throw new NullPointerException("The HttpMode passed in was null.");
        }
        boolean bl = false;
        if (string.equals(HTTP_POST) || string.equals(HTTP_GET)) {
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("The HTTP Mode " + string + " is not valid. Try 'GET' or 'POST'.");
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (this.charset != null) {
            uRLConnection.setRequestProperty("Content-Type", "text/html; charset=" + this.charset);
            uRLConnection.setRequestProperty("Accept-Encoding", this.charset);
            uRLConnection.setRequestProperty("Accept-Charset", this.charset);
        }
        uRLConnection.setRequestProperty("Connection", "Keep-Alive");
        uRLConnection.setRequestProperty("Proxy-Connection", "Keep-Alive");
        uRLConnection.setRequestProperty("Cache-Control", "no-cache");
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.cookieMap.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        if (stringBuilder.length() > 0) {
            uRLConnection.setRequestProperty("Cookie", stringBuilder.toString());
        }
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod(string);
            HttpURLConnection.setFollowRedirects(true);
            httpURLConnection.setInstanceFollowRedirects(true);
            return httpURLConnection;
        }
        throw new IOException("An invalid protocol was specified. Did not get a Http Connection");
    }
}

