/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

public class HSJvmProperties {
    public static final String RUNTIME_MODE = "helpsystems.runtime.mode";
    public static final String RMI_TRACE = "helpsystems.rmi.trace";
    public static final String JT400_TRACE = "helpsystems.jt400.trace";
    public static final String JDBC_TRACE = "helpsystems.jdbc.trace";
    public static final String TEST_I18N = "helpsystems.test.i18n";
    public static final String TL_TIMEOUT = "helpsystems.tl.timeout";
    public static final String RBH_URL = "helpsystems.rbh.url";

    private HSJvmProperties() {
    }

    public static final boolean isRuntimeModeDevelopment() {
        String string = System.getProperty(RUNTIME_MODE);
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase("dev");
    }

    public static final boolean isRMITraceEnabled() {
        String string = System.getProperty(RMI_TRACE);
        return string != null;
    }

    public static final boolean isJT400TraceEnabled() {
        String string = System.getProperty(JT400_TRACE);
        return string != null;
    }

    public static final boolean isJDBCTraceEnabled() {
        String string = System.getProperty(JDBC_TRACE);
        return string != null;
    }

    public static final boolean isTestingI18N() {
        return "true".equalsIgnoreCase(System.getProperty(TEST_I18N));
    }

    public static long getTLTimeout() {
        try {
            return Long.parseLong(System.getProperty(TL_TIMEOUT));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static String getRbhUrl() {
        String string = System.getProperty(RBH_URL);
        if (string == null) {
            string = "";
        }
        return string;
    }
}

