/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;

public class BasicUpdate {
    private static boolean headless = "true".equalsIgnoreCase(System.getProperty("java.awt.headless"));
    public static final String UPDATE_PROPERTIES = "update.properties";

    public static void main(String[] stringArray) {
        ClassLoader classLoader = BasicUpdate.class.getClassLoader();
        Properties properties = null;
        InputStream inputStream = classLoader.getResourceAsStream(UPDATE_PROPERTIES);
        if (inputStream == null) {
            BasicUpdate.showError("The jar file does not contain file: update.properties");
            System.exit(-1);
        }
        try {
            properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
        }
        catch (Throwable throwable) {
            BasicUpdate.showError("Unable to load file update.properties", throwable);
            System.exit(-1);
        }
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        String string = null;
        String string2 = null;
        try {
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                string = (String)entry.getKey();
                string2 = (String)entry.getValue();
                File file = new File(string2);
                string2 = file.getAbsolutePath();
                File file2 = file.getParentFile();
                if (file2 != null) {
                    if (file2.exists() && !file2.isDirectory()) {
                        throw new IOException("Unable to write to directory " + file2.getAbsolutePath());
                    }
                    if (!file2.exists() && !file2.mkdirs()) {
                        throw new IOException("Unable to create directory " + file2.getAbsolutePath());
                    }
                }
                inputStream = classLoader.getResourceAsStream(string);
                BasicUpdate.extractEntry(string2, inputStream);
                inputStream.close();
            }
        }
        catch (Throwable throwable) {
            BasicUpdate.showError("Unable to copy the file " + string + "\nto file " + string2, throwable);
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractEntry(String string, InputStream inputStream) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(string);
            byte[] byArray = new byte[50000];
            while ((n = inputStream.read(byArray)) >= 1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void showError(String string) {
        BasicUpdate.showError(string, null);
    }

    private static void showError(String string, Throwable throwable) {
        if (headless) {
            BasicUpdate.printError(string, throwable);
        } else {
            BasicUpdate.popupError(string, throwable);
        }
    }

    private static void popupError(String string, Throwable throwable) {
        String string2 = string;
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            string2 = string2 + "\nCaused by: " + throwable2.getClass().getName() + ": " + throwable2.getMessage();
        }
        JOptionPane.showMessageDialog(null, string2, "Error", 0);
    }

    private static void printError(String string, Throwable throwable) {
        System.err.println(string);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }
}

