/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.license;

import java.util.ArrayList;
import java.util.Arrays;

public class SequelCommands {
    private static final String[] allowedSkybotCommands = new String[]{"SKYDIAG", "SKYGETACT", "SKYFIREEVT", "SKYSETSV", "SKYSTATUS"};
    private static final String[] allowedSystemCommands = new String[]{"ADDLIBLE", "RMVLIBLE", "CHGLIBL", "CHGSYSLIBL", "CLRLIB", "CHGSPLFA", "DLTSPLF", "HLDSPLF", "RLSSPLF", "SNDNETSPLF", "SNDTCPSPLF", "CHGPRTF", "OVRPRTF", "CPYFRMSTMF", "CPYTOSTMF", "CPYFRMIMPF", "CPYTOIMPF", "CRTPF", "ADDPFM", "DLTF", "CLRPFM", "CPYF", "RMVM", "OVRDBF", "CHGJOB", "DLYJOB", "CHGACGCDE", "ADDRPLYE", "RMVRPYLE", "STRDBG", "ENDDBG", "MOVOBJ"};
    private static final String[] allowedSequelCommands = new String[]{"CHGRPTD", "CHGTBLD", "CHGVIEW", "CRTVIEW", "DELETE", "DISPLAY", "DSPAPPD", "DSPDASHD", "DSPRPTD", "DSPSCRIPTD", "DSPTBLD", "DSPVIEWD", "DYNSQL", "DYNSQLF", "EXECUTE", "EXECUTEVPT", "INSERT", "OUTFILE", "PRINT", "REPORT", "REPORTVPT", "RUNAPP", "RUNCMD", "RUNCMDVPT", "RUNSCRIPT", "RUNSCRVPT", "SETDFT", "SQLCLOSE", "SQLCONNECT", "TABLE", "UPDATE", "VPSHELL"};
    private static final String[] allowedESendCommands = new String[]{"EDISTRIB", "EEXEC", "ESNDFILE", "ESNDMAIL", "PDFSPLF"};

    public static String[] getAllowedCommands() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < allowedSystemCommands.length; ++n) {
            arrayList.add(allowedSystemCommands[n]);
        }
        for (n = 0; n < allowedSequelCommands.length; ++n) {
            arrayList.add(allowedSequelCommands[n]);
        }
        for (n = 0; n < allowedESendCommands.length; ++n) {
            arrayList.add(allowedESendCommands[n]);
        }
        for (n = 0; n < allowedSkybotCommands.length; ++n) {
            arrayList.add(allowedSkybotCommands[n]);
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] getDisplayableCommandList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        SequelCommands.appendDisplayCommands(arrayList, "System Commands", allowedSystemCommands);
        SequelCommands.appendDisplayCommands(arrayList, "SEQUEL Commands", allowedSequelCommands);
        SequelCommands.appendDisplayCommands(arrayList, "ESend Commands", allowedESendCommands);
        SequelCommands.appendDisplayCommands(arrayList, "Automate Schedule Commands", allowedSkybotCommands);
        return arrayList.toArray(new String[0]);
    }

    private static void appendDisplayCommands(ArrayList<String> arrayList, String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        arrayList.add(string + ":");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            SequelCommands.appendSpaces(stringBuffer, 2 + (10 - stringArray[i].length()));
            if (++n < 7) continue;
            arrayList.add("  " + stringBuffer.toString().trim());
            stringBuffer.setLength(0);
            n = 0;
        }
        if (n > 0) {
            arrayList.add("  " + stringBuffer.toString().trim());
        }
        arrayList.add("");
    }

    private static void appendSpaces(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
    }

    public static boolean isCommandAllowed(String string) {
        if (string == null) {
            return true;
        }
        if (string.trim().length() == 0) {
            return true;
        }
        String[] stringArray = string.trim().split(" ");
        return SequelCommands.isCommandWordAllowed(stringArray[0]);
    }

    private static boolean isCommandWordAllowed(String string) {
        if (string == null) {
            return true;
        }
        if (string.trim().length() == 0) {
            return true;
        }
        if (SequelCommands.isCommandNameAllowed(string.trim().toUpperCase(), allowedSystemCommands)) {
            return true;
        }
        if (SequelCommands.isCommandNameAllowed(string.trim().toUpperCase(), allowedSequelCommands)) {
            return true;
        }
        if (SequelCommands.isCommandNameAllowed(string.trim().toUpperCase(), allowedESendCommands)) {
            return true;
        }
        return SequelCommands.isCommandNameAllowed(string.trim().toUpperCase(), allowedSkybotCommands);
    }

    private static boolean isCommandNameAllowed(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string.equals(string2)) {
                return true;
            }
            if (!string.endsWith("/" + string2)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        SequelCommands.testAllowedCommands();
        SequelCommands.testAllAllowedCommands();
        SequelCommands.testProhibittedCommands();
        SequelCommands.testDisplayCommandList();
    }

    private static void testAllowedCommands() {
        System.out.println("============================================================");
        System.out.println("Testing Allowed Commands...");
        System.out.println("============================================================");
        SequelCommands.test("", true);
        SequelCommands.test(null, true);
        SequelCommands.test("addlible lib(keith)", true);
        SequelCommands.test("ADDLIBLE LIB(KEITH)", true);
        SequelCommands.test("qsys/addlible lib(keith)", true);
        SequelCommands.test("QSYS/ADDLIBLE LIB(KEITH)", true);
        SequelCommands.test("EXECUTE LIB(KEITH)", true);
        SequelCommands.test("UPDATE LIB(KEITH)", true);
        SequelCommands.test("PDFSPLF LIB(KEITH)", true);
        SequelCommands.test("SKYSTATUS parm1(parm1) parm2(parm2)", true);
        SequelCommands.test("skyagent/skystatus parm1(parm1) parm2(parm2)", true);
        System.out.println();
    }

    private static void testAllAllowedCommands() {
        System.out.println("============================================================");
        System.out.println("Testing All Allowed Commands...");
        System.out.println("============================================================");
        String[] stringArray = SequelCommands.getAllowedCommands();
        for (int i = 0; i < stringArray.length; ++i) {
            SequelCommands.test(stringArray[i] + " parm(parm)", true);
            SequelCommands.test("mylib/" + stringArray[i].toLowerCase() + " parm(parm)", true);
            SequelCommands.test("badcommand " + stringArray[i] + " OBJ(myobj)", false);
        }
        System.out.println();
    }

    private static void testProhibittedCommands() {
        System.out.println("============================================================");
        System.out.println("Testing Prohibitted Commands...");
        System.out.println("============================================================");
        SequelCommands.test("SAVOBJ OBJ(myobj)", false);
        SequelCommands.test("QSYS/SAVOBJ OBJ(myobj)", false);
        SequelCommands.test("savobj OBJ(myobj)", false);
        SequelCommands.test("qsys/savfobj OBJ(myobj)", false);
        System.out.println();
    }

    private static void testDisplayCommandList() {
        System.out.println("============================================================");
        System.out.println("Testing Display Command List...");
        System.out.println("============================================================");
        String[] stringArray = SequelCommands.getDisplayableCommandList();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
        System.out.println();
    }

    private static void test(String string, boolean bl) {
        System.out.println();
        if (bl) {
            System.out.println("Testing Allowed Command: " + string);
        } else {
            System.out.println("Testing Prohibited Command: " + string);
        }
        boolean bl2 = SequelCommands.isCommandAllowed(string);
        if (bl2 != bl) {
            System.out.println("!!! FAILED!!!");
            throw new RuntimeException("Test failed for command: " + string);
        }
        System.out.println("passed!");
    }

    static {
        Arrays.sort(allowedSystemCommands);
        Arrays.sort(allowedSequelCommands);
        Arrays.sort(allowedESendCommands);
        Arrays.sort(allowedSkybotCommands);
    }
}

