/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.filter.AbstractFilterField;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.io.Serializable;

public class FilterFieldString
extends AbstractFilterField {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(FilterFieldString.class.getName());
    private static final long serialVersionUID = -365670212517419364L;
    private String[] stringOperators = new String[]{"0", "1", "2", "3", "4", "5", "6", "10", "9", "11"};
    public static final String EMPTY_STRING = "*BLANK";
    private int maxLength;
    private boolean requiredValue;
    private boolean allowEmbeddedBlanks;
    private int stringCase;
    private boolean caseInsensitive = false;

    public FilterFieldString() {
    }

    public FilterFieldString(String string, String string2, int n, boolean bl, boolean bl2, int n2, boolean bl3) {
        super(string, string2, 0);
        this.setOperatorArray(this.stringOperators);
        this.maxLength = n;
        this.requiredValue = bl;
        this.allowEmbeddedBlanks = bl2;
        this.stringCase = n2;
        this.setCaseInsensitive(bl3);
    }

    public FilterFieldString(String string, String string2, int n, boolean bl, boolean bl2, int n2) {
        this(string, string2, n, bl, bl2, n2, false);
    }

    public FilterFieldString(String string, String string2, int n, boolean bl, boolean bl2, int n2, String[] stringArray) {
        super(string, string2, 0);
        this.setOperatorArray(stringArray);
        this.maxLength = n;
        this.requiredValue = bl;
        this.allowEmbeddedBlanks = bl2;
        this.stringCase = n2;
    }

    @Override
    public boolean valid(int n, Object object) {
        String string = null;
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(this.displayName + " value was not passed as a String.");
        }
        string = (String)object;
        if (string == null) {
            string = "";
        }
        string = string.trim();
        if (this.requiredValue && string.length() == 0) {
            throw new IllegalArgumentException(rbh.getMsg("require_value", this.displayName));
        }
        if (!this.allowEmbeddedBlanks && string.indexOf(" ") > -1) {
            throw new IllegalArgumentException(rbh.getMsg("no_embedded_spaces", this.displayName));
        }
        if (string.length() > this.maxLength) {
            throw new IllegalArgumentException(rbh.getMsg("exceed_max", this.displayName, String.valueOf(this.maxLength)));
        }
        return super.valid(n, object);
    }

    @Override
    public int getStringCase() {
        return this.stringCase;
    }

    public boolean isValueRequired() {
        return this.requiredValue;
    }

    public boolean isAllowsEmbeddedSpaces() {
        return this.allowEmbeddedBlanks;
    }

    @Override
    public FilterCriteria getFilterCriteria(int n, Serializable serializable) {
        this.valid(n, serializable);
        FilterCriteria filterCriteria = new FilterCriteria(this.fieldName, serializable, n);
        filterCriteria.setIgnoreCase(this.caseInsensitive);
        return filterCriteria;
    }

    public void setCaseInsensitive(boolean bl) {
        this.caseInsensitive = bl;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }
}

