/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.FilterCriteria;
import junit.framework.TestCase;

public class DataFilterTest
extends TestCase {
    DataFilter df;

    protected void setUp() throws Exception {
        super.setUp();
        this.df = new DataFilter("datafilter_name");
    }

    protected void tearDown() throws Exception {
        this.df = null;
        super.tearDown();
    }

    public void testEqualsObject() {
        DataFilterTest.assertFalse((boolean)this.df.equals(null));
        DataFilterTest.assertFalse((boolean)this.df.equals(new Object()));
        DataFilterTest.assertTrue((boolean)this.df.equals(this.df));
    }

    public void testHasDynamicFilterCriteria() {
        DataFilterTest.assertFalse((boolean)this.df.hasDynamicFilterCriteria());
        FilterCriteria filterCriteria = new FilterCriteria("field_1", new Long(1234L), 3);
        this.df.addCriteria(filterCriteria);
        DataFilterTest.assertFalse((boolean)this.df.hasDynamicFilterCriteria());
        DynamicFilterCriteria dynamicFilterCriteria = new DynamicFilterCriteria();
        this.df.addCriteria(dynamicFilterCriteria);
        DataFilterTest.assertTrue((boolean)this.df.hasDynamicFilterCriteria());
        this.df = new DataFilter();
        this.df.addCriteria(filterCriteria);
        DataFilter dataFilter = new DataFilter(0, new FilterCriteria[]{filterCriteria});
        this.df.addFilter(dataFilter);
        DataFilterTest.assertFalse((boolean)this.df.hasDynamicFilterCriteria());
        this.df = new DataFilter();
        this.df.addCriteria(filterCriteria);
        dataFilter.addCriteria(dynamicFilterCriteria);
        this.df.addFilter(dataFilter);
        DataFilterTest.assertTrue((boolean)dataFilter.hasDynamicFilterCriteria());
        DataFilterTest.assertTrue((boolean)this.df.hasDynamicFilterCriteria());
    }

    public void testClone() {
        FilterCriteria filterCriteria = new FilterCriteria("field_1", new Long(1234L), 3);
        this.df.addCriteria(filterCriteria);
        DataFilter dataFilter = (DataFilter)this.df.clone();
        DataFilterTest.assertFalse((this.df == dataFilter ? 1 : 0) != 0);
        DataFilterTest.assertEquals((String)this.df.getDataFilterName(), (String)dataFilter.getDataFilterName());
        DataFilterTest.assertEquals((int)this.df.criteriaSize(), (int)dataFilter.criteriaSize());
        DataFilterTest.assertEquals((int)this.df.filterSize(), (int)dataFilter.filterSize());
    }

    public void testEqualsName() {
        DataFilter dataFilter = new DataFilter("datafilter_name");
        DataFilterTest.assertTrue((boolean)this.df.equalsName(dataFilter));
        dataFilter = new DataFilter("otherfilter_name");
        DataFilterTest.assertFalse((boolean)this.df.equalsName(dataFilter));
    }

    public void testEqualsNameFalseForNull() {
        DataFilterTest.assertFalse((boolean)this.df.equalsName(null));
    }

    public void testIsEmpty() {
        DataFilterTest.assertTrue((boolean)this.df.isEmpty());
        FilterCriteria filterCriteria = new FilterCriteria("field_1", new Long(1234L), 3);
        this.df.addCriteria(filterCriteria);
        DataFilterTest.assertFalse((boolean)this.df.isEmpty());
        this.df = new DataFilter("datafilter_name");
        DataFilterTest.assertTrue((boolean)this.df.isEmpty());
        DataFilter dataFilter = new DataFilter("datafilter2_name");
        this.df.addFilter(dataFilter);
        DataFilterTest.assertFalse((boolean)this.df.isEmpty());
        this.df = new DataFilter("datafilter_name");
        DataFilterTest.assertTrue((boolean)this.df.isEmpty());
        this.df.setSQLString("WHERE IN THE WORLD IS CARMEN SANDIEGO?");
        DataFilterTest.assertFalse((boolean)this.df.isEmpty());
    }

    public void testDoNotInvoke() {
        String[] stringArray = this.df.doNotInvoke();
        DataFilterTest.assertNull((Object)stringArray);
    }

    public void testConstructorWithCriteria() {
        FilterCriteria filterCriteria = new FilterCriteria("field_1", new Long(1234L), 3);
        FilterCriteria filterCriteria2 = new FilterCriteria("field_2", new Long(2345L), 4);
        this.df = new DataFilter(0, new FilterCriteria[]{filterCriteria, filterCriteria2});
        FilterCriteria[] filterCriteriaArray = this.df.getCriteria();
        DataFilterTest.assertEquals((int)2, (int)filterCriteriaArray.length);
        DataFilterTest.assertEquals((Object)filterCriteria, (Object)filterCriteriaArray[0]);
        DataFilterTest.assertEquals((Object)filterCriteria2, (Object)filterCriteriaArray[1]);
        DataFilterTest.assertEquals((int)0, (int)this.df.getConjunction());
    }

    public void testGetCriteria() {
        FilterCriteria filterCriteria = new FilterCriteria("field_1", new Long(1234L), 3);
        FilterCriteria filterCriteria2 = new FilterCriteria("field_2", new Long(2345L), 4);
        this.df.addCriteria(filterCriteria);
        this.df.addCriteria(filterCriteria2);
        FilterCriteria[] filterCriteriaArray = this.df.getCriteria();
        DataFilterTest.assertEquals((int)2, (int)filterCriteriaArray.length);
        DataFilterTest.assertEquals((Object)filterCriteria, (Object)filterCriteriaArray[0]);
        DataFilterTest.assertEquals((Object)filterCriteria2, (Object)filterCriteriaArray[1]);
    }

    public void testGetFilters() {
        DataFilter dataFilter = new DataFilter("name1");
        DataFilter dataFilter2 = new DataFilter("name2");
        DataFilter dataFilter3 = new DataFilter("name3");
        this.df.addFilter(dataFilter);
        this.df.addFilter(dataFilter2);
        this.df.addFilter(dataFilter3);
        DataFilter[] dataFilterArray = this.df.getFilters();
        DataFilterTest.assertEquals((int)3, (int)dataFilterArray.length);
        DataFilterTest.assertEquals((Object)dataFilter, (Object)dataFilterArray[0]);
        DataFilterTest.assertEquals((Object)dataFilter2, (Object)dataFilterArray[1]);
        DataFilterTest.assertEquals((Object)dataFilter3, (Object)dataFilterArray[2]);
    }

    public void testGetCriteriaInt() {
        FilterCriteria filterCriteria = new FilterCriteria("field_1", new Long(1234L), 3);
        FilterCriteria filterCriteria2 = new FilterCriteria("field_2", new Long(2345L), 4);
        this.df.addCriteria(filterCriteria);
        this.df.addCriteria(filterCriteria2);
        DataFilterTest.assertEquals((Object)filterCriteria, (Object)this.df.getCriteria(0));
        DataFilterTest.assertEquals((Object)filterCriteria2, (Object)this.df.getCriteria(1));
    }

    public void testGetFilter() {
        DataFilter dataFilter = new DataFilter("name1");
        DataFilter dataFilter2 = new DataFilter("name2");
        DataFilter dataFilter3 = new DataFilter("name3");
        this.df.addFilter(dataFilter);
        this.df.addFilter(dataFilter2);
        this.df.addFilter(dataFilter3);
        DataFilterTest.assertEquals((Object)dataFilter, (Object)this.df.getFilter(0));
        DataFilterTest.assertEquals((Object)dataFilter2, (Object)this.df.getFilter(1));
        DataFilterTest.assertEquals((Object)dataFilter3, (Object)this.df.getFilter(2));
    }

    public void testCriteriaSize() {
        DataFilterTest.assertEquals((int)0, (int)this.df.criteriaSize());
        FilterCriteria filterCriteria = new FilterCriteria("field_1", new Long(1234L), 3);
        FilterCriteria filterCriteria2 = new FilterCriteria("field_2", new Long(2345L), 4);
        this.df.addCriteria(filterCriteria);
        this.df.addCriteria(filterCriteria2);
        DataFilterTest.assertEquals((int)2, (int)this.df.criteriaSize());
    }

    public void testFilterSize() {
        DataFilterTest.assertEquals((int)0, (int)this.df.filterSize());
        DataFilter dataFilter = new DataFilter("name1");
        DataFilter dataFilter2 = new DataFilter("name2");
        DataFilter dataFilter3 = new DataFilter("name3");
        this.df.addFilter(dataFilter);
        this.df.addFilter(dataFilter2);
        this.df.addFilter(dataFilter3);
        DataFilterTest.assertEquals((int)3, (int)this.df.filterSize());
    }

    public void testGetConjunction() {
        this.df.setConjunction(0);
        DataFilterTest.assertEquals((int)0, (int)this.df.getConjunction());
        this.df.setConjunction(1);
        DataFilterTest.assertEquals((int)1, (int)this.df.getConjunction());
    }

    public void testSetConjunctionRejectsInvalidValues() {
        int n = -29834;
        DataFilterTest.assertFalse((n == 0 ? 1 : 0) != 0);
        DataFilterTest.assertFalse((n == 1 ? 1 : 0) != 0);
        try {
            this.df.setConjunction(n);
            DataFilterTest.fail((String)"setConjunction() accepted an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetDataFilterName() {
        DataFilterTest.assertEquals((String)"datafilter_name", (String)this.df.getDataFilterName());
        this.df.setDataFilterName("changed_name");
        DataFilterTest.assertEquals((String)"changed_name", (String)this.df.getDataFilterName());
    }

    public void testGetGroup() {
        DataFilterTest.assertNull((Object)this.df.getGroup());
        this.df.setGroup("some_group");
        DataFilterTest.assertEquals((String)"some_group", (String)this.df.getGroup());
        this.df.setGroup("other_group");
        DataFilterTest.assertEquals((String)"other_group", (String)this.df.getGroup());
    }

    public void testGetSQLString() {
        DataFilterTest.assertNull((Object)this.df.getSQLString());
        this.df.setSQLString("WHERE IN THE WORLD IS CARMEN SANDIEGO?");
        DataFilterTest.assertEquals((String)"WHERE IN THE WORLD IS CARMEN SANDIEGO?", (String)this.df.getSQLString());
    }

    public void testHasSQLString() {
        DataFilterTest.assertFalse((boolean)this.df.hasSQLString());
        this.df.setSQLString("WHERE IN THE WORLD IS CARMEN SANDIEGO?");
        DataFilterTest.assertTrue((boolean)this.df.hasSQLString());
    }

    public void testToString() {
        DataFilterTest.assertEquals((String)this.df.getDataFilterName(), (String)this.df.toString());
    }

    private class DynamicFilterCriteria
    extends FilterCriteria {
        private DynamicFilterCriteria() {
        }

        @Override
        public boolean isDynamicFilter() {
            return true;
        }
    }
}

