/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.network.ObjectID;
import com.helpsystems.common.core.network.ProductIID;
import junit.framework.TestCase;

public class ProxyTest
extends TestCase {
    Proxy prox;

    protected void setUp() throws Exception {
        super.setUp();
        this.prox = new Proxy();
    }

    protected void tearDown() throws Exception {
        this.prox = null;
        super.tearDown();
    }

    public void testEqualsObject() {
        ProxyTest.assertFalse((boolean)this.prox.equals(null));
        ProxyTest.assertFalse((boolean)this.prox.equals(new Object()));
    }

    public void testGetIdentifier() {
        ObjectID objectID = new ObjectID(12345);
        this.prox.setIdentifier(objectID);
        ProxyTest.assertEquals((Object)objectID, (Object)this.prox.getIdentifier());
    }

    public void testGetDescription() {
        this.prox.setDescription("MyDescription");
        ProxyTest.assertEquals((String)"MyDescription", (String)this.prox.getDescription());
    }

    public void testGetName() {
        this.prox.setName("MyName");
        ProxyTest.assertEquals((String)"MyName", (String)this.prox.getName());
    }

    public void testGetProductIID() {
        ProxyTest.assertNull((Object)this.prox.getProductIID());
        ProductIID productIID = new ProductIID(12345);
        this.prox.setIdentifier(productIID);
        this.prox.getProductIID();
        ProxyTest.assertEquals((Object)productIID, (Object)this.prox.getProductIID());
    }

    public void testGetProductIIDInt() {
        ProductIID productIID = new ProductIID(12345);
        this.prox.setIdentifier(productIID);
        int n = this.prox.getProductIIDInt();
        ProxyTest.assertTrue((n == 12345 ? 1 : 0) != 0);
        ObjectID objectID = new ObjectID(2345);
        this.prox.setIdentifier(objectID);
        int n2 = this.prox.getProductIIDInt();
        ProxyTest.assertTrue((n2 == 0 ? 1 : 0) != 0);
        this.prox.setProductIIDInt(456456);
        n = this.prox.getProductIIDInt();
        ProxyTest.assertTrue((n == 456456 ? 1 : 0) != 0);
    }

    public void testGetKey() {
        this.prox.setName("MyName");
        ProxyTest.assertEquals((Object)"MyName", (Object)this.prox.getKey());
        Object object = new Object();
        this.prox.setKey(object);
        ProxyTest.assertEquals((Object)object, (Object)this.prox.getKey());
    }

    public void testGetPacketElementType() {
        ProxyTest.assertEquals((String)"Unknown Object Type", (String)Proxy.getPacketElementType(this.prox));
    }

    public void testGetPacketElementDescription() {
        this.prox.setName("MyName");
        ProxyTest.assertEquals((String)"MyName", (String)Proxy.getPacketElementDescription(this.prox));
    }
}

