/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class OrRule
extends AbstractRule {
    private final Rule rule1;
    private final Rule rule2;

    private OrRule(Rule rule, Rule rule2) {
        this.rule1 = rule;
        this.rule2 = rule2;
    }

    public static Rule getRule(Rule rule, Rule rule2) {
        return new OrRule(rule, rule2);
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid OR rule - expected two rules but received " + stack.size());
        }
        Object e = stack.pop();
        Object e2 = stack.pop();
        if (e instanceof Rule && e2 instanceof Rule) {
            Rule rule = (Rule)e;
            Rule rule2 = (Rule)e2;
            return new OrRule(rule2, rule);
        }
        throw new IllegalArgumentException("Invalid OR rule: " + e + "..." + e2);
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        return this.rule1.evaluate(loggingEvent) || this.rule2.evaluate(loggingEvent);
    }
}

