/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.LevelInequalityRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.rule.TimestampInequalityRule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class InequalityRule
extends AbstractRule {
    private static final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private final String field;
    private final String value;
    private final String inequalitySymbol;

    private InequalityRule(String string, String string2, String string3) {
        this.inequalitySymbol = string;
        if (!resolver.isField(string2)) {
            throw new IllegalArgumentException("Invalid " + string + " rule - " + string2 + " is not a supported field");
        }
        this.field = string2;
        this.value = string3;
    }

    public static Rule getRule(String string, Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid " + string + " rule - expected two parameters but received " + stack.size());
        }
        String string2 = stack.pop().toString();
        String string3 = stack.pop().toString();
        return InequalityRule.getRule(string, string3, string2);
    }

    public static Rule getRule(String string, String string2, String string3) {
        if (string2.equalsIgnoreCase("LEVEL")) {
            return LevelInequalityRule.getRule(string, string3);
        }
        if (string2.equalsIgnoreCase("TIMESTAMP")) {
            return TimestampInequalityRule.getRule(string, string3);
        }
        return new InequalityRule(string, string2, string3);
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        long l = 0L;
        try {
            l = new Long(resolver.getValue(this.field, loggingEvent).toString());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        long l2 = 0L;
        try {
            l2 = new Long(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        boolean bl = false;
        if ("<".equals(this.inequalitySymbol)) {
            bl = l < l2;
        } else if (">".equals(this.inequalitySymbol)) {
            bl = l > l2;
        } else if ("<=".equals(this.inequalitySymbol)) {
            bl = l <= l2;
        } else if (">=".equals(this.inequalitySymbol)) {
            bl = l >= l2;
        }
        return bl;
    }
}

