/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class AndRule
extends AbstractRule {
    private final Rule firstRule;
    private final Rule secondRule;

    private AndRule(Rule rule, Rule rule2) {
        this.firstRule = rule;
        this.secondRule = rule2;
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid AND rule - expected two rules but received " + stack.size());
        }
        Object e = stack.pop();
        Object e2 = stack.pop();
        if (e instanceof Rule && e2 instanceof Rule) {
            Rule rule = (Rule)e;
            Rule rule2 = (Rule)e2;
            return new AndRule(rule2, rule);
        }
        throw new IllegalArgumentException("Invalid AND rule: " + e + "..." + e2);
    }

    public static Rule getRule(Rule rule, Rule rule2) {
        return new AndRule(rule, rule2);
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        return this.firstRule.evaluate(loggingEvent) && this.secondRule.evaluate(loggingEvent);
    }
}

