/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.pattern.DatePatternConverter;
import org.apache.log4j.pattern.FormattingInfo;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.pattern.PatternConverter;

public class PatternParser {
    private static final char ESCAPE_CHAR = '%';
    private static final int LITERAL_STATE = 0;
    private static final int CONVERTER_STATE = 1;
    private static final int MINUS_STATE = 2;
    private static final int DOT_STATE = 3;
    private static final int MIN_STATE = 4;
    private static final int MAX_STATE = 5;
    static HashMap globalRulesRegistry = new HashMap(17);
    int state;
    protected StringBuffer currentLiteral = new StringBuffer(32);
    protected int patternLength;
    protected int i;
    PatternConverter head;
    PatternConverter tail;
    protected FormattingInfo formattingInfo = new FormattingInfo();
    protected String pattern;
    HashMap converterRegistry;
    static Logger logger;
    static /* synthetic */ Class class$org$apache$log4j$pattern$LoggerPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$ClassNamePatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$FileLocationPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$FullLocationPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$LineLocationPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$MessagePatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$LineSeparatorPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$MethodLocationPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$LevelPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$RelativeTimePatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$ThreadPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$NDCPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$PropertiesPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$ThrowableInformationPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$PatternParser;
    static /* synthetic */ Class class$org$apache$log4j$pattern$PatternConverter;

    public PatternParser(String pattern) {
        this.pattern = pattern;
        this.patternLength = pattern.length();
        this.state = 0;
    }

    private void addToList(PatternConverter pc) {
        if (this.head == null) {
            this.head = this.tail = pc;
        } else {
            this.tail.next = pc;
            this.tail = pc;
        }
    }

    protected String extractConverter(char lastChar) {
        if (!Character.isUnicodeIdentifierStart(lastChar)) {
            return null;
        }
        StringBuffer convBuf = new StringBuffer(16);
        convBuf.append(lastChar);
        while (this.i < this.patternLength && Character.isUnicodeIdentifierPart(this.pattern.charAt(this.i))) {
            convBuf.append(this.pattern.charAt(this.i));
            ++this.i;
        }
        return convBuf.toString();
    }

    protected String extractOption() {
        int end;
        if (this.i < this.patternLength && this.pattern.charAt(this.i) == '{' && (end = this.pattern.indexOf(125, this.i)) > this.i) {
            String r = this.pattern.substring(this.i + 1, end);
            this.i = end + 1;
            return r;
        }
        return null;
    }

    public PatternConverter parse() {
        this.i = 0;
        while (this.i < this.patternLength) {
            char c = this.pattern.charAt(this.i++);
            block0 : switch (this.state) {
                case 0: {
                    if (this.i == this.patternLength) {
                        this.currentLiteral.append(c);
                        break;
                    }
                    if (c == '%') {
                        switch (this.pattern.charAt(this.i)) {
                            case '%': {
                                this.currentLiteral.append(c);
                                ++this.i;
                                break block0;
                            }
                        }
                        if (this.currentLiteral.length() != 0) {
                            this.addToList(new LiteralPatternConverter(this.currentLiteral.toString()));
                        }
                        this.currentLiteral.setLength(0);
                        this.currentLiteral.append(c);
                        this.state = 1;
                        this.formattingInfo.reset();
                        break;
                    }
                    this.currentLiteral.append(c);
                    break;
                }
                case 1: {
                    this.currentLiteral.append(c);
                    switch (c) {
                        case '-': {
                            this.formattingInfo.leftAlign = true;
                            break block0;
                        }
                        case '.': {
                            this.state = 3;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.min = c - 48;
                        this.state = 4;
                        break;
                    }
                    this.finalizeConverter(c);
                    break;
                }
                case 4: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.min = this.formattingInfo.min * 10 + (c - 48);
                        break;
                    }
                    if (c == '.') {
                        this.state = 3;
                        break;
                    }
                    this.finalizeConverter(c);
                    break;
                }
                case 3: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.max = c - 48;
                        this.state = 5;
                        break;
                    }
                    LogLog.error("Error occured in position " + this.i + ".\n Was expecting digit, instead got char \"" + c + "\".");
                    this.state = 0;
                    break;
                }
                case 5: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.max = this.formattingInfo.max * 10 + (c - 48);
                        break;
                    }
                    this.finalizeConverter(c);
                    this.state = 0;
                }
            }
        }
        if (this.currentLiteral.length() != 0) {
            this.addToList(new LiteralPatternConverter(this.currentLiteral.toString()));
        }
        return this.head;
    }

    String findConverterClass(String converterId) {
        String r;
        if (converterId == null) {
            logger.warn("converterId is null");
        }
        if (this.converterRegistry != null && (r = (String)this.converterRegistry.get(converterId)) != null) {
            return r;
        }
        r = (String)globalRulesRegistry.get(converterId);
        if (r != null) {
            return r;
        }
        return null;
    }

    protected void finalizeConverter(char c) {
        PatternConverter pc = null;
        String converterId = this.extractConverter(c);
        String className = this.findConverterClass(converterId);
        String option = this.extractOption();
        if (className != null) {
            pc = (PatternConverter)OptionConverter.instantiateByClassName(className, class$org$apache$log4j$pattern$PatternConverter == null ? (class$org$apache$log4j$pattern$PatternConverter = PatternParser.class$("org.apache.log4j.pattern.PatternConverter")) : class$org$apache$log4j$pattern$PatternConverter, null);
            pc.setFormattingInfo(this.formattingInfo);
            pc.setOption(option);
            this.currentLiteral.setLength(0);
        } else {
            switch (c) {
                case 'd': {
                    String dateFormatStr = "ISO8601";
                    if (option != null) {
                        dateFormatStr = option;
                    }
                    if (dateFormatStr.equalsIgnoreCase("ISO8601")) {
                        option = "yyyy-MM-dd HH:mm:ss,SSS";
                    } else if (dateFormatStr.equalsIgnoreCase("ABSOLUTE")) {
                        option = "HH:mm:ss,SSS";
                    } else if (dateFormatStr.equalsIgnoreCase("DATE")) {
                        option = "dd MMM yyyy HH:mm:ss,SSS";
                    }
                    pc = new DatePatternConverter(this.formattingInfo);
                    pc.setOption(option);
                    this.currentLiteral.setLength(0);
                    break;
                }
                default: {
                    LogLog.error("Unexpected char [" + c + "] at position " + this.i + " in conversion patterrn.");
                    pc = new LiteralPatternConverter(this.currentLiteral.toString());
                    this.currentLiteral.setLength(0);
                }
            }
        }
        this.addConverter(pc);
    }

    protected void addConverter(PatternConverter pc) {
        this.currentLiteral.setLength(0);
        this.addToList(pc);
        this.state = 0;
        this.formattingInfo.reset();
    }

    public HashMap getConverterRegistry() {
        return this.converterRegistry;
    }

    public void setConverterRegistry(HashMap converterRegistry) {
        this.converterRegistry = converterRegistry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        globalRulesRegistry.put("c", (class$org$apache$log4j$pattern$LoggerPatternConverter == null ? (class$org$apache$log4j$pattern$LoggerPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LoggerPatternConverter")) : class$org$apache$log4j$pattern$LoggerPatternConverter).getName());
        globalRulesRegistry.put("logger", (class$org$apache$log4j$pattern$LoggerPatternConverter == null ? (class$org$apache$log4j$pattern$LoggerPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LoggerPatternConverter")) : class$org$apache$log4j$pattern$LoggerPatternConverter).getName());
        globalRulesRegistry.put("C", (class$org$apache$log4j$pattern$ClassNamePatternConverter == null ? (class$org$apache$log4j$pattern$ClassNamePatternConverter = PatternParser.class$("org.apache.log4j.pattern.ClassNamePatternConverter")) : class$org$apache$log4j$pattern$ClassNamePatternConverter).getName());
        globalRulesRegistry.put("class", (class$org$apache$log4j$pattern$ClassNamePatternConverter == null ? (class$org$apache$log4j$pattern$ClassNamePatternConverter = PatternParser.class$("org.apache.log4j.pattern.ClassNamePatternConverter")) : class$org$apache$log4j$pattern$ClassNamePatternConverter).getName());
        globalRulesRegistry.put("F", (class$org$apache$log4j$pattern$FileLocationPatternConverter == null ? (class$org$apache$log4j$pattern$FileLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.FileLocationPatternConverter")) : class$org$apache$log4j$pattern$FileLocationPatternConverter).getName());
        globalRulesRegistry.put("file", (class$org$apache$log4j$pattern$FileLocationPatternConverter == null ? (class$org$apache$log4j$pattern$FileLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.FileLocationPatternConverter")) : class$org$apache$log4j$pattern$FileLocationPatternConverter).getName());
        globalRulesRegistry.put("l", (class$org$apache$log4j$pattern$FullLocationPatternConverter == null ? (class$org$apache$log4j$pattern$FullLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.FullLocationPatternConverter")) : class$org$apache$log4j$pattern$FullLocationPatternConverter).getName());
        globalRulesRegistry.put("L", (class$org$apache$log4j$pattern$LineLocationPatternConverter == null ? (class$org$apache$log4j$pattern$LineLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LineLocationPatternConverter")) : class$org$apache$log4j$pattern$LineLocationPatternConverter).getName());
        globalRulesRegistry.put("line", (class$org$apache$log4j$pattern$LineLocationPatternConverter == null ? (class$org$apache$log4j$pattern$LineLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LineLocationPatternConverter")) : class$org$apache$log4j$pattern$LineLocationPatternConverter).getName());
        globalRulesRegistry.put("m", (class$org$apache$log4j$pattern$MessagePatternConverter == null ? (class$org$apache$log4j$pattern$MessagePatternConverter = PatternParser.class$("org.apache.log4j.pattern.MessagePatternConverter")) : class$org$apache$log4j$pattern$MessagePatternConverter).getName());
        globalRulesRegistry.put("message", (class$org$apache$log4j$pattern$MessagePatternConverter == null ? (class$org$apache$log4j$pattern$MessagePatternConverter = PatternParser.class$("org.apache.log4j.pattern.MessagePatternConverter")) : class$org$apache$log4j$pattern$MessagePatternConverter).getName());
        globalRulesRegistry.put("n", (class$org$apache$log4j$pattern$LineSeparatorPatternConverter == null ? (class$org$apache$log4j$pattern$LineSeparatorPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LineSeparatorPatternConverter")) : class$org$apache$log4j$pattern$LineSeparatorPatternConverter).getName());
        globalRulesRegistry.put("M", (class$org$apache$log4j$pattern$MethodLocationPatternConverter == null ? (class$org$apache$log4j$pattern$MethodLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.MethodLocationPatternConverter")) : class$org$apache$log4j$pattern$MethodLocationPatternConverter).getName());
        globalRulesRegistry.put("method", (class$org$apache$log4j$pattern$MethodLocationPatternConverter == null ? (class$org$apache$log4j$pattern$MethodLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.MethodLocationPatternConverter")) : class$org$apache$log4j$pattern$MethodLocationPatternConverter).getName());
        globalRulesRegistry.put("p", (class$org$apache$log4j$pattern$LevelPatternConverter == null ? (class$org$apache$log4j$pattern$LevelPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LevelPatternConverter")) : class$org$apache$log4j$pattern$LevelPatternConverter).getName());
        globalRulesRegistry.put("level", (class$org$apache$log4j$pattern$LevelPatternConverter == null ? (class$org$apache$log4j$pattern$LevelPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LevelPatternConverter")) : class$org$apache$log4j$pattern$LevelPatternConverter).getName());
        globalRulesRegistry.put("r", (class$org$apache$log4j$pattern$RelativeTimePatternConverter == null ? (class$org$apache$log4j$pattern$RelativeTimePatternConverter = PatternParser.class$("org.apache.log4j.pattern.RelativeTimePatternConverter")) : class$org$apache$log4j$pattern$RelativeTimePatternConverter).getName());
        globalRulesRegistry.put("relative", (class$org$apache$log4j$pattern$RelativeTimePatternConverter == null ? (class$org$apache$log4j$pattern$RelativeTimePatternConverter = PatternParser.class$("org.apache.log4j.pattern.RelativeTimePatternConverter")) : class$org$apache$log4j$pattern$RelativeTimePatternConverter).getName());
        globalRulesRegistry.put("t", (class$org$apache$log4j$pattern$ThreadPatternConverter == null ? (class$org$apache$log4j$pattern$ThreadPatternConverter = PatternParser.class$("org.apache.log4j.pattern.ThreadPatternConverter")) : class$org$apache$log4j$pattern$ThreadPatternConverter).getName());
        globalRulesRegistry.put("thread", (class$org$apache$log4j$pattern$ThreadPatternConverter == null ? (class$org$apache$log4j$pattern$ThreadPatternConverter = PatternParser.class$("org.apache.log4j.pattern.ThreadPatternConverter")) : class$org$apache$log4j$pattern$ThreadPatternConverter).getName());
        globalRulesRegistry.put("x", (class$org$apache$log4j$pattern$NDCPatternConverter == null ? (class$org$apache$log4j$pattern$NDCPatternConverter = PatternParser.class$("org.apache.log4j.pattern.NDCPatternConverter")) : class$org$apache$log4j$pattern$NDCPatternConverter).getName());
        globalRulesRegistry.put("ndc", (class$org$apache$log4j$pattern$NDCPatternConverter == null ? (class$org$apache$log4j$pattern$NDCPatternConverter = PatternParser.class$("org.apache.log4j.pattern.NDCPatternConverter")) : class$org$apache$log4j$pattern$NDCPatternConverter).getName());
        globalRulesRegistry.put("X", (class$org$apache$log4j$pattern$PropertiesPatternConverter == null ? (class$org$apache$log4j$pattern$PropertiesPatternConverter = PatternParser.class$("org.apache.log4j.pattern.PropertiesPatternConverter")) : class$org$apache$log4j$pattern$PropertiesPatternConverter).getName());
        globalRulesRegistry.put("properties", (class$org$apache$log4j$pattern$PropertiesPatternConverter == null ? (class$org$apache$log4j$pattern$PropertiesPatternConverter = PatternParser.class$("org.apache.log4j.pattern.PropertiesPatternConverter")) : class$org$apache$log4j$pattern$PropertiesPatternConverter).getName());
        globalRulesRegistry.put("throwable", (class$org$apache$log4j$pattern$ThrowableInformationPatternConverter == null ? (class$org$apache$log4j$pattern$ThrowableInformationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.ThrowableInformationPatternConverter")) : class$org$apache$log4j$pattern$ThrowableInformationPatternConverter).getName());
        logger = Logger.getLogger("LOG4J." + (class$org$apache$log4j$pattern$PatternParser == null ? (class$org$apache$log4j$pattern$PatternParser = PatternParser.class$("org.apache.log4j.pattern.PatternParser")) : class$org$apache$log4j$pattern$PatternParser).getName());
    }
}

