/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LevelIconFactory;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.receivers.NewReceiverDialogPanel;
import org.apache.log4j.chainsaw.receivers.PluginPropertyEditorPanel;
import org.apache.log4j.chainsaw.receivers.ReceiverTreeCellRenderer;
import org.apache.log4j.chainsaw.receivers.ReceiversHelper;
import org.apache.log4j.chainsaw.receivers.ReceiversPanel;
import org.apache.log4j.chainsaw.receivers.ReceiversTreeModel;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.net.SocketReceiver;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginRegistry;
import org.apache.log4j.plugins.Receiver;

public class ReceiversPanel
extends JPanel {
    final Action newReceiverButtonAction;
    final Action pauseReceiverButtonAction;
    final Action playReceiverButtonAction;
    final Action shutdownReceiverButtonAction;
    final Action restartReceiverButtonAction;
    private final Action showReceiverHelpAction;
    private final Action startAllAction;
    private final JPopupMenu popupMenu = new ReceiverPopupMenu();
    private final JTree receiversTree = new JTree();
    private final NewReceiverPopupMenu newReceiverPopup = new NewReceiverPopupMenu();
    private final ReceiverToolbar buttonPanel;
    private final JSplitPane splitter = new JSplitPane();
    private final PluginPropertyEditorPanel pluginEditorPanel = new PluginPropertyEditorPanel();
    private final PluginRegistry pluginRegistry = LogManager.getLoggerRepository().getPluginRegistry();
    static /* synthetic */ Class class$org$apache$log4j$plugins$Receiver;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketReceiver;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ReceiversPanel() {
        super(new BorderLayout());
        final ReceiversTreeModel receiversTreeModel = new ReceiversTreeModel();
        this.pluginRegistry.addPluginListener(receiversTreeModel);
        this.receiversTree.setModel(receiversTreeModel);
        this.receiversTree.setExpandsSelectedPaths(true);
        receiversTreeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                this.expandRoot();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                this.expandRoot();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                this.expandRoot();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                this.expandRoot();
            }

            private void expandRoot() {
                ReceiversPanel.this.receiversTree.expandPath(new TreePath(receiversTreeModel.getPathToRoot(receiversTreeModel.RootNode)));
            }
        });
        this.receiversTree.expandPath(new TreePath(receiversTreeModel.getPathToRoot(receiversTreeModel.RootNode)));
        this.receiversTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                if (treeExpansionEvent.getPath().getLastPathComponent() == receiversTreeModel.RootNode) {
                    throw new ExpandVetoException(treeExpansionEvent);
                }
            }

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        this.receiversTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() != null && defaultMutableTreeNode.getUserObject() instanceof Plugin) {
                        Plugin plugin = (Plugin)defaultMutableTreeNode.getUserObject();
                        LogLog.debug("plugin=" + plugin);
                        ReceiversPanel.this.pluginEditorPanel.setPlugin(plugin);
                    } else {
                        ReceiversPanel.this.pluginEditorPanel.setPlugin(null);
                    }
                }
            }
        });
        this.receiversTree.setToolTipText("Allows you to manage Log4j Receivers");
        this.newReceiverButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReceiversPanel.this.newReceiverPopup.show(((ReceiversPanel)ReceiversPanel.this).buttonPanel.newReceiverButton, 0, ((ReceiversPanel)ReceiversPanel.this).buttonPanel.newReceiverButton.getHeight());
            }
        };
        this.newReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_NEW_RECEIVER));
        this.newReceiverButtonAction.putValue("ShortDescription", "Creates and configures a new Receiver");
        this.newReceiverButtonAction.putValue("Name", "New Receiver");
        this.newReceiverButtonAction.putValue("MnemonicKey", new Integer(78));
        this.newReceiverButtonAction.setEnabled(true);
        this.playReceiverButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReceiversPanel.this.playCurrentlySelectedReceiver();
            }
        };
        this.playReceiverButtonAction.putValue("ShortDescription", "Resumes the selected Node");
        this.playReceiverButtonAction.putValue("Name", "Resume");
        this.playReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_RESUME_RECEIVER));
        this.playReceiverButtonAction.setEnabled(false);
        this.playReceiverButtonAction.putValue("MnemonicKey", new Integer(82));
        this.pauseReceiverButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReceiversPanel.this.pauseCurrentlySelectedReceiver();
            }
        };
        this.pauseReceiverButtonAction.putValue("ShortDescription", "Pause the selected Receiver.  All events received will be discarded.");
        this.pauseReceiverButtonAction.putValue("Name", "Pause");
        this.pauseReceiverButtonAction.putValue("MnemonicKey", new Integer(80));
        this.pauseReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.PAUSE));
        this.pauseReceiverButtonAction.setEnabled(false);
        this.shutdownReceiverButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReceiversPanel.this.shutdownCurrentlySelectedReceiver();
            }
        };
        this.shutdownReceiverButtonAction.putValue("ShortDescription", "Shuts down the selected Receiver, and removes it from the Plugin registry");
        this.shutdownReceiverButtonAction.putValue("Name", "Shutdown");
        this.shutdownReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_STOP_RECEIVER));
        this.shutdownReceiverButtonAction.putValue("MnemonicKey", new Integer(83));
        this.shutdownReceiverButtonAction.setEnabled(false);
        this.restartReceiverButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Receiver receiver = ReceiversPanel.this.getCurrentlySelectedReceiver();
                if (receiver == null) {
                    return;
                }
                receiver.shutdown();
                receiver.activateOptions();
            }
        };
        this.restartReceiverButtonAction.putValue("ShortDescription", "Restarts the selected Receiver");
        this.restartReceiverButtonAction.putValue("Name", "Restart");
        this.restartReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_RESTART));
        this.restartReceiverButtonAction.putValue("MnemonicKey", new Integer(82));
        this.restartReceiverButtonAction.setEnabled(false);
        this.showReceiverHelpAction = new AbstractAction("Help"){

            public void actionPerformed(ActionEvent actionEvent) {
                Receiver receiver = ReceiversPanel.this.getCurrentlySelectedReceiver();
                if (receiver != null) {
                    HelpManager.getInstance().showHelpForClass(receiver.getClass());
                }
            }
        };
        this.showReceiverHelpAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.HELP));
        this.showReceiverHelpAction.putValue("ShortDescription", "Displays the JavaDoc page for this Plugin");
        this.startAllAction = new AbstractAction("(Re)start All Receivers", new ImageIcon(ChainsawIcons.ICON_RESTART_ALL)){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JOptionPane.showConfirmDialog(null, "This will cause any active Receiver to stop, and disconnect.  Is this ok?", "Confirm", 2) == 0) {
                    new Thread(new Runnable(this){
                        private final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            List list = ReceiversPanel.access$900(10.access$800(this.this$1)).getPlugins(class$org$apache$log4j$plugins$Receiver == null ? (class$org$apache$log4j$plugins$Receiver = ReceiversPanel.class$("org.apache.log4j.plugins.Receiver")) : class$org$apache$log4j$plugins$Receiver);
                            Iterator<E> iterator = list.iterator();
                            while (iterator.hasNext()) {
                                Receiver receiver = (Receiver)iterator.next();
                                receiver.shutdown();
                                receiver.activateOptions();
                            }
                            10.access$800(this.this$1).updateReceiverTreeInDispatchThread();
                            MessageCenter.getInstance().getLogger().info("All Receivers have been (re)started");
                        }
                    }).start();
                }
            }

            static /* synthetic */ ReceiversPanel access$800(10 var0) {
                return var0.ReceiversPanel.this;
            }
        };
        this.startAllAction.putValue("ShortDescription", "Ensures that any Receiver that isn't active, is started, and any started action is stopped, and then restarted");
        this.receiversTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.receiversTree.setCellRenderer(new ReceiverTreeCellRenderer());
        this.buttonPanel = new ReceiverToolbar();
        this.receiversTree.addTreeSelectionListener(this.buttonPanel);
        PopupListener popupListener = new PopupListener(this.popupMenu);
        this.receiversTree.addMouseListener(popupListener);
        this.addMouseListener(popupListener);
        JTree jTree = this.receiversTree;
        JScrollPane jScrollPane = new JScrollPane(jTree);
        this.splitter.setOrientation(0);
        this.splitter.setTopComponent(jScrollPane);
        this.splitter.setBottomComponent(this.pluginEditorPanel);
        this.splitter.setResizeWeight(0.7);
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.splitter, "Center");
        SocketNodeEventListener socketNodeEventListener = new SocketNodeEventListener(){

            public void socketOpened(String string) {
                ReceiversPanel.this.updateReceiverTreeInDispatchThread();
            }

            public void socketClosedEvent(Exception exception) {
                ReceiversPanel.this.updateReceiverTreeInDispatchThread();
            }
        };
        List list = this.pluginRegistry.getPlugins(class$org$apache$log4j$net$SocketReceiver == null ? (class$org$apache$log4j$net$SocketReceiver = ReceiversPanel.class$("org.apache.log4j.net.SocketReceiver")) : class$org$apache$log4j$net$SocketReceiver);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SocketReceiver socketReceiver = (SocketReceiver)iterator.next();
            socketReceiver.addSocketNodeEventListener(socketNodeEventListener);
        }
    }

    protected ReceiversTreeModel getReceiverTreeModel() {
        return (ReceiversTreeModel)this.receiversTree.getModel();
    }

    protected void updateCurrentlySelectedNodeInDispatchThread() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ReceiversPanel.this.receiversTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                ReceiversPanel.this.getReceiverTreeModel().nodeChanged(defaultMutableTreeNode);
                ReceiversPanel.this.updateActions();
            }
        });
    }

    private Receiver getCurrentlySelectedReceiver() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.receiversTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof Receiver) {
            return (Receiver)object;
        }
        return null;
    }

    private Receiver[] getSelectedReceivers() {
        TreePath[] treePathArray = this.receiversTree.getSelectionPaths();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == null || !(defaultMutableTreeNode.getUserObject() instanceof Receiver)) continue;
            arrayList.add(defaultMutableTreeNode.getUserObject());
        }
        return arrayList.toArray(new Receiver[0]);
    }

    private Object getCurrentlySelectedUserObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.receiversTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return defaultMutableTreeNode.getUserObject();
    }

    private void pauseCurrentlySelectedReceiver() {
        new Thread(new Runnable(){

            public void run() {
                Object object = ReceiversPanel.this.getCurrentlySelectedUserObject();
                if (object != null && object instanceof Pauseable) {
                    ((Pauseable)object).setPaused(true);
                    ReceiversPanel.this.updateCurrentlySelectedNodeInDispatchThread();
                }
            }
        }).start();
    }

    private void playCurrentlySelectedReceiver() {
        new Thread(new Runnable(){

            public void run() {
                Object object = ReceiversPanel.this.getCurrentlySelectedUserObject();
                if (object != null && object instanceof Pauseable) {
                    ((Pauseable)object).setPaused(false);
                    ReceiversPanel.this.updateCurrentlySelectedNodeInDispatchThread();
                }
            }
        }).start();
    }

    private void shutdownCurrentlySelectedReceiver() {
        if (JOptionPane.showConfirmDialog(null, "Are you sure you wish to shutdown this receiver?\n\nThis will disconnect any network resources, and remove it from the PluginRegistry.", "Confirm stop of Receiver", 0) == 0) {
            new Thread(new Runnable(){

                public void run() {
                    Receiver[] receiverArray = ReceiversPanel.this.getSelectedReceivers();
                    if (receiverArray != null) {
                        for (int i = 0; i < receiverArray.length; ++i) {
                            ReceiversPanel.this.pluginRegistry.stopPlugin(receiverArray[i].getName());
                        }
                    }
                }
            }).start();
        }
    }

    private void updateActions() {
        Object object = this.getCurrentlySelectedUserObject();
        if (object != null && object instanceof Pauseable) {
            Pauseable pauseable = (Pauseable)object;
            if (!pauseable.isPaused()) {
                this.pauseReceiverButtonAction.setEnabled(true);
                this.playReceiverButtonAction.setEnabled(false);
            } else {
                this.pauseReceiverButtonAction.setEnabled(false);
                this.playReceiverButtonAction.setEnabled(true);
            }
        } else {
            this.pauseReceiverButtonAction.setEnabled(false);
            this.playReceiverButtonAction.setEnabled(false);
        }
        if (object instanceof Receiver) {
            this.newReceiverButtonAction.setEnabled(true);
            this.shutdownReceiverButtonAction.setEnabled(true);
            this.restartReceiverButtonAction.setEnabled(true);
        } else {
            this.shutdownReceiverButtonAction.setEnabled(false);
            this.restartReceiverButtonAction.setEnabled(false);
        }
    }

    public void updateReceiverTreeInDispatchThread() {
        LogLog.debug("updateReceiverTreeInDispatchThread, should not be needed now");
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        super.setVisible(bl);
        this.firePropertyChange("visible", bl2, this.isVisible());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ReceiverToolbar
    extends JToolBar
    implements TreeSelectionListener {
        final SmallButton newReceiverButton;

        private ReceiverToolbar() {
            this.setFloatable(false);
            SmallButton smallButton = new SmallButton(ReceiversPanel.this.restartReceiverButtonAction);
            smallButton.setText(null);
            SmallButton smallButton2 = new SmallButton(ReceiversPanel.this.shutdownReceiverButtonAction);
            smallButton2.setText(null);
            SmallButton smallButton3 = new SmallButton(ReceiversPanel.this.startAllAction);
            smallButton3.setText(null);
            this.newReceiverButton = new SmallButton(ReceiversPanel.this.newReceiverButtonAction);
            this.newReceiverButton.setText(null);
            this.newReceiverButton.addMouseListener(new PopupListener(ReceiversPanel.this.newReceiverPopup));
            this.add(this.newReceiverButton);
            this.add(smallButton3);
            this.addSeparator();
            this.add(smallButton);
            this.add(smallButton2);
            this.addSeparator();
            AbstractAction abstractAction = new AbstractAction(this, null, LineIconFactory.createCloseIcon(), ReceiversPanel.this){
                private final /* synthetic */ ReceiversPanel val$this$0;
                private final /* synthetic */ ReceiverToolbar this$1;
                {
                    this.this$1 = receiverToolbar;
                    this.val$this$0 = receiversPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ReceiverToolbar.access$1900(this.this$1).setVisible(false);
                }
            };
            abstractAction.putValue("ShortDescription", "Closes the Receiver panel");
            this.add(Box.createHorizontalGlue());
            this.add(new SmallButton(abstractAction));
            this.add(Box.createHorizontalStrut(5));
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            ReceiversPanel.this.updateActions();
        }

        static /* synthetic */ ReceiversPanel access$1900(ReceiverToolbar receiverToolbar) {
            return receiverToolbar.ReceiversPanel.this;
        }
    }

    class ReceiverPopupMenu
    extends JPopupMenu {
        ReceiverPopupMenu() {
        }

        public void show(Component component, int n, int n2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ReceiversPanel.this.receiversTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            Object object = defaultMutableTreeNode.getUserObject();
            this.removeAll();
            if (object == this.getRootOfTree().getUserObject()) {
                this.buildForReceiversRoot();
            } else if (ReceiversPanel.this.getCurrentlySelectedReceiver() != null) {
                this.buildForReceiverNode();
            } else {
                return;
            }
            this.invalidate();
            this.validate();
            super.show(component, n, n2);
        }

        private DefaultMutableTreeNode getRootOfTree() {
            return (DefaultMutableTreeNode)ReceiversPanel.this.receiversTree.getModel().getRoot();
        }

        private void buildForReceiverNode() {
            this.add(ReceiversPanel.this.playReceiverButtonAction);
            this.add(ReceiversPanel.this.pauseReceiverButtonAction);
            this.add(ReceiversPanel.this.restartReceiverButtonAction);
            this.add(ReceiversPanel.this.shutdownReceiverButtonAction);
            this.addSeparator();
            Receiver receiver = ReceiversPanel.this.getCurrentlySelectedReceiver();
            this.add(this.createLevelRadioButton(receiver, Level.DEBUG));
            this.add(this.createLevelRadioButton(receiver, Level.INFO));
            this.add(this.createLevelRadioButton(receiver, Level.WARN));
            this.add(this.createLevelRadioButton(receiver, Level.ERROR));
            this.addSeparator();
            this.add(this.createLevelRadioButton(receiver, Level.OFF));
            this.add(this.createLevelRadioButton(receiver, Level.ALL));
            this.addSeparator();
            this.add(ReceiversPanel.this.showReceiverHelpAction);
        }

        private JRadioButtonMenuItem createLevelRadioButton(Receiver receiver, Level level) {
            Map map = LevelIconFactory.getInstance().getLevelToIconMap();
            AbstractAction abstractAction = new AbstractAction(this, level.toString(), (Icon)map.get(level.toString()), receiver, level){
                private final /* synthetic */ Receiver val$r;
                private final /* synthetic */ Level val$l;
                private final /* synthetic */ ReceiverPopupMenu this$1;
                {
                    this.this$1 = receiverPopupMenu;
                    this.val$r = receiver;
                    this.val$l = level;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$r != null) {
                        this.val$r.setThreshold(this.val$l);
                        ReceiverPopupMenu.access$1700(this.this$1).updateCurrentlySelectedNodeInDispatchThread();
                    }
                }
            };
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(abstractAction);
            jRadioButtonMenuItem.setSelected(receiver.getThreshold() == level);
            return jRadioButtonMenuItem;
        }

        private void buildForReceiversRoot() {
            JMenuItem jMenuItem = new JMenuItem(ReceiversPanel.this.startAllAction);
            this.add(ReceiversPanel.this.newReceiverButtonAction);
            this.addSeparator();
            this.add(jMenuItem);
        }

        static /* synthetic */ ReceiversPanel access$1700(ReceiverPopupMenu receiverPopupMenu) {
            return receiverPopupMenu.ReceiversPanel.this;
        }
    }

    class NewReceiverPopupMenu
    extends JPopupMenu {
        NewReceiverPopupMenu() {
            try {
                List list = ReceiversHelper.getInstance().getKnownReceiverClasses();
                String string = null;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Class clazz = (Class)iterator.next();
                    Package package_ = clazz.getPackage();
                    String string2 = clazz.getName().substring(package_.getName().length() + 1);
                    if (string == null) {
                        string = string2.substring(0, 1);
                    } else {
                        String string3 = string2.substring(0, 1);
                        if (!string3.equals(string)) {
                            this.addSeparator();
                            string = string3;
                        }
                    }
                    this.add(new AbstractAction(this, "New " + string2 + "...", ReceiversPanel.this, clazz){
                        private final /* synthetic */ ReceiversPanel val$this$0;
                        private final /* synthetic */ Class val$toCreate;
                        private final /* synthetic */ NewReceiverPopupMenu this$1;
                        {
                            this.this$1 = newReceiverPopupMenu;
                            this.val$this$0 = receiversPanel;
                            this.val$toCreate = clazz;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            Container container = SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ReceiversPanel.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, NewReceiverPopupMenu.access$1400(this.this$1));
                            JDialog jDialog = new JDialog((JFrame)container, "New " + this.val$toCreate.getName() + "...", true);
                            try {
                                NewReceiverDialogPanel newReceiverDialogPanel = NewReceiverDialogPanel.create(this.val$toCreate);
                                jDialog.getContentPane().add(newReceiverDialogPanel);
                                jDialog.pack();
                                SwingHelper.centerOnScreen(jDialog);
                                jDialog.getRootPane().setDefaultButton(newReceiverDialogPanel.getOkPanel().getOkButton());
                                SwingHelper.configureCancelForDialog(jDialog, newReceiverDialogPanel.getOkPanel().getCancelButton());
                                newReceiverDialogPanel.getOkPanel().getOkButton().addActionListener(new ActionListener(this, jDialog, newReceiverDialogPanel){
                                    private final /* synthetic */ JDialog val$dialog;
                                    private final /* synthetic */ NewReceiverDialogPanel val$panel;
                                    private final /* synthetic */ 17 this$2;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$dialog = jDialog;
                                        this.val$panel = newReceiverDialogPanel;
                                    }

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        this.val$dialog.dispose();
                                        Plugin plugin = this.val$panel.getPlugin();
                                        ReceiversPanel.access$900(NewReceiverPopupMenu.access$1400(17.access$1500(this.this$2))).addPlugin(plugin);
                                        plugin.activateOptions();
                                        MessageCenter.getInstance().addMessage("Plugin '" + plugin.getName() + "' started");
                                    }
                                });
                                jDialog.show();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                MessageCenter.getInstance().getLogger().error("Failed to create the new Receiver dialog", exception);
                            }
                        }

                        static /* synthetic */ NewReceiverPopupMenu access$1500(17 var0) {
                            return var0.this$1;
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception.getMessage());
            }
        }

        static /* synthetic */ ReceiversPanel access$1400(NewReceiverPopupMenu newReceiverPopupMenu) {
            return newReceiverPopupMenu.ReceiversPanel.this;
        }
    }
}

