/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.chainsaw.plugins.PluginClassLoaderFactory;
import org.apache.log4j.helpers.LogLog;

public class ReceiversHelper {
    private static final ReceiversHelper instance = new ReceiversHelper();
    private List receiverClassList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ReceiversHelper() {
        String string;
        URL uRL = this.getClass().getClassLoader().getResource(this.getClass().getPackage().getName().replace('.', '/') + "/known.receivers");
        LineNumberReader lineNumberReader = null;
        lineNumberReader = new LineNumberReader(new InputStreamReader(uRL.openStream()));
        ClassLoader classLoader = PluginClassLoaderFactory.getInstance().getClassLoader();
        while ((string = lineNumberReader.readLine()) != null) {
            try {
                if (string.startsWith("#") || string.length() == 0) continue;
                Class<?> clazz = classLoader.loadClass(string);
                this.receiverClassList.add(clazz);
                LogLog.debug("Located known Receiver class " + clazz.getName());
            }
            catch (Exception exception) {
                LogLog.error("Failed to locate Receiver class:" + string, exception);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                LogLog.error("Failed to locate Receiver class:" + string + ", looks like a dependent class is missing from the classpath", noClassDefFoundError);
            }
        }
        Object var7_9 = null;
        if (lineNumberReader == null) return;
        try {
            lineNumberReader.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var7_10 = null;
                if (lineNumberReader == null) return;
                try {
                    lineNumberReader.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (lineNumberReader == null) throw throwable;
            try {
                lineNumberReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    public static ReceiversHelper getInstance() {
        return instance;
    }

    public List getKnownReceiverClasses() {
        return Collections.unmodifiableList(this.receiverClassList);
    }
}

