/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.icons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.helpers.LogLog;

public final class LineIconFactory {
    private LineIconFactory() {
    }

    public static final Icon createExpandIcon() {
        int n = 8;
        int n2 = 0;
        int n3 = 0;
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            BufferedImage bufferedImage = new BufferedImage(n, n, 2);
            Graphics2D graphics2D = graphicsEnvironment.createGraphics(bufferedImage);
            graphics2D.setBackground(new Color(0, 0, 0, 0));
            graphics2D.clearRect(0, 0, n, n);
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(n2, n / 2 + n3, n - n2, n / 2 + n3);
            graphics2D.drawLine(n2 + n / 2, n3, n2 + n / 2, n + n3);
            return new ImageIcon(bufferedImage);
        }
        catch (Exception exception) {
            LogLog.error("failed to create a Expand icon", exception);
            return null;
        }
    }

    public static final Icon createCollapseIcon() {
        int n = 8;
        int n2 = 0;
        int n3 = 0;
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            BufferedImage bufferedImage = new BufferedImage(n, n, 2);
            Graphics2D graphics2D = graphicsEnvironment.createGraphics(bufferedImage);
            graphics2D.setBackground(new Color(0, 0, 0, 0));
            graphics2D.clearRect(0, 0, n, n);
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(n2, n / 2 + n3, n - n2, n / 2 + n3);
            return new ImageIcon(bufferedImage);
        }
        catch (Exception exception) {
            LogLog.error("failed to create a Collapse icon", exception);
            return null;
        }
    }

    public static final Icon createCloseIcon() {
        return new CloseIcon(8, 0, 0);
    }

    public static final Icon createBlankIcon() {
        return new BlankIcon(16);
    }

    private static class CloseIcon
    implements Icon {
        int size;
        int xOffSet;
        int yOffSet;

        public CloseIcon(int n, int n2, int n3) {
            this.size = n;
            this.xOffSet = n2;
            this.yOffSet = n3;
        }

        public int getIconHeight() {
            return this.size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(n + this.xOffSet, n2 + this.yOffSet, n + this.size + this.xOffSet, n2 + this.size + this.yOffSet);
            graphics2D.drawLine(n + this.xOffSet, n2 + this.size + this.yOffSet, n + this.size + this.xOffSet, n2 + this.yOffSet);
        }
    }

    private static class BlankIcon
    implements Icon {
        int size;

        public BlankIcon(int n) {
            this.size = n;
        }

        public int getIconHeight() {
            return this.size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }
}

