/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.help;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.help.HelpLocator;
import org.apache.log4j.helpers.LogLog;

public final class HelpManager {
    private static final HelpManager instance = new HelpManager();
    private HelpLocator helpLocator = new HelpLocator();
    private URL helpURL;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    private HelpManager() {
        try {
            if (System.getProperty("log4j.chainsaw.localDocs") != null) {
                LogLog.info("Adding HelpLocator for localDocs property=" + System.getProperty("log4j.chainsaw.localDocs"));
                this.helpLocator.installLocator(new URL(System.getProperty("log4j.chainsaw.localDocs")));
            } else if (new File("docs/api").exists()) {
                File file = new File("docs/api");
                LogLog.info("Detected Local JavaDocs at " + file.toString());
                this.helpLocator.installLocator(file.toURL());
            } else {
                LogLog.warn("Could not find any local JavaDocs, you might want to consider running 'ant javadoc'. The release version will be able to access Javadocs from the Apache website.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.helpLocator.installClassloaderLocator(this.getClass().getClassLoader());
    }

    public final URL getHelpURL() {
        return this.helpURL;
    }

    public final void setHelpURL(URL uRL) {
        this.helpURL = uRL;
        this.firePropertyChange("helpURL", null, this.helpURL);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.propertySupport.firePropertyChange(propertyChangeEvent);
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.propertySupport.firePropertyChange(string, bl, bl2);
    }

    public void firePropertyChange(String string, int n, int n2) {
        this.propertySupport.firePropertyChange(string, n, n2);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.propertySupport.firePropertyChange(string, object, object2);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public static HelpManager getInstance() {
        return instance;
    }

    public void showHelpForClass(Class clazz) {
        URL uRL = this.getHelpForClass(clazz);
        this.setHelpURL(uRL);
    }

    public URL getHelpForClass(Class clazz) {
        String string = clazz.getName();
        string = string.replace('.', '/') + ".html";
        URL uRL = this.helpLocator.findResource(string);
        LogLog.debug("located help resource for '" + string + "' at " + (uRL == null ? "" : uRL.toExternalForm()));
        return uRL != null ? uRL : ChainsawConstants.URL_PAGE_NOT_FOUND;
    }
}

