/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.chainsaw.ChainsawColumns;
import org.apache.log4j.chainsaw.prefs.SettingsManager;

public class LogPanelPreferenceModel
implements Serializable {
    public static final String ISO8601 = "ISO8601";
    public static final Collection DATE_FORMATS;
    private final transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private String dateFormatPattern = "ISO8601";
    private boolean levelIcons;
    private Set visibleColumns = new HashSet(ChainsawColumns.getColumnsNames());
    private boolean detailPaneVisible;
    private boolean toolTips;
    private boolean scrollToBottom;
    private boolean logTreePanelVisible;
    private String loggerPrecision = "";

    public final String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public final void setDateFormatPattern(String string) {
        String string2 = this.dateFormatPattern;
        this.dateFormatPattern = string;
        this.propertySupport.firePropertyChange("dateFormatPattern", string2, this.dateFormatPattern);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void apply(LogPanelPreferenceModel logPanelPreferenceModel) {
        Object object;
        this.setLoggerPrecision(logPanelPreferenceModel.getLoggerPrecision());
        this.setDateFormatPattern(logPanelPreferenceModel.getDateFormatPattern());
        this.setLevelIcons(logPanelPreferenceModel.isLevelIcons());
        this.setToolTips(logPanelPreferenceModel.isToolTips());
        this.setScrollToBottom(logPanelPreferenceModel.isScrollToBottom());
        this.setDetailPaneVisible(logPanelPreferenceModel.isDetailPaneVisible());
        this.setLogTreePanelVisible(logPanelPreferenceModel.isLogTreePanelVisible());
        Object object2 = logPanelPreferenceModel.visibleColumns.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (this.visibleColumns.contains(object)) continue;
            this.setColumnVisible((String)object, true);
        }
        object2 = new HashSet(this.visibleColumns);
        object = object2.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (logPanelPreferenceModel.visibleColumns.contains(string)) continue;
            this.setColumnVisible(string, false);
        }
    }

    public boolean isUseISO8601Format() {
        return this.getDateFormatPattern().equals(ISO8601);
    }

    public boolean isLevelIcons() {
        return this.levelIcons;
    }

    public void setLevelIcons(boolean bl) {
        boolean bl2 = this.levelIcons;
        this.levelIcons = bl;
        this.propertySupport.firePropertyChange("levelIcons", bl2, this.levelIcons);
    }

    public void setLoggerPrecision(String string) {
        String string2 = this.loggerPrecision;
        this.loggerPrecision = string;
        this.propertySupport.firePropertyChange("loggerPrecision", string2, this.loggerPrecision);
    }

    public final String getLoggerPrecision() {
        return this.loggerPrecision;
    }

    public boolean isColumnVisible(String string) {
        return this.visibleColumns.contains(string);
    }

    public void setColumnVisible(String string, boolean bl) {
        boolean bl2 = this.visibleColumns.contains(string);
        boolean bl3 = bl;
        if (bl) {
            this.visibleColumns.add(string);
        } else {
            this.visibleColumns.remove(string);
        }
        this.propertySupport.firePropertyChange(new PropertyChangeEvent(this, "visibleColumns", new Boolean(bl2), new Boolean(bl3)));
    }

    public void toggleColumn(String string) {
        this.setColumnVisible(string, !this.isColumnVisible(string));
    }

    public final boolean isDetailPaneVisible() {
        return this.detailPaneVisible;
    }

    public final void setDetailPaneVisible(boolean bl) {
        boolean bl2 = this.detailPaneVisible;
        this.detailPaneVisible = bl;
        this.propertySupport.firePropertyChange("detailPaneVisible", bl2, this.detailPaneVisible);
    }

    public final boolean isScrollToBottom() {
        return this.scrollToBottom;
    }

    public final void setScrollToBottom(boolean bl) {
        boolean bl2 = this.scrollToBottom;
        this.scrollToBottom = bl;
        this.propertySupport.firePropertyChange("scrollToBottom", bl2, this.scrollToBottom);
    }

    public final boolean isToolTips() {
        return this.toolTips;
    }

    public final void setToolTips(boolean bl) {
        boolean bl2 = this.toolTips;
        this.toolTips = bl;
        this.propertySupport.firePropertyChange("toolTips", bl2, this.toolTips);
    }

    public final boolean isLogTreePanelVisible() {
        return this.logTreePanelVisible;
    }

    public final void setLogTreePanelVisible(boolean bl) {
        boolean bl2 = this.logTreePanelVisible;
        this.logTreePanelVisible = bl;
        this.propertySupport.firePropertyChange("logTreePanelVisible", bl2, this.logTreePanelVisible);
    }

    public boolean isCustomDateFormat() {
        return !DATE_FORMATS.contains(this.getDateFormatPattern()) && !this.isUseISO8601Format();
    }

    static {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Properties properties = SettingsManager.getInstance().getDefaultSettings();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (!entry.getKey().toString().startsWith("DateFormat")) continue;
            arrayList.add(entry.getValue());
        }
        DATE_FORMATS = Collections.unmodifiableCollection(arrayList);
    }
}

