/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.QSYSObjectPathName;
import java.util.Calendar;

public class OS400Utilities {
    public static String convertIntToString(int n) {
        String string = null;
        string = n < 10 ? "0" + Integer.toString(n) : Integer.toString(n);
        return string;
    }

    public static int convertObjectToInt(Object object) {
        return new Integer(object.toString().trim());
    }

    public static long convertObjectToLong(Object object) {
        return new Long(object.toString().trim());
    }

    public static String formatQualifiedName(String string) {
        String string2 = string.trim();
        String string3 = "";
        if (string2.length() > 10) {
            String string4 = string2.substring(0, 10);
            String string5 = string2.substring(10);
            string3 = string5.trim() + "/" + string4.trim();
        } else {
            string3 = string2;
        }
        return string3;
    }

    public static String formatQualifiedNameFromIFSPath(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return OS400Utilities.formatQualifiedName(string);
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        String string2 = qSYSObjectPathName.getLibraryName().trim() + "/" + qSYSObjectPathName.getObjectName().trim();
        return string2;
    }

    public static String buildIFSPath(String string, String string2, String string3) {
        String string4 = null;
        String string5 = string3.substring(0, 1);
        string4 = string5.equals("*") || string5.equals(".") ? string3.substring(1) : string3;
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, string2, string4);
        return qSYSObjectPathName.getPath();
    }

    public static String[] parseLibraryList(String string, int n) {
        String[] stringArray = null;
        int n2 = 10 + n;
        int n3 = string.length();
        int n4 = n3 / n2;
        int n5 = n3 % n2;
        stringArray = n5 > 0 ? new String[n4 + 1] : new String[n4];
        for (int i = 0; i < n4; ++i) {
            stringArray[i] = string.substring(i * n2, i * n2 + n2).trim();
        }
        if (n5 > 0) {
            stringArray[n4] = string.substring(n4 * n2).trim();
        }
        return stringArray;
    }

    public static long convertDateStringToLong(String string) {
        Calendar calendar;
        block5: {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (string == null) {
                return 0L;
            }
            calendar = Calendar.getInstance();
            try {
                if (string.trim().length() == 7) {
                    n = Integer.parseInt(string.substring(0, 3)) + 1900;
                    n2 = Integer.parseInt(string.substring(3, 5));
                    n3 = Integer.parseInt(string.substring(5, 7));
                    calendar.set(n, n2 - 1, n3);
                    break block5;
                }
                if (string.trim().length() == 13) {
                    n = Integer.parseInt(string.substring(0, 3)) + 1900;
                    n2 = Integer.parseInt(string.substring(3, 5));
                    n3 = Integer.parseInt(string.substring(5, 7));
                    n4 = Integer.parseInt(string.substring(7, 9));
                    n5 = Integer.parseInt(string.substring(9, 11));
                    n6 = Integer.parseInt(string.substring(11, 13));
                    calendar.set(n, n2 - 1, n3, n4, n5, n6);
                    break block5;
                }
                return 0L;
            }
            catch (Exception exception) {
                return 0L;
            }
        }
        return calendar.getTimeInMillis();
    }

    public static String convertAS400ExceptionToString(AS400Exception aS400Exception) {
        AS400Message[] aS400MessageArray = aS400Exception.getAS400MessageList();
        if (aS400MessageArray == null) {
            return aS400Exception.getMessage();
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            String string2 = aS400MessageArray[i].getID();
            String string3 = aS400MessageArray[i].getText();
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2 + " - " + string3);
        }
        return stringBuffer.toString();
    }
}

