/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.NetworkUtils;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.log4j.Logger;

public class OS400HostServers {
    private static Logger logger = Logger.getLogger(OS400HostServers.class);
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler((String)OS400HostServers.class.getName());
    private static String[] recoveryOptions = new String[4];

    private OS400HostServers() {
    }

    public static InetAddress checkDCHostServers(String string) throws ResourceUnavailableException {
        InetAddress inetAddress = null;
        logger.debug((Object)("Testing port 8476 on system " + string));
        try {
            inetAddress = NetworkUtils.resolveAndConnect((String)string, (int)8476);
        }
        catch (IOException iOException) {
            ResourceUnavailableException resourceUnavailableException = new ResourceUnavailableException(rbh.getMsg("unable_to_connect", (Object)string), (Throwable)iOException);
            resourceUnavailableException.setRecoveryOptions(recoveryOptions);
            throw resourceUnavailableException;
        }
        logger.debug((Object)("Testing port 8471 on system " + string));
        try {
            NetworkUtils.connect((InetAddress)inetAddress, (int)8471);
        }
        catch (IOException iOException) {
            ResourceUnavailableException resourceUnavailableException = new ResourceUnavailableException(rbh.getMsg("server_not_started", (Object)"*DATABASE", (Object)string), (Throwable)iOException);
            resourceUnavailableException.setRecoveryOptions(recoveryOptions);
            throw resourceUnavailableException;
        }
        logger.debug((Object)("Testing port 8473 on system " + string));
        try {
            NetworkUtils.connect((InetAddress)inetAddress, (int)8473);
        }
        catch (IOException iOException) {
            ResourceUnavailableException resourceUnavailableException = new ResourceUnavailableException(rbh.getMsg("server_not_started", (Object)"*FILE", (Object)string), (Throwable)iOException);
            resourceUnavailableException.setRecoveryOptions(recoveryOptions);
            throw resourceUnavailableException;
        }
        logger.debug((Object)("Testing port 8474 on system " + string));
        try {
            NetworkUtils.connect((InetAddress)inetAddress, (int)8474);
        }
        catch (IOException iOException) {
            ResourceUnavailableException resourceUnavailableException = new ResourceUnavailableException(rbh.getMsg("server_not_started", (Object)"*NETPRT", (Object)string), (Throwable)iOException);
            resourceUnavailableException.setRecoveryOptions(recoveryOptions);
            throw resourceUnavailableException;
        }
        logger.debug((Object)("Testing port 8475 on system " + string));
        try {
            NetworkUtils.connect((InetAddress)inetAddress, (int)8475);
        }
        catch (IOException iOException) {
            ResourceUnavailableException resourceUnavailableException = new ResourceUnavailableException(rbh.getMsg("server_not_started", (Object)"*RMTCMD", (Object)string), (Throwable)iOException);
            resourceUnavailableException.setRecoveryOptions(recoveryOptions);
            throw resourceUnavailableException;
        }
        return inetAddress;
    }

    static {
        OS400HostServers.recoveryOptions[0] = rbh.getMsg("recover1");
        OS400HostServers.recoveryOptions[1] = rbh.getMsg("recover2");
        OS400HostServers.recoveryOptions[2] = rbh.getMsg("recover3");
        OS400HostServers.recoveryOptions[3] = rbh.getMsg("recover4");
    }
}

