/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import org.apache.log4j.Logger;

public class ListInformation {
    private static final Logger logger = Logger.getLogger(ListInformation.class);
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(ListInformation.class);
    public static final String MISSING_SYSTEM = rbh.getText("the_system_is_null");
    public static final String NULL_LIST = rbh.getText("the_list_info_is_null");
    public static final String CHAR_CONV_ERROR = rbh.getText("character_converter_error");
    private int totalRecords;
    private int recordsReturned;
    private byte[] requestHandle;
    private int recordLength;
    private int lengthReturned;
    private int firstRecordNumber;
    private String infoCompleteIndicator;
    private String listStatus;
    private String dateReturned;
    private byte[] listData;

    public int getTotalRecords() {
        return this.totalRecords;
    }

    private void setTotalRecords(int n) {
        this.totalRecords = n;
    }

    public int getRecordsReturned() {
        return this.recordsReturned;
    }

    public void setRecordsReturned(int n) {
        this.recordsReturned = n;
    }

    public byte[] getRequestHandle() {
        return this.requestHandle;
    }

    private void setRequestHandle(byte[] byArray) {
        this.requestHandle = byArray;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    private void setRecordLength(int n) {
        this.recordLength = n;
    }

    public int getLengthReturned() {
        return this.lengthReturned;
    }

    private void setLengthReturned(int n) {
        this.lengthReturned = n;
    }

    public int getFirstRecordNumber() {
        return this.firstRecordNumber;
    }

    public void setFirstRecordNumber(int n) {
        this.firstRecordNumber = n;
    }

    public String getInfoCompleteIndicator() {
        return this.infoCompleteIndicator;
    }

    private void setInfoCompleteIndicator(String string) {
        this.infoCompleteIndicator = string;
    }

    public String getListStatus() {
        return this.listStatus;
    }

    private void setListStatus(String string) {
        this.listStatus = string;
    }

    public String getDateReturned() {
        return this.dateReturned;
    }

    private void setDateReturned(String string) {
        this.dateReturned = string;
    }

    public byte[] getListData() {
        return this.listData;
    }

    private void setListData(byte[] byArray) {
        this.listData = byArray;
    }

    public void setList(AS400 aS400, byte[] byArray, byte[] byArray2) {
        CharConverter charConverter;
        if (aS400 == null) {
            throw new NullPointerException(MISSING_SYSTEM);
        }
        if (byArray == null) {
            throw new NullPointerException(NULL_LIST);
        }
        try {
            charConverter = new CharConverter(aS400.getCcsid(), aS400);
        }
        catch (Exception exception) {
            logger.debug((Object)CHAR_CONV_ERROR, (Throwable)exception);
            throw new RuntimeException(CHAR_CONV_ERROR);
        }
        this.setTotalRecords(BinaryConverter.byteArrayToInt((byte[])byArray, (int)0));
        this.setRecordsReturned(BinaryConverter.byteArrayToInt((byte[])byArray, (int)4));
        byte[] byArray3 = new byte[4];
        System.arraycopy(byArray, 8, byArray3, 0, 4);
        this.setRequestHandle(byArray3);
        this.setRecordLength(BinaryConverter.byteArrayToInt((byte[])byArray, (int)12));
        this.setInfoCompleteIndicator(charConverter.byteArrayToString(byArray, 16, 1));
        this.setDateReturned(charConverter.byteArrayToString(byArray, 17, 13));
        this.setListStatus(charConverter.byteArrayToString(byArray, 30, 1));
        this.setLengthReturned(BinaryConverter.byteArrayToInt((byte[])byArray, (int)32));
        this.setFirstRecordNumber(BinaryConverter.byteArrayToInt((byte[])byArray, (int)36));
        this.setListData(byArray2);
    }
}

