/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.schedule;

import com.helpsystems.common.as400.access.CcsidManager;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.PlatformSpecificNameValidator;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.Arrays;

public class CommonNameValidatorRsvCmdVar
implements PlatformSpecificNameValidator {
    public static final int MAX_LENGTH_NAME = 10;
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(CommonNameValidatorRsvCmdVar.class);
    private static final String validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789@#$_.";
    private static final byte[] validBytes = CcsidManager.charConverterCcsid37().stringToByteArray("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789@#$_.");
    private CcsidManager ccsidManager;

    public CommonNameValidatorRsvCmdVar(CcsidManager ccsidManager) {
        ValidationHelper.checkForNull((String)"CCSID Manager", (Object)((Object)ccsidManager));
        this.ccsidManager = ccsidManager;
    }

    public void validateName(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            String string3 = "validateName arguments: fieldName  and fieldValue cannot be null or empty.";
            throw new IllegalArgumentException(string3);
        }
        if (string2.length() > 10) {
            throw new IllegalArgumentException(rbh.getMsg("exceeds_max_length", (Object)string, (Object)string2));
        }
        String string4 = Convert.trimR((String)string2);
        if (-1 != string4.indexOf(32)) {
            throw new IllegalArgumentException(rbh.getMsg("cannot_contain_an_embedded_blank", (Object)string, (Object)string2));
        }
        byte[] byArray = this.ccsidManager.charConverterForGui().stringToByteArray(string4);
        for (int i = 0; i < byArray.length; ++i) {
            if (this.isInArray(validBytes, byArray[i])) continue;
            String string5 = rbh.getMsg("contains_an_invalid_character", (Object)string, (Object)string2, (Object)this.filterOutLowercase(this.ccsidManager.charConverterForGui().byteArrayToString(validBytes)));
            throw new IllegalArgumentException(string5);
        }
    }

    private boolean isInArray(byte[] byArray, byte by) {
        return Arrays.binarySearch(byArray, by) > -1;
    }

    private String filterOutLowercase(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLowerCase(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static {
        Arrays.sort(validBytes);
    }
}

