/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.prompter.parser;

import com.helpsystems.common.as400.prompter.busobj.ParameterEntry;
import com.helpsystems.common.as400.prompter.parser.ParameterParser;
import org.w3c.dom.Element;

public abstract class EntryParser {
    public static ParameterEntry parse(Element element) {
        if (element == null) {
            throw new NullPointerException("The element passed in is null.");
        }
        String string = element.getNodeName();
        if (!"Parm".equalsIgnoreCase(string)) {
            throw new RuntimeException("The element passed in is a " + string + ". It should be 'Parm'");
        }
        ParameterEntry parameterEntry = new ParameterEntry();
        parameterEntry.setKeyword(element.getAttribute("Kwd"));
        if ("PMTRQS".equals(element.getAttribute("PmtCtl"))) {
            parameterEntry.setAdvancedOption(true);
        }
        if ("YES".equals(element.getAttribute("KeyParm"))) {
            // empty if block
        }
        parameterEntry.setDisplayPosition(EntryParser.parseNumber(element, "PosNbr", false));
        ParameterParser.parse(element, parameterEntry);
        return parameterEntry;
    }

    static int parseNumber(Element element, String string, boolean bl) {
        return (int)EntryParser.parseLong(element, string, bl);
    }

    static long parseLong(Element element, String string, boolean bl) {
        String string2 = element.getAttribute(string);
        long l = 0L;
        RuntimeException runtimeException = null;
        int n = 10;
        if (string2.startsWith("X'")) {
            string2 = string2.substring(2, string2.length() - 1);
            n = 16;
        }
        try {
            l = Long.parseLong(string2, n);
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
        }
        if (runtimeException != null && bl) {
            throw runtimeException;
        }
        return l;
    }

    static ParsedDecimal parseNumber(Element element, String string) {
        String string2 = element.getAttribute(string);
        ParsedDecimal parsedDecimal = new ParsedDecimal();
        String[] stringArray = string2.split("\\.");
        if (stringArray.length == 0) {
            stringArray = new String[]{string2};
        }
        try {
            parsedDecimal.integer = Integer.parseInt(stringArray[0]);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (stringArray.length > 1) {
            try {
                parsedDecimal.decimal = Integer.parseInt(stringArray[1]);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return parsedDecimal;
    }

    static double parseDouble(Element element, String string) {
        String string2 = element.getAttribute(string);
        try {
            return Double.parseDouble(string2);
        }
        catch (RuntimeException runtimeException) {
            return 0.0;
        }
    }

    static class ParsedDecimal {
        int integer;
        int decimal;

        ParsedDecimal() {
        }
    }
}

