/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.as400.busobj.OS400Message;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.Date;

public class OS400SpooledFileProxy
extends Proxy {
    private static final long serialVersionUID = 577363110784629461L;
    public static final int SORT_DATE_OPENED = 1;
    public static final int SORT_JOB_NAME = 2;
    public static final int SORT_JOB_NUMBER = 3;
    public static final int SORT_JOB_USER = 4;
    public static final int SORT_SPOOLED_FILE_NAME = 5;
    public static final int SORT_SPOOLED_FILE_NUMBER = 6;
    public static final int SORT_OUTQ_LIB = 7;
    public static final int SORT_OUTQ = 8;
    public static final int SORT_PRIORITY = 9;
    public static final int SORT_SIZE = 10;
    public static final int SORT_STATUS = 11;
    public static final int SORT_TOTAL_PAGES = 12;
    public static final int SORT_USER_DATA = 13;
    public static final int STATUS_CLOSED = 0;
    public static final int STATUS_DEFERRED = 1;
    public static final int STATUS_HELD = 2;
    public static final int STATUS_MESSAGE_WAITING = 3;
    public static final int STATUS_OPEN = 4;
    public static final int STATUS_PENDING = 5;
    public static final int STATUS_PRINTING = 6;
    public static final int STATUS_READY = 7;
    public static final int STATUS_SAVED = 8;
    public static final int STATUS_SENDING = 9;
    public static final int STATUS_WRITING = 10;
    public static final int STATUS_FINISHED = 11;
    public static final String STATUS_CLOSED_STRING = "*CLOSED";
    public static final String STATUS_DEFERRED_STRING = "*DEFERRED";
    public static final String STATUS_HELD_STRING = "*HELD";
    public static final String STATUS_MESSAGE_WAIT_STRING = "*MESSAGE";
    public static final String STATUS_OPEN_STRING = "*OPEN";
    public static final String STATUS_PENDING_STRING = "*PENDING";
    public static final String STATUS_PRINTING_STRING = "*PRINTER";
    public static final String STATUS_READY_STRING = "*READY";
    public static final String STATUS_SAVED_STRING = "*SAVED";
    public static final String STATUS_SENDING_STRING = "*SENDING";
    public static final String STATUS_WRITING_STRING = "*WRITING";
    public static final String STATUS_FINISHED_STRING = "*FINISHED";
    public static final String STATUS_UNKNOWN_STRING = "Unknown";
    private int auxiliaryStoragePool;
    private int copiesLeftToPrint;
    private Date dateFileOpened;
    private String formType;
    private String jobName;
    private String jobNumber;
    private String jobUser;
    private OS400Message os400message;
    private String outputQueue;
    private String outputQueueLibrary;
    private int outputPriority;
    private int spooledFileNumber;
    private int status;
    private long size;
    private int totalPages;
    private String userData;

    public int getAuxiliaryStoragePool() {
        return this.auxiliaryStoragePool;
    }

    public void setAuxiliaryStoragePool(int n) {
        this.auxiliaryStoragePool = n;
    }

    public int getCopiesLeftToPrint() {
        return this.copiesLeftToPrint;
    }

    public void setCopiesLeftToPrint(int n) {
        this.copiesLeftToPrint = n;
    }

    public String getDescription() {
        return "User Data: " + this.getUserData();
    }

    public Date getDateFileOpened() {
        return this.dateFileOpened;
    }

    public void setDateFileOpened(Date date) {
        this.dateFileOpened = date;
    }

    public String getFormType() {
        return this.formType;
    }

    public void setFormType(String string) {
        this.formType = string;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String string) {
        this.jobName = string;
    }

    public String getJobNumber() {
        return this.jobNumber;
    }

    public void setJobNumber(String string) {
        this.jobNumber = string;
    }

    public String getJobUser() {
        return this.jobUser;
    }

    public void setJobUser(String string) {
        this.jobUser = string;
    }

    public OS400Message getMessage() {
        return this.os400message;
    }

    public void setMessage(OS400Message oS400Message) {
        ValidationHelper.checkForNull((String)"OS400 Message", (Object)((Object)oS400Message));
        this.os400message = oS400Message;
    }

    public int getOutputPriority() {
        return this.outputPriority;
    }

    public void setOutputPriority(int n) {
        this.outputPriority = n;
    }

    public String getOutputQueue() {
        return this.outputQueue;
    }

    public void setOutputQueue(String string) {
        this.outputQueue = string;
    }

    public String getOutputQueueLibrary() {
        return this.outputQueueLibrary;
    }

    public void setOutputQueueLibrary(String string) {
        this.outputQueueLibrary = string;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusAsString() {
        String string = null;
        switch (this.status) {
            case 0: {
                string = STATUS_CLOSED_STRING;
                break;
            }
            case 1: {
                string = STATUS_DEFERRED_STRING;
                break;
            }
            case 2: {
                string = STATUS_HELD_STRING;
                break;
            }
            case 3: {
                string = STATUS_MESSAGE_WAIT_STRING;
                break;
            }
            case 4: {
                string = STATUS_OPEN_STRING;
                break;
            }
            case 5: {
                string = STATUS_PENDING_STRING;
                break;
            }
            case 6: {
                string = STATUS_PRINTING_STRING;
                break;
            }
            case 7: {
                string = STATUS_READY_STRING;
                break;
            }
            case 8: {
                string = STATUS_SAVED_STRING;
                break;
            }
            case 9: {
                string = STATUS_SENDING_STRING;
                break;
            }
            case 10: {
                string = STATUS_WRITING_STRING;
                break;
            }
            case 11: {
                string = STATUS_FINISHED_STRING;
                break;
            }
            default: {
                string = STATUS_UNKNOWN_STRING;
            }
        }
        return string;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String getSpooledFileName() {
        return super.getName();
    }

    public void setSpooledFileName(String string) {
        super.setName(string);
    }

    public int getSpooledFileNumber() {
        return this.spooledFileNumber;
    }

    public void setSpooledFileNumber(int n) {
        this.spooledFileNumber = n;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int n) {
        this.totalPages = n;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String string) {
        this.userData = string;
    }
}

