/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.ArrayList;

public class OS400LibraryList
extends CommonVersionedObject {
    private static final long serialVersionUID = 560399756847892762L;
    public static final int MAX_LENGTH_NAME = 10;
    public static final int MAX_NUMBER_OF_LIBRARIES = 255;
    public static final int MAX_NUMBER_OF_USER_LIBRARIES = 250;
    private ArrayList<String> libraries = new ArrayList();

    public void addLibrary(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Library Name", (String)string);
        ValidationHelper.validateLength((String)"Library Name", (int)10, (String)string);
        if (!this.libraries.contains(string) && !string.equals("*NONE")) {
            this.libraries.add(string);
        }
    }

    public void appendLibraryList(OS400LibraryList oS400LibraryList) {
        String[] stringArray = oS400LibraryList.getLibraries();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addLibrary(stringArray[i]);
        }
    }

    public String[] getLibraries() {
        return this.libraries.toArray(new String[0]);
    }

    public String getLibrariesAsParameter() {
        if (this.libraries.size() == 0) {
            return "*NONE";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.libraries.size(); ++i) {
            String string = this.libraries.get(i);
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public int getSize() {
        return this.libraries.size();
    }

    public void setLibraries(ArrayList<String> arrayList) {
        ValidationHelper.checkForNull((String)"Libraries", arrayList);
        this.libraries = arrayList;
    }

    public void validate() {
        if (this.libraries.size() > OS400LibraryList.getMaxLibraries()) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"The number of libraries specified ({0}) exceeds the maximum of {1}.", (Object[])new Object[]{new Integer(this.libraries.size()), new Integer(OS400LibraryList.getMaxLibraries())}));
        }
        String string = this.getFirstDupIn(this.libraries);
        if (string.length() > 0) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Library {0} already exists in this library list. Duplicates are not allowed.", (Object[])new Object[]{string}));
        }
    }

    public static int getMaxLibraries() {
        return 255;
    }

    private String getFirstDupIn(ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            if (arrayList2.contains(string)) {
                return string;
            }
            arrayList2.add(string);
        }
        return "";
    }
}

