/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.alert;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.ex.CommandCallException;
import com.helpsystems.common.as400.ex.CommandExecutionResponse;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.alert.AlertMessageInfo;
import com.helpsystems.common.core.alert.RecipientAM;
import com.helpsystems.common.core.alert.RecipientInfo;
import com.helpsystems.common.core.busobj.InstalledProduct;
import com.helpsystems.common.core.dm.InstalledProductsDM;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import org.apache.log4j.Logger;

public class RecipientAMAS400
extends AbstractProgramCallManager
implements RecipientAM {
    private static Logger logger = Logger.getLogger(RecipientAMAS400.class);
    private static final String VALIDATION_PROGRAM_NAME = "RSL035";
    private static final String RBA822 = "RBA822";
    private InstalledProductsDM installedProductsDM = null;

    public RecipientAMAS400(String string, String string2, InstalledProductsDM installedProductsDM) throws PcmlException {
        super("com.helpsystems.common.as400.alert.RecipientAMAS400", string, string2);
        this.setName("COMMON.RecipientAM");
        this.installedProductsDM = installedProductsDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateRecipient(String string) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        try {
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                try {
                    this.pcml.setSystem((AS400)wrappedAS400);
                    String string2 = QSYSObjectPathName.toPath((String)"*LIBL", (String)VALIDATION_PROGRAM_NAME, (String)"PGM");
                    this.pcml.setPath(VALIDATION_PROGRAM_NAME, string2);
                    this.pcml.setValue("RSL035.recipientName", (Object)string);
                    this.pcml.setValue("RSL035.returnValue", (Object)" ");
                    this.doCall(VALIDATION_PROGRAM_NAME);
                    String string3 = (String)this.pcml.getValue("RSL035.returnValue");
                    boolean bl = string3.equals("00");
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception exception) {
                        String string4 = "Error validating recipient.";
                        logger.debug((Object)string4, (Throwable)exception);
                        throw new ResourceUnavailableException(string4, (Throwable)exception);
                    }
                }
            }
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipientInfo getRecipientInfo(String string) throws NoDataException, ResourceUnavailableException {
        RecipientInfo recipientInfo = new RecipientInfo(string);
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        try {
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                try {
                    Object object;
                    int n = 2;
                    String string2 = InstalledProduct.getApplCode((int)n);
                    InstalledProduct[] installedProductArray = this.installedProductsDM.getInstalledProducts();
                    String string3 = null;
                    for (int i = 0; i < installedProductArray.length; ++i) {
                        object = installedProductArray[i];
                        if (!object.getApplCode().equals(string2)) continue;
                        string3 = object.getLibraryName();
                        break;
                    }
                    if (string3 == null) {
                        throw new ResourceUnavailableException("Robot/ALERT is not installed.");
                    }
                    if (!this.validateRecipient(string)) {
                        throw new ResourceUnavailableException("Robot/ALERT device is not defined.");
                    }
                    this.pcml.setSystem((AS400)wrappedAS400);
                    String string4 = QSYSObjectPathName.toPath((String)string3, (String)RBA822, (String)"PGM");
                    this.pcml.setPath(RBA822, string4);
                    this.pcml.setValue("RBA822.p1topg", (Object)string);
                    this.pcml.setValue("RBA822.p1twwy", (Object)" ");
                    this.pcml.setValue("RBA822.p1prot", (Object)" ");
                    this.pcml.setValue("RBA822.p1alwy", (Object)" ");
                    this.doCall(RBA822);
                    object = (String)this.pcml.getValue("RBA822.p1twwy");
                    if (((String)object).equals("2")) {
                        recipientInfo.setSupportsTwoWay(true);
                    } else {
                        recipientInfo.setSupportsTwoWay(false);
                    }
                    String string5 = (String)this.pcml.getValue("RBA822.p1prot");
                    if (string5.equals("1")) {
                        recipientInfo.setProtocol(1);
                    } else {
                        recipientInfo.setProtocol(0);
                    }
                    String string6 = (String)this.pcml.getValue("RBA822.p1alwy");
                    if (string6.equals("1")) {
                        recipientInfo.setSupportsAttachments(true);
                    } else {
                        recipientInfo.setSupportsAttachments(false);
                    }
                    RecipientInfo recipientInfo2 = recipientInfo;
                    return recipientInfo2;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception exception) {
                        String string7 = "Error retreiving recipient info.";
                        logger.debug((Object)string7, (Throwable)exception);
                        throw new ResourceUnavailableException(string7, (Throwable)exception);
                    }
                }
            }
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400, true);
            }
        }
    }

    public void sendAlertMessage(AlertMessageInfo alertMessageInfo) throws ResourceUnavailableException {
        String string = "";
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        try {
            CommandCall commandCall = new CommandCall((AS400)wrappedAS400);
            string = alertMessageInfo.buildSndMsgCommand();
            logger.trace((Object)("RBASNDMSG Command: " + string));
            CommandExecutionResponse commandExecutionResponse = AbstractAS400Manager.runCommand(commandCall, string);
            if (!commandExecutionResponse.isSuccessful()) {
                String string2 = "An error occurred sending the Alert Message.\n" + commandExecutionResponse.getMessageString(1);
                throw new ResourceUnavailableException(string2);
            }
        }
        catch (CommandCallException commandCallException) {
            logger.debug((Object)("An error occurred sending the Alert message: " + string), (Throwable)commandCallException);
            throw new ResourceUnavailableException("An error occurred sending the Alert message.", (Throwable)commandCallException);
        }
        finally {
            this.releaseConnection(wrappedAS400, true);
        }
    }
}

