/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.dm.ILibraryManager;
import com.helpsystems.common.as400.dm.OS400SupportDM;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.InstalledProduct;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.dm.ProductSupportDM;
import com.helpsystems.common.core.util.ValidationHelper;
import org.apache.log4j.Logger;

public class ProductSupportPCML
extends AbstractAS400Manager
implements ProductSupportDM {
    private static final Logger logger = Logger.getLogger(ProductSupportPCML.class);
    private ILibraryManager libraryManager;
    private OS400SupportDM supportManager;

    public ProductSupportPCML(String string, ILibraryManager iLibraryManager, OS400SupportDM oS400SupportDM) {
        super(string);
        this.setName("COMMON.ProductSupportDM");
        this.setSuffix(string);
        ValidationHelper.checkForNull((String)"Library manager", (Object)iLibraryManager);
        this.libraryManager = iLibraryManager;
        ValidationHelper.checkForNull((String)"Support manager", (Object)oS400SupportDM);
        this.supportManager = oS400SupportDM;
    }

    public String getAppString(int n) {
        return InstalledProduct.getApplCode((int)n);
    }

    public String getRelModName(int n) {
        String string = this.getAppString(n);
        if (string == null || string.length() < 2) {
            return "";
        }
        return string + "RELMOD";
    }

    public boolean isInstalled(int n) {
        String string = this.getRelMod(n);
        return string != null;
    }

    public String getRelMod(int n) {
        String string = null;
        String string2 = this.getAppString(n);
        if (string2 == null || string2.length() < 2) {
            return null;
        }
        try {
            string = this.libraryManager.getLibraryName(string2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.debug((Object)("Could not retrieve the library for the app index " + n + "."));
            return null;
        }
        if (string == null || string.length() < 1) {
            return null;
        }
        String string3 = this.getRelModName(n);
        String string4 = null;
        try {
            string4 = this.supportManager.getCharacterDataArea(UserIdentity.NO_USER_SPECIFIED, string, string3);
        }
        catch (Exception exception) {
            return null;
        }
        if (string4 != null && string4.length() > 5) {
            return string4;
        }
        return null;
    }

    public String getDescription(int n) {
        return InstalledProduct.getDescription((int)n);
    }
}

