/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.ASP;
import com.helpsystems.common.as400.busobj.OS400Object;
import com.helpsystems.common.as400.busobj.OS400ObjectDescription;
import com.helpsystems.common.as400.busobj.OS400ObjectListFilter;
import com.helpsystems.common.as400.busobj.OS400System;
import com.helpsystems.common.as400.dm.OS400SupportDM;
import com.helpsystems.common.as400.ex.CommandExecutionMessage;
import com.helpsystems.common.as400.ex.CommandExecutionResponse;
import com.helpsystems.common.as400.util.ASPAPI;
import com.helpsystems.common.as400.util.OS400ObjectDescriptionAPI;
import com.helpsystems.common.as400.util.OS400ObjectListAPI;
import com.helpsystems.common.as400.util.OS400ObjectValidator;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CharacterDataArea;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QSYSObjectTypeTable;
import com.ibm.as400.data.ProgramCallDocument;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OS400SupportPCML
extends AbstractAS400Manager
implements OS400SupportDM {
    private static final Logger logger = Logger.getLogger(OS400SupportPCML.class);
    private HashMap<String, String> objectTypes;
    public static final String OBJ_LIST_ERR = "OS400 Object List Error.";
    public static final String ASP_LIST_ERR = "System ASP List API failed.";
    public static final String ASP_ERR = "System ASP API failed.";
    public static final String MSG_TEXT_ERR = "RTVMSG text API failed.";
    private static final String GET_SYSTEM_ERR = "Could not retrieve OS400 System Information.";
    private static final String OFFSET_TOO_LONG = "The offset is longer than the size of the data area.";
    private static final String LENGTH_TOO_LONG = "The length from the offset is longer than the size of the data area.";
    private static final String RTV_DTAARA_ERR = "Could not retrieve the data area: ";

    public OS400SupportPCML(String string) {
        super(string);
        this.setName("COMMON.OS400SupportDM");
        this.objectTypes = new HashMap();
        this.init();
    }

    private void init() {
        String[] stringArray = this.getObjectTypeTable();
        for (int i = 0; i < stringArray.length; ++i) {
            this.objectTypes.put("*" + stringArray[i], "*" + stringArray[i]);
        }
    }

    @Override
    public void checkAspGroupExistence(String string, UserIdentity userIdentity) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"ASP Group Name", (Object)string);
        ValidationHelper.validateLength((String)"ASP Group Name", (int)10, (String)string);
        ASP[] aSPArray = this.getAspGroupList();
        for (int i = 0; i < aSPArray.length; ++i) {
            if (!string.equals(aSPArray[i].getAspGroup())) continue;
            return;
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"ASP Group {0} does not exist.", (Object[])new Object[]{string}));
    }

    @Override
    public OS400Object[] getOS400ObjectList(UserIdentity userIdentity, OS400ObjectListFilter oS400ObjectListFilter) {
        WrappedAS400 wrappedAS400 = null;
        try {
            OS400Object[] oS400ObjectArray;
            wrappedAS400 = this.borrowConnection(userIdentity);
            OS400ObjectListAPI oS400ObjectListAPI = new OS400ObjectListAPI(wrappedAS400);
            OS400Object[] oS400ObjectArray2 = oS400ObjectArray = oS400ObjectListAPI.runAPI(oS400ObjectListFilter);
            return oS400ObjectArray2;
        }
        catch (Exception exception) {
            throw new RuntimeException(OBJ_LIST_ERR, exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public OS400System getOS400System() {
        String string = "RBTSYSLIB";
        OS400System oS400System = null;
        WrappedAS400 wrappedAS400 = null;
        try {
            Object object;
            wrappedAS400 = this.borrowConnection();
            if (wrappedAS400 != null) {
                oS400System = new OS400System();
                oS400System.setModification(wrappedAS400.getModification());
                oS400System.setRelease(wrappedAS400.getRelease());
                oS400System.setSystem(wrappedAS400.getSystemName());
                oS400System.setVersion(wrappedAS400.getVersion());
                oS400System.setVerRelMod(wrappedAS400.getVRM());
                object = "rsl807";
                ProgramCallDocument programCallDocument = new ProgramCallDocument((AS400)wrappedAS400, "com.helpsystems.common.as400.access.rsl807");
                String string2 = "/QSYS.LIB/" + string + ".LIB/RSL807.PGM";
                programCallDocument.setPath((String)object, string2);
                if (!programCallDocument.callProgram((String)object)) {
                    AS400Message[] aS400MessageArray = programCallDocument.getMessageList((String)object);
                    for (int i = 0; i < aS400MessageArray.length; ++i) {
                        logger.debug((Object)(aS400MessageArray[i].getID() + " - " + aS400MessageArray[i].getText()));
                    }
                    throw new RuntimeException("Call to RSL807 failed.");
                }
                String string3 = (String)programCallDocument.getValue((String)object + ".systemname");
                String string4 = (String)programCallDocument.getValue((String)object + ".serial");
                String string5 = (String)programCallDocument.getValue((String)object + ".model");
                String string6 = (String)programCallDocument.getValue((String)object + ".prcfeat");
                int n = programCallDocument.getIntValue((String)object + ".partition");
                String string7 = (String)programCallDocument.getValue((String)object + ".error");
                oS400System.setSystem(string3);
                oS400System.setSerialNumber(string4);
                oS400System.setModelNumber(string5);
                oS400System.setFeatureCode(string6);
                oS400System.setPartition(n);
                if (string7.trim().length() > 0) {
                    logger.error((Object)string7);
                }
                String string8 = "rsl8074";
                ProgramCallDocument programCallDocument2 = new ProgramCallDocument((AS400)wrappedAS400, "com.helpsystems.common.as400.access.rsl8074");
                String string9 = "/QSYS.LIB/" + string + ".LIB/RSL8074.PGM";
                programCallDocument2.setPath(string8, string9);
                programCallDocument2.setIntValue(string8 + ".nbrrealprc", new Integer(0).intValue());
                programCallDocument2.setIntValue(string8 + ".nbrondemandprc", new Integer(0).intValue());
                programCallDocument2.setIntValue(string8 + ".nbroslicenses", new Integer(0).intValue());
                if (!programCallDocument2.callProgram(string8)) {
                    AS400Message[] aS400MessageArray = programCallDocument2.getMessageList(string8);
                    for (int i = 0; i < aS400MessageArray.length; ++i) {
                        logger.error((Object)(aS400MessageArray[i].getID() + " - " + aS400MessageArray[i].getText()));
                    }
                    throw new RuntimeException("Call to RSL8074 failed.");
                }
                int n2 = programCallDocument2.getIntValue(string8 + ".nbrsysprc");
                int n3 = programCallDocument2.getIntValue(string8 + ".nbrpartprc");
                string7 = (String)programCallDocument2.getValue(string8 + ".error");
                int n4 = programCallDocument2.getIntValue(string8 + ".nbrrealprc");
                int n5 = programCallDocument2.getIntValue(string8 + ".nbrondemandprc");
                int n6 = programCallDocument2.getIntValue(string8 + ".nbroslicenses");
                oS400System.setSystemProcessors(n2);
                oS400System.setPartitionProcessors(n3);
                oS400System.setRealPartitionProcessors(n4);
                oS400System.setOnDemand(n5);
                oS400System.setOSLicenses(n6);
                if (string7.trim().length() > 0) {
                    logger.debug((Object)string7);
                }
            }
            object = oS400System;
            return object;
        }
        catch (Exception exception) {
            logger.trace((Object)(GET_SYSTEM_ERR + exception.getMessage()));
            throw new RuntimeException(GET_SYSTEM_ERR, exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public OS400ObjectDescription getOS400ObjectInfo(UserIdentity userIdentity, OS400Object oS400Object) {
        WrappedAS400 wrappedAS400 = null;
        try {
            OS400ObjectDescription oS400ObjectDescription;
            wrappedAS400 = this.borrowConnection(userIdentity);
            OS400ObjectDescriptionAPI oS400ObjectDescriptionAPI = new OS400ObjectDescriptionAPI(wrappedAS400);
            OS400ObjectDescription oS400ObjectDescription2 = oS400ObjectDescription = oS400ObjectDescriptionAPI.runAPI(oS400Object);
            return oS400ObjectDescription2;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            logger.debug((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean validOS400ObjectExists(UserIdentity userIdentity, OS400Object oS400Object) {
        return this.validOS400ObjectExists(userIdentity, oS400Object, false);
    }

    @Override
    public boolean validOS400ObjectExists(UserIdentity userIdentity, OS400Object oS400Object, boolean bl) {
        boolean bl2 = false;
        WrappedAS400 wrappedAS400 = null;
        if (oS400Object == null) {
            throw new NullPointerException("Object to validate cannot be null.");
        }
        String string = oS400Object.getLibrary();
        String string2 = oS400Object.getObject();
        String string3 = oS400Object.getType();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("A library must be specified.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("An object name must be specified.");
        }
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("An object type must be specified.");
        }
        try {
            if (!string.trim().equalsIgnoreCase("*LIBL")) {
                OS400ObjectValidator.validateName(string, false);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid library name.", exception);
        }
        try {
            OS400ObjectValidator.validateName(string2, false);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid object name.", exception);
        }
        try {
            this.validateTypeAttr(string3, "*ALL");
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid object type.", exception);
        }
        String string4 = "CHKOBJ OBJ(" + string + "/" + string2 + ") OBJTYPE(" + string3 + ")";
        if (bl) {
            string4 = string4 + " AUT(*USE)";
        }
        logger.trace((Object)("Check-Object command: " + string4));
        try {
            wrappedAS400 = bl ? this.createConnectionForUser(userIdentity) : this.borrowConnection(userIdentity);
            CommandCall commandCall = new CommandCall((AS400)wrappedAS400);
            bl2 = OS400SupportPCML.runCommand(string4, commandCall);
            CommandExecutionMessage[] commandExecutionMessageArray = OS400SupportPCML.extractMessages(commandCall);
            for (int i = 0; i < commandExecutionMessageArray.length; ++i) {
                logger.trace((Object)commandExecutionMessageArray[i].getText());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error checking object.", exception);
        }
        finally {
            try {
                wrappedAS400.close();
            }
            catch (Exception exception) {}
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMsgText(UserIdentity userIdentity, String string, String string2, byte[] byArray, int n) {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            MessageFile messageFile = new MessageFile((AS400)wrappedAS400);
            messageFile.setPath(string);
            messageFile.setHelpTextFormatting(2);
            AS400Message aS400Message = byArray != null ? messageFile.getMessage(string2, byArray) : messageFile.getMessage(string2);
            if (n == 100) {
                String string3 = aS400Message.getText();
                return string3;
            }
            if (n == 200) {
                String string4 = aS400Message.getHelp();
                return string4;
            }
            String string5 = aS400Message.getText();
            return string5;
        }
        catch (Exception exception) {
            throw new RuntimeException(MSG_TEXT_ERR, exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMsgText(UserIdentity userIdentity, String string, String string2, String string3, int n) {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection();
            MessageFile messageFile = new MessageFile((AS400)wrappedAS400);
            messageFile.setPath(string);
            messageFile.setHelpTextFormatting(2);
            AS400Message aS400Message = string3 != null && string3.length() > 0 ? messageFile.getMessage(string2, string3) : messageFile.getMessage(string2);
            if (n == 100) {
                String string4 = aS400Message.getText();
                return string4;
            }
            if (n == 200) {
                String string5 = aS400Message.getHelp();
                return string5;
            }
            String string6 = aS400Message.getText();
            return string6;
        }
        catch (Exception exception) {
            throw new RuntimeException(MSG_TEXT_ERR, exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public ASP getAspInfo(int n) {
        WrappedAS400 wrappedAS400 = null;
        ASP aSP = null;
        try {
            wrappedAS400 = this.borrowConnection();
            ASP aSP2 = aSP = new ASPAPI(wrappedAS400).getAsp(n);
            return aSP2;
        }
        catch (Exception exception) {
            throw new RuntimeException(ASP_ERR, exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public ASP[] getAspList(int n) {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection();
            ASP[] aSPArray = new ASPAPI(wrappedAS400).getAspList(n);
            return aSPArray;
        }
        catch (Exception exception) {
            throw new RuntimeException(ASP_LIST_ERR, exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public ASP[] getAspGroupList() {
        ASP[] aSPArray = this.getAspList(-3);
        ArrayList<ASP> arrayList = new ArrayList<ASP>();
        if (aSPArray != null && aSPArray.length > 0) {
            for (int i = 0; i < aSPArray.length; ++i) {
                ASP aSP = aSPArray[i];
                if (aSP.getAspUsage() != 2) continue;
                arrayList.add(aSP);
            }
        }
        ASP[] aSPArray2 = new ASP[arrayList.size()];
        return arrayList.toArray(aSPArray2);
    }

    @Override
    public Proxy[] getAspGroupNamesAsProxies() {
        ASP[] aSPArray = this.getAspGroupList();
        Proxy[] proxyArray = new Proxy[aSPArray.length];
        for (int i = 0; i < aSPArray.length; ++i) {
            Proxy proxy = new Proxy();
            proxy.setName(aSPArray[i].getAspGroup());
            proxyArray[i] = proxy;
        }
        return proxyArray;
    }

    @Override
    public String[] getObjectTypeTable() {
        return QSYSObjectTypeTable.getSupportedObjectTypes();
    }

    @Override
    public String[] getSupportedAttributes(String string) {
        return QSYSObjectTypeTable.getSupportedAttributes((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCharacterDataArea(UserIdentity userIdentity, String string, String string2) {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            CharacterDataArea characterDataArea = new CharacterDataArea((AS400)wrappedAS400, this.getDataAreaPath(string, string2));
            String string3 = characterDataArea.read();
            return string3;
        }
        catch (Exception exception) {
            logger.trace((Object)(RTV_DTAARA_ERR + string.trim() + "/" + string2.trim()));
            String string4 = null;
            return string4;
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String getCharacterDataArea(UserIdentity userIdentity, String string, String string2, int n, int n2) throws IllegalArgumentException {
        WrappedAS400 wrappedAS400 = null;
        String string3 = "";
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            string3 = this.getDataAreaPath(string, string2);
            CharacterDataArea characterDataArea = new CharacterDataArea((AS400)wrappedAS400, string3);
            StringBuffer stringBuffer = new StringBuffer(characterDataArea.read());
            int n3 = stringBuffer.length();
            if (n > n3) {
                throw new IllegalArgumentException(OFFSET_TOO_LONG);
            }
            if (n2 > n3 - n) {
                throw new IllegalArgumentException(LENGTH_TOO_LONG);
            }
            String string4 = stringBuffer.substring(n, n + n2);
            return string4;
        }
        catch (Exception exception) {
            throw new RuntimeException(RTV_DTAARA_ERR + string.trim() + "/" + string2.trim(), exception);
        }
        finally {
            try {
                this.releaseConnection(wrappedAS400);
            }
            catch (Exception exception) {}
        }
    }

    private String getDataAreaPath(String string, String string2) {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, string2, "DTAARA");
        return qSYSObjectPathName.getPath();
    }

    @Override
    public void validateTypeAttr(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        if (string3 == null) {
            throw new NullPointerException("Type type is null.");
        }
        if (string4 == null) {
            throw new NullPointerException("Type attribute is null.");
        }
        string3 = string3.trim().toUpperCase();
        string4 = string4.trim().toUpperCase();
        if (string3.length() == 0) {
            throw new IllegalArgumentException("An object type is required.");
        }
        if (string4.length() == 0) {
            throw new IllegalArgumentException("An object attribute is required.");
        }
        if (string3.equals("*ALL")) {
            if (string4.equals("*ALL")) {
                return;
            }
            throw new IllegalArgumentException("When object type is *ALL, the attribute must also be *ALL.");
        }
        if (!this.objectTypes.containsKey(string3)) {
            throw new IllegalArgumentException(string3 + " is not a valid object type.");
        }
        if (string4.equals("*ALL")) {
            return;
        }
        OS400SupportDM oS400SupportDM = (OS400SupportDM)ManagerRegistry.getManager((String)"COMMON.OS400SupportDM");
        if (oS400SupportDM == null) {
            throw new NullPointerException("OS400 Support data manager is null.");
        }
        String[] stringArray = oS400SupportDM.getSupportedAttributes(string3);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string4)) continue;
            return;
        }
        throw new IllegalArgumentException(string4 + " is not a valid object attribute for " + string3 + " type.");
    }

    @Override
    public String sendMessage(String string, String string2) throws ResourceUnavailableException {
        String string3 = this.buildSndMsgCommand(string, string2);
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        try {
            logger.trace((Object)("SNDRBTDTA Command: " + string3));
            CommandExecutionResponse commandExecutionResponse = OS400SupportPCML.runCommand(string3, wrappedAS400);
            if (!commandExecutionResponse.isSuccessful()) {
                String string4 = "An error occurred sending the Robot/SCHEDULE Data.\n" + commandExecutionResponse.getMessageString(1);
                throw new ResourceUnavailableException(string4);
            }
            String string5 = string3;
            return string5;
        }
        catch (Exception exception) {
            String string6 = "An error occurred sending the IBM SNDMSG command: " + string3;
            logger.debug((Object)string6, (Throwable)exception);
            throw new ResourceUnavailableException(string6, (Throwable)exception);
        }
        finally {
            this.releaseConnection(wrappedAS400, true);
        }
    }

    private String buildSndMsgCommand(String string, String string2) {
        if (string == null || string.trim().length() < 1) {
            throw new IllegalStateException("User name is a required field.");
        }
        if (string2 == null || string2.trim().length() < 1) {
            throw new IllegalStateException("Message is a required field.");
        }
        String string3 = string2.trim();
        if (string3.length() > 512) {
            throw new IllegalStateException("The message text cannot be longer than 512 characters.");
        }
        string3.replaceAll("'", "''");
        StringBuffer stringBuffer = new StringBuffer("SNDMSG");
        stringBuffer.append(" MSG('" + string3 + "')");
        stringBuffer.append(" TOUSR(" + string + ")");
        return stringBuffer.toString();
    }
}

