/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.SystemValueManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ExceptionErrorList;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.busobj.OS400Server;
import com.helpsystems.common.server.busobj.Server;
import com.helpsystems.common.server.dm.ServerInfoDM;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.SystemStatus;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public class OS400ServerInfoDMAS400
extends AbstractProgramCallManager
implements ServerInfoDM {
    private static final Logger logger = Logger.getLogger(OS400ServerInfoDMAS400.class);
    private static final String PCML_FILE = "com.helpsystems.common.as400.access.OS400ServerInfoDMAS400";
    private static final String PTF_LIST_PGM_NAME = "RSL070";
    private static final int PTFID_LENGTH = 7;
    private static final String PROC_INF_PGM_NAME = "RSL071";
    private static final int PROC_INF_LENGTH = 8;
    private static final int MAX_PROCESSORS = 64;
    private static final String OS_400_NAME = "OS/400";
    private String library = "*LIBL";
    private SystemValueManager svMgr;

    public OS400ServerInfoDMAS400(String string, String string2, String string3) throws PcmlException {
        super(PCML_FILE, string, string2, null);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string3);
        this.setName(string3);
        this.svMgr = new SystemValueManager(string);
    }

    public Server getServerInfo(UserIdentity userIdentity) throws IOException {
        try {
            OS400Server oS400Server = new OS400Server();
            this.loadServerStatus(userIdentity, oS400Server, true);
            return oS400Server;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Unable to retrieve system info.");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public OS400Server getBasicServerInfo(UserIdentity userIdentity) throws IOException {
        try {
            OS400Server oS400Server = new OS400Server();
            this.loadServerStatus(userIdentity, oS400Server, false);
            return oS400Server;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Unable to retrieve system info.");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private void loadServerStatus(UserIdentity userIdentity, OS400Server oS400Server, boolean bl) throws ResourceUnavailableException, BadDataException {
        String string;
        int n;
        WrappedAS400 wrappedAS400 = this.borrowConnection(userIdentity);
        SystemStatus systemStatus = new SystemStatus((AS400)wrappedAS400);
        systemStatus.setCaching(true);
        systemStatus.refreshCache();
        oS400Server.setName(OS_400_NAME);
        oS400Server.setHardwareSerialNumber((String)this.svMgr.getSystemValue("QSRLNBR"));
        oS400Server.setModel((String)this.svMgr.getSystemValue("QMODEL"));
        oS400Server.setProcessorFeatureCode((String)this.svMgr.getSystemValue("QPRCFEAT"));
        ExceptionErrorList exceptionErrorList = new ExceptionErrorList();
        try {
            n = wrappedAS400.getVRM();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("V");
            stringBuffer.append((n & 0xFFFF0000) >> 16);
            stringBuffer.append("R");
            stringBuffer.append((n & 0xFF00) >> 8);
            stringBuffer.append("M");
            stringBuffer.append(n & 0xFF);
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            logger.debug((Object)"Couldn't get OSVersion", (Throwable)iOException);
            string = "*UNKNOWN";
            exceptionErrorList.addException((Exception)iOException);
        }
        catch (AS400SecurityException aS400SecurityException) {
            logger.debug((Object)"Couldn't get OSVersion", (Throwable)aS400SecurityException);
            string = "*UNKNOWN";
            exceptionErrorList.addException((Exception)((Object)aS400SecurityException));
        }
        oS400Server.setOSVersion(string);
        try {
            n = systemStatus.getTotalAuxiliaryStorage();
            oS400Server.setPhysicalMemory(NumberFormat.getInstance().format(n) + " MB");
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            logger.debug((Object)"Couldn't get Total Auxiliary Storage", (Throwable)objectDoesNotExistException);
            exceptionErrorList.addException((Exception)((Object)objectDoesNotExistException));
        }
        catch (IOException iOException) {
            logger.debug((Object)"Couldn't get Total Auxiliary Storage", (Throwable)iOException);
            exceptionErrorList.addException((Exception)iOException);
        }
        catch (InterruptedException interruptedException) {
            logger.debug((Object)"Couldn't get Total Auxiliary Storage", (Throwable)interruptedException);
            exceptionErrorList.addException((Exception)interruptedException);
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            logger.debug((Object)"Couldn't get Total Auxiliary Storage", (Throwable)errorCompletingRequestException);
            exceptionErrorList.addException((Exception)((Object)errorCompletingRequestException));
        }
        catch (AS400SecurityException aS400SecurityException) {
            logger.debug((Object)"Couldn't get Total Auxiliary Storage", (Throwable)aS400SecurityException);
            exceptionErrorList.addException((Exception)((Object)aS400SecurityException));
        }
        catch (NullPointerException nullPointerException) {
            logger.debug((Object)"Couldn't get Total Auxiliary Storage", (Throwable)nullPointerException);
            exceptionErrorList.addException((Exception)nullPointerException);
        }
        if (bl) {
            String[] stringArray = null;
            try {
                stringArray = this.getPTFs(wrappedAS400);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.debug((Object)"Couldn't get the PTF Levels", (Throwable)resourceUnavailableException);
                stringArray = new String[]{"Could not retrieve PTF Levels"};
                exceptionErrorList.addException((Exception)((Object)resourceUnavailableException));
            }
            oS400Server.setPTFLevel(stringArray);
        }
        ProcInfo procInfo = null;
        if (bl) {
            try {
                procInfo = this.getProcInfo(wrappedAS400);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                exceptionErrorList.addException((Exception)((Object)resourceUnavailableException));
            }
        }
        if (procInfo != null) {
            oS400Server.setNumberOfProcessors(procInfo.getCount());
            oS400Server.setProcessorType(procInfo.getInfo());
        } else {
            oS400Server.setNumberOfProcessors(1);
            oS400Server.setProcessorType(new String[]{"*UNKNOWN"});
        }
        if (wrappedAS400 != null) {
            this.releaseConnection(wrappedAS400);
        }
        if (exceptionErrorList.getErrorCount() > 0) {
            throw new BadDataException("Could not load all data for OS400Server", (Object)oS400Server, (ErrorList)exceptionErrorList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getPTFs(AS400 aS400) throws ResourceUnavailableException {
        try {
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                this.pcml.setSystem(aS400);
                String string = "/QSYS.LIB/" + this.library.trim() + ".LIB/" + PTF_LIST_PGM_NAME + ".PGM";
                this.pcml.setPath(PTF_LIST_PGM_NAME, string);
                this.doCall(PTF_LIST_PGM_NAME);
                String string2 = (String)this.pcml.getValue("RSL070.ptfs");
                int n = string2.trim().length() / 7;
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = string2.substring(i * 7, (i + 1) * 7);
                }
                return stringArray;
            }
        }
        catch (Exception exception) {
            String string = "Error retrieving PTFs.";
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    private ProcInfo getProcInfo(AS400 aS400) throws ResourceUnavailableException {
        try {
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                this.pcml.setSystem(aS400);
                String string = "/QSYS.LIB/" + this.library.trim() + ".LIB/" + PROC_INF_PGM_NAME + ".PGM";
                this.pcml.setPath(PROC_INF_PGM_NAME, string);
                this.doCall(PROC_INF_PGM_NAME);
                int n = this.pcml.getIntValue("RSL071.count");
                logger.trace((Object)("getProcInfo: Processor count " + n));
                if (n > 64) {
                    n = 64;
                }
                String string2 = (String)this.pcml.getValue("RSL071.info");
                int n2 = string2.length();
                logger.trace((Object)("getProcInfo: allInfo " + string2));
                logger.trace((Object)("getProcInfo: length " + n2));
                if (n > 0 && string2 != null) {
                    String[] stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        if ((i + 1) * 8 > n2) {
                            stringArray[i] = string2.substring(i * 8);
                            break;
                        }
                        stringArray[i] = string2.substring(i * 8, (i + 1) * 8);
                    }
                    if (string2 == null || stringArray == null) {
                        stringArray = new String[]{"Not Available"};
                        logger.debug((Object)"The processor information could not be retrieved.");
                    }
                    return new ProcInfo(n, stringArray);
                }
                String string3 = "Error retrieving processor information.";
                throw new ResourceUnavailableException(string3);
            }
        }
        catch (Exception exception) {
            String string = "Error retrieving processor information.";
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    class ProcInfo {
        final int count;
        final String[] info;

        public ProcInfo(int n, String[] stringArray) {
            this.count = n;
            this.info = stringArray;
        }

        public int getCount() {
            return this.count;
        }

        public String[] getInfo() {
            return this.info;
        }
    }
}

