/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.InstalledProduct;
import com.helpsystems.common.core.dm.InstalledProductsDM;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;

public class InstalledProductsDMAS400
extends AbstractProgramCallManager
implements InstalledProductsDM {
    private static final String PCML_FILE = "com.helpsystems.common.as400.access.rsl509";

    public InstalledProductsDMAS400(String string, String string2) throws PcmlException {
        super(PCML_FILE, string);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        this.setName(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstalledProduct[] getInstalledProducts() throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        InstalledProduct[] installedProductArray = null;
        try {
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                this.pcml.setSystem((AS400)wrappedAS400);
                this.pcml.setIntValue("RSL509.P1COUNT", 0);
                this.doCall("RSL509");
                int n = this.pcml.getIntValue("RSL509.P1COUNT");
                installedProductArray = new InstalledProduct[n];
                for (int i = 0; i < n; ++i) {
                    int[] nArray = new int[]{i};
                    String string = (String)this.pcml.getValue("RSL509.P1PRODUCTS.CODE", nArray);
                    String string2 = (String)this.pcml.getValue("RSL509.P1PRODUCTS.LIBRARY", nArray);
                    String string3 = (String)this.pcml.getValue("RSL509.P1PRODUCTS.RELMOD.LVL", nArray);
                    installedProductArray[i] = new InstalledProduct(string, string3, string2);
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            throw new ResourceUnavailableException("Unable to retrieve installed products.", (Throwable)exception);
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
        return installedProductArray;
    }
}

