/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.dm.EncodingManager;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ThreadSession;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConversionMapsAccessor;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;

public class CcsidManager
extends AbstractManager
implements EncodingManager {
    private static final Locale JVM_LOCALE = Locale.getDefault();
    private static final Map localeCcsidMap = ConversionMapsAccessor.getLocaleCcsidMap();
    private static CharConverter charConverterCcsid37;
    private int ccsidOfDBField = 37;

    public static CharConverter charConverterCcsid37() {
        return charConverterCcsid37;
    }

    public static int ccsidOfUser() {
        String string = CcsidManager.localeOfUser().toString();
        try {
            while (true) {
                String string2;
                if ((string2 = (String)localeCcsidMap.get(string)) != null) {
                    return Integer.parseInt(string2);
                }
                string = string.substring(0, string.lastIndexOf(95));
            }
        }
        catch (Exception exception) {
            String string3 = MessageUtil.formatMsg((String)"Unable to determine the ccsid for locale {0}.", (Object[])new Object[]{string});
            throw new IllegalStateException(string3);
        }
    }

    public static Locale localeOfUser() {
        ThreadSession threadSession = ThreadSession.getSession();
        if (threadSession != null) {
            return threadSession.getLocale();
        }
        return JVM_LOCALE;
    }

    public CharConverter charConverterForGui() {
        try {
            return new CharConverter(CcsidManager.ccsidOfUser());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = MessageUtil.formatMsg((String)"Could not create a CharConverter for CCSID {0}.", (Object[])new Object[]{Integer.toString(CcsidManager.ccsidOfUser())});
            throw new IllegalStateException(string);
        }
    }

    public CharConverter charConverterForDBField() {
        try {
            if (this.ccsidOfDBField() == 37) {
                return CcsidManager.charConverterCcsid37();
            }
            return new CharConverter(this.ccsidOfDBField());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = MessageUtil.formatMsg((String)"Could not create a CharConverter for CCSID {0}.", (Object[])new Object[]{Integer.toString(this.ccsidOfDBField())});
            throw new IllegalStateException(string);
        }
    }

    public String adjustUnicodeFromDB(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (CcsidManager.ccsidOfUser() != this.ccsidOfDBField()) {
            byte[] byArray = this.charConverterForDBField().stringToByteArray(string);
            return this.charConverterForGui().byteArrayToString(byArray);
        }
        return string2;
    }

    public String adjustUnicodeToDB(String string) {
        ValidationHelper.checkForNull((String)"Text", (Object)string);
        String string2 = string;
        if (CcsidManager.ccsidOfUser() != this.ccsidOfDBField()) {
            byte[] byArray = this.charConverterForGui().stringToByteArray(string);
            return this.charConverterForDBField().byteArrayToString(byArray);
        }
        return string2;
    }

    public int ccsidOfDBField() {
        return this.ccsidOfDBField;
    }

    public void setCcsidOfDBField(int n) {
        this.ccsidOfDBField = n;
    }

    static {
        try {
            charConverterCcsid37 = new CharConverter(37);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Could not create a CharConverterfor CCSID 37.");
        }
    }
}

