/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AS400CommonPCMLManager;
import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.Job;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import org.apache.log4j.Logger;

public abstract class AbstractProgramCallManager
extends AbstractAS400Manager {
    private static final Logger logger = Logger.getLogger(AbstractProgramCallManager.class);
    public static boolean fetchSystemNameOnFailure = true;
    protected ProgramCallDocument pcml;
    protected ClassLoader classloader;

    public AbstractProgramCallManager(String string, String string2) throws PcmlException {
        this(string, string2, null, null);
    }

    public AbstractProgramCallManager(String string, String string2, String string3) throws PcmlException {
        this(string, string2, string3, null);
    }

    public AbstractProgramCallManager(String string, String string2, String string3, ClassLoader classLoader) throws PcmlException {
        super(string2, string3);
        this.classloader = classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
        this.pcml = new TracingProgramCallDocument(string, this.classloader);
    }

    protected void doCall(String string) throws ResourceUnavailableException, PcmlException {
        this.doCallAndReturn(string, null);
    }

    protected Object doCallAndReturn(String string, String string2) throws ResourceUnavailableException, PcmlException {
        return AbstractProgramCallManager.doCallAndReturn(this.pcml, string, string2);
    }

    public static Object doCallAndReturn(ProgramCallDocument programCallDocument, String string, String string2) throws ResourceUnavailableException, PcmlException {
        ValidationHelper.checkForNull((String)"PCML", (Object)programCallDocument);
        ValidationHelper.checkForNull((String)"Program Name", (Object)string);
        Job job = null;
        try {
            Job[] jobArray = programCallDocument.getSystem().getJobs(2);
            if (jobArray.length == 0) {
                programCallDocument.getSystem().connectService(2);
                jobArray = programCallDocument.getSystem().getJobs(2);
            }
            job = jobArray[0];
            job.setInquiryMessageReply("*DFT");
            if (job.getCacheChanges()) {
                job.commitChanges();
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to set job/message preferences.", (Throwable)exception);
        }
        boolean bl = programCallDocument.callProgram(string);
        if (!bl) {
            String string3 = AbstractAS400Manager.messagesToString(programCallDocument.getMessageList(string));
            ResourceUnavailableException resourceUnavailableException = new ResourceUnavailableException("Program call to " + string + " failed: " + string3, null);
            boolean bl2 = false;
            if (programCallDocument.getSystem() instanceof WrappedAS400 && ((WrappedAS400)programCallDocument.getSystem()).isOneTimeUse()) {
                bl2 = true;
            }
            if (job != null && !bl2) {
                String string4 = job.getSystem().getSystemName();
                if (fetchSystemNameOnFailure) {
                    string4 = AS400CommonPCMLManager.retrieveSystemName(job.getSystem());
                }
                String string5 = "Check the job log for " + job.getNumber() + "/" + job.getUser() + "/" + job.getName() + " on server " + string4;
                resourceUnavailableException.setRecoveryOptions(new String[]{string5});
            }
            throw resourceUnavailableException;
        }
        if (string2 == null) {
            return null;
        }
        Object object = programCallDocument.getValue(string + "." + string2);
        return object;
    }

    private class TracingProgramCallDocument
    extends ProgramCallDocument {
        TracingProgramCallDocument(String string, ClassLoader classLoader) throws PcmlException {
            super(null, string, classLoader);
        }

        public boolean callProgram(String string) throws PcmlException {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Calling PCML program: " + string));
            }
            return super.callProgram(string);
        }

        public void setValue(String string, Object object) throws PcmlException {
            this.traceParams(string, object);
            super.setValue(string, object);
        }

        private void traceParams(String string, Object object) {
            if (!logger.isTraceEnabled()) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Setting PCML variable ");
            stringBuffer.append(string);
            stringBuffer.append(" to value ");
            if (object == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(object.toString());
                stringBuffer.append(" [");
                stringBuffer.append(object.getClass().getName());
                stringBuffer.append("]");
            }
            logger.trace((Object)stringBuffer.toString());
        }
    }
}

