/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AS400ConnectionFactory;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.service.AS400ServiceDescriptor;
import com.ibm.as400.access.Job;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class AS400ObjectPool
extends GenericObjectPool {
    private AS400ConnectionFactory factory;
    private Map<WrappedAS400, String> jobMap;
    private AS400ServiceDescriptor descriptor;

    public AS400ObjectPool(AS400ConnectionFactory aS400ConnectionFactory) {
        super((PoolableObjectFactory)aS400ConnectionFactory);
        this.factory = aS400ConnectionFactory;
        this.jobMap = new HashMap<WrappedAS400, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject() throws Exception {
        WrappedAS400 wrappedAS400 = (WrappedAS400)((Object)super.borrowObject());
        wrappedAS400.setPool(this);
        Job[] jobArray = wrappedAS400.getJobs(2);
        if (jobArray != null && jobArray.length == 1) {
            Map<WrappedAS400, String> map = this.jobMap;
            synchronized (map) {
                this.jobMap.put(wrappedAS400, jobArray[0].getNumber() + "/" + jobArray[0].getUser() + "/" + jobArray[0].getName());
            }
        }
        return wrappedAS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object object) throws Exception {
        Map<WrappedAS400, String> map = this.jobMap;
        synchronized (map) {
            this.jobMap.remove(object);
        }
        super.invalidateObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobs() {
        Map<WrappedAS400, String> map = this.jobMap;
        synchronized (map) {
            String[] stringArray = new String[this.jobMap.size()];
            this.jobMap.values().toArray(stringArray);
            return stringArray;
        }
    }

    public AS400ConnectionFactory getFactory() {
        return this.factory;
    }

    public AS400ServiceDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(AS400ServiceDescriptor aS400ServiceDescriptor) {
        this.descriptor = aS400ServiceDescriptor;
    }
}

