/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.dm.ILoginHandlerAM;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.server.auth.AbstractLoginHandlerAM;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;

public class AS400LoginHandlerAM
extends AbstractLoginHandlerAM
implements ILoginHandlerAM {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler((String)AS400LoginHandlerAM.class.getName());

    public AS400LoginHandlerAM(String string) {
        super(string);
    }

    /*
     * Loose catch block
     */
    public String validateUser(String string, char[] cArray) throws ResourceUnavailableException {
        if (string == null || string.length() == 0) {
            return rbh.getMsg("missing_user_name");
        }
        if (string.length() > 10) {
            return rbh.getMsg("password_too_long");
        }
        boolean bl = false;
        AS400 aS400 = null;
        try {
            aS400 = new AS400(this.serverName);
            bl = aS400.validateSignon(string, new String(cArray));
        }
        catch (AS400SecurityException aS400SecurityException) {
            String string2 = aS400SecurityException.getMessage();
            return string2;
        }
        catch (RuntimeException runtimeException) {
            bl = false;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to connect to login server " + this.serverName, (Throwable)exception);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (aS400 != null) {
                try {
                    aS400.disconnectAllServices();
                }
                catch (Exception exception) {}
            }
        }
        if (bl) {
            return null;
        }
        return "";
    }

    public boolean isSystemAvailable() {
        if (this.serverName == null || this.serverName.length() == 0) {
            return false;
        }
        return this.testPort(8476);
    }
}

