/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.tray;

import com.helpsystems.common.client.components.AboutInfoPanel;
import com.helpsystems.common.client.components.DataLabel;
import com.helpsystems.common.client.components.HSAction;
import com.helpsystems.common.client.components.HSJFrame;
import com.helpsystems.common.client.components.HSWindow;
import com.helpsystems.common.client.components.throwabledialog.ThrowableDialog;
import com.helpsystems.common.client.images.HSImages;
import com.helpsystems.common.client.util.AboutInfo;
import com.helpsystems.common.client.util.AboutInfoList;
import com.helpsystems.common.client.util.CommonFileFilter;
import com.helpsystems.common.client.util.HSSwingWorker;
import com.helpsystems.common.client.util.SwingWorkerTarget;
import com.helpsystems.common.client.util.WindowSizing;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.dm.CommonMRHelper;
import com.helpsystems.common.core.dm.IApplicationConfigManager;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.enterprise.RBEHelpManager;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.service.AgentProcessInfo;
import com.helpsystems.enterprise.service.AgentServiceAM;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import com.helpsystems.enterprise.tray.AddAgentDialog;
import com.helpsystems.enterprise.tray.AgentServiceEntrySource;
import com.helpsystems.enterprise.tray.ProcessConsoleOutput;
import com.helpsystems.enterprise.tray.ServerEntryConfigDialog;
import com.helpsystems.enterprise.tray.SystemTrayControl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Element;
import org.apache.log4j.Logger;

public class ServiceFrame
extends HSJFrame {
    public static File PROPERTIES_FILE;
    public static final int TAB_CURRENT = -1;
    public static final int TAB_AGENTS = 0;
    public static final int TAB_PROPERTIES = 1;
    public static final int TAB_CONSOLE_OUTPUT = 2;
    private static final Logger logger;
    public static final String SERVICE_DISCONNECTED = "Service disconnected";
    public static final String NO_AGENTS_DEFINED = "No agents are defined";
    public static final String NO_CONSOLE_DEFINED = "Agent has no console data";
    public static final String STATUS_ACTIVE = "Active";
    public static final String STATUS_INACTIVE = "Inactive";
    public static final String STATUS_FAILED = "Failed";
    private static final String DIVIDER = "==================================================================";
    private static final Insets STANDARD_INSETS;
    private static final Insets PANEL_INSETS;
    private static final Dimension MINIMUM_FRAME_SIZE;
    public static final int LOG_TOP = 0;
    public static final int LOG_BOTTOM = 1;
    public static final int LOG_NO_CHANGE = -1;
    private static final String INTERNAL_PRODUCT_NAME = "Automate Schedule Agent";
    private static final String INTERNAL_SHORT_NAME = "agentService";
    public static final String CONFIG_PRODUCT_NAME = "ROBOT_AGENT_SERVICE_2";
    private ComponentListener minSizeListener = null;
    private Component tab_log = null;
    private int logToPosition = 1;
    private final int LOG_FONT_SIZE = 12;
    private JTabbedPane tabs;
    private JList agentList;
    private JButton b_addAgent;
    private JButton b_delAgent;
    private JButton b_EditSettings;
    private JButton b_CopySettings;
    private JButton b_StartAgent;
    private JButton b_StopAgent;
    private JButton b_RestartAgent;
    private JButton b_showAgentLog;
    private JButton b_showServiceDiaog;
    private DataLabel l_agentState;
    private DataLabel l_agentLabel;
    private DataLabel l_agentConfig;
    private DataLabel l_autoStart;
    private DataLabel l_entserver_addr;
    private DataLabel l_entserver_port;
    private DataLabel l_agt_listen_port;
    private DataLabel l_agt_log_file;
    private JPopupMenu agentPopupMenu = null;
    protected HSAction deleteAction = this.makeDeleteAction();
    protected HSAction addAction = this.makeAddAction();
    protected HSAction editAction = this.makeEditAction();
    protected HSAction copyAction = this.makeCopyAction();
    protected HSAction startAction = this.makeStartAction();
    protected HSAction stopAction = this.makeStopAction();
    protected HSAction restartAction = this.makeRestartAction();
    protected HSAction threadDumpAction = this.makeRestartAction();
    protected HSAction showLogFileAction = this.makeShowLogAction();
    protected HSAction showDiagnositicPageAction = this.makeShowDiagnosticPageAction();
    protected HSAction showServerDiagnositicPageAction = this.makeShowServerDiagnosticPageAction();
    protected HSAction showConsoleOutputAction = this.makeShowConsoleOutputAction();
    private HSAction defaultAction = null;
    private JButton defaultButton = null;
    private JTextArea ta_log;
    private JScrollPane logScrollPane;
    private AgentServiceAM agentServiceAM;
    private EntryListModel agentListModel;
    private JComboBox logBox = null;
    private ActionListener logListener = null;
    private ProcessConsoleOutput lastSelectedLog = null;
    private HashMap<String, ProcessConsoleOutput> consoleOutputMap = new HashMap();
    private SystemTrayControl control = null;
    private JButton threadDumpButton;
    private JLabel statusBarLabel = new JLabel();
    private String statusBarText = "";
    private Icon statusBarIcon = null;
    private JPanel statusPanel = null;
    private Border statusBorder = BorderFactory.createBevelBorder(1);
    private MouseListener mo = null;
    private Timer timer = new Timer(20000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ServiceFrame.this.statusBarText = "";
            ServiceFrame.this.statusBarIcon = null;
            ServiceFrame.this.statusBarLabel.setText(ServiceFrame.this.statusBarText);
            ServiceFrame.this.statusBarLabel.setIcon(ServiceFrame.this.statusBarIcon);
        }
    });
    private Map<AgentServiceEntry, String> shutdownMap;

    public ServiceFrame(SystemTrayControl systemTrayControl) {
        this.loadPropertiesFile();
        this.control = systemTrayControl;
        this.setTitle("Automate Schedule Agent Manager");
        this.buildGui();
        WindowSizing.centerWindow((Window)((Object)this), (boolean)true);
        this.setSize(760, 400);
        this.shutdownMap = new HashMap<AgentServiceEntry, String>();
        this.clearAgentInfo();
    }

    void setAgentServiceAM(AgentServiceAM agentServiceAM) {
        this.agentServiceAM = agentServiceAM;
        this.clearAgentInfo();
        this.showServerDiagnositicPageAction.setEnabled(this.agentServiceAM != null);
        if (agentServiceAM == null) {
            JLabel jLabel = new JLabel("Automate Schedule Agent Server is NOT connected.");
            jLabel.setIcon(HSImages.getImage((String)"com/helpsystems/common/client/images/warning_16.png"));
            this.setStatusBarText(jLabel, true);
        } else {
            this.setStatusBarText("Automate Schedule Agent Server is connected.", true);
        }
    }

    void logGrew(final AgentProcessInfo agentProcessInfo, final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServiceFrame.this.agentLogChanged(agentProcessInfo.getEntry(), stringArray);
            }
        });
    }

    void processStarted(AgentProcessInfo agentProcessInfo) {
        this.agentStarted(agentProcessInfo.getEntry());
    }

    void processEnded(AgentProcessInfo agentProcessInfo) {
        this.agentEnded(agentProcessInfo);
    }

    void refreshData() {
        AgentServiceEntry agentServiceEntry = null;
        if (this.agentServiceAM != null) {
            agentServiceEntry = (AgentServiceEntry)this.agentList.getSelectedValue();
        }
        final AgentServiceEntry agentServiceEntry2 = agentServiceEntry;
        final int n = this.agentList.getSelectedIndex();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ServiceFrame.this.agentServiceAM == null) {
                    ServiceFrame.this.agentListModel.refresh();
                    ServiceFrame.this.agentList.clearSelection();
                    ServiceFrame.this.loadLogBox();
                    return;
                }
                ServiceFrame.this.agentListModel.refresh();
                ServiceFrame.this.agentList.clearSelection();
                ServiceFrame.this.loadLogBox();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ServiceFrame.this.lastSelectedLog != null) {
                            ServiceFrame.this.logBox.setSelectedItem(ServiceFrame.this.lastSelectedLog);
                        } else if (ServiceFrame.this.logBox.getItemCount() > 0) {
                            ServiceFrame.this.logBox.setSelectedIndex(0);
                        }
                    }
                });
                int n2 = ServiceFrame.this.agentList.getModel().getSize();
                if (agentServiceEntry2 != null && n2 > 0) {
                    ServiceFrame.this.agentList.setSelectedValue(agentServiceEntry2, true);
                    if (ServiceFrame.this.agentList.getSelectedValue() == null && n < n2) {
                        ServiceFrame.this.agentList.setSelectedIndex(n);
                    }
                }
                ServiceFrame.this.agentList.repaint();
                ServiceFrame.this.updateSelectedListItem();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public boolean validateAlias(AgentServiceEntry agentServiceEntry) {
        AgentServiceEntry[] agentServiceEntryArray;
        for (AgentServiceEntry agentServiceEntry2 : agentServiceEntryArray = this.control.getEntries()) {
            if (!Equal.isEqual((Object)agentServiceEntry.getLabel().toLowerCase(), (Object)agentServiceEntry2.getLabel().toLowerCase())) continue;
            throw new IllegalArgumentException("The Service already contains an entry with the alias '" + agentServiceEntry2.getLabel() + "'");
        }
        return true;
    }

    private void loadPropertiesFile() {
    }

    private void buildGui() {
        SystemTrayControl.updateCustomLNF();
        this.setDefaultHelp(RBEHelpManager.SKYSCH_SERVICE_WINDOW);
        this.setupMinimumSizeListener();
        this.agentPopupMenu = new JPopupMenu();
        this.tabs = new JTabbedPane();
        this.tabs.add("Agents", this.buildAgentPanel());
        this.tabs.add("Properties", this.buildPropsPanel());
        this.tab_log = this.buildLogPanel();
        this.tabs.add("Console Output", this.tab_log);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                switch (ServiceFrame.this.tabs.getSelectedIndex()) {
                    case 0: {
                        ServiceFrame.this.getRootPane().setDefaultButton(ServiceFrame.this.defaultButton);
                        break;
                    }
                    case 1: {
                        ServiceFrame.this.getRootPane().setDefaultButton(ServiceFrame.this.b_showServiceDiaog);
                        break;
                    }
                    case 2: {
                        if (ServiceFrame.this.threadDumpButton.isEnabled()) {
                            ServiceFrame.this.getRootPane().setDefaultButton(ServiceFrame.this.threadDumpButton);
                            break;
                        }
                        ServiceFrame.this.getRootPane().setDefaultButton(null);
                    }
                }
            }
        });
        this.logListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                ServiceFrame.this.lastSelectedLog = (ProcessConsoleOutput)jComboBox.getSelectedItem();
                this.setThreadDumpActionState(ServiceFrame.this.lastSelectedLog);
                ServiceFrame.this.displayLog(ServiceFrame.this.lastSelectedLog);
                if (ServiceFrame.this.tabs.getSelectedIndex() == 2) {
                    if (ServiceFrame.this.threadDumpButton.isEnabled()) {
                        ServiceFrame.this.getRootPane().setDefaultButton(ServiceFrame.this.threadDumpButton);
                    } else {
                        ServiceFrame.this.getRootPane().setDefaultButton(null);
                    }
                }
            }

            private void setThreadDumpActionState(Object object) {
                if (object instanceof ProcessConsoleOutput) {
                    AgentServiceEntry agentServiceEntry = ((ProcessConsoleOutput)object).ase;
                    if (agentServiceEntry != null) {
                        ServiceFrame.this.threadDumpAction.setEnabled(ServiceFrame.this.isEntryAlive(agentServiceEntry));
                    } else {
                        ServiceFrame.this.threadDumpAction.setEnabled(false);
                    }
                    if (ServiceFrame.this.tabs.getSelectedIndex() == 2) {
                        if (ServiceFrame.this.threadDumpButton.isEnabled()) {
                            ServiceFrame.this.getRootPane().setDefaultButton(ServiceFrame.this.threadDumpButton);
                        } else {
                            ServiceFrame.this.getRootPane().setDefaultButton(null);
                        }
                    }
                }
            }
        };
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)this.tabs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setupStatusBar(container);
    }

    private void updateSelectedListItem() {
        if (this.agentServiceAM == null) {
            return;
        }
        AgentServiceEntry agentServiceEntry = null;
        Runnable runnable = null;
        if (!this.agentList.getSelectionModel().isSelectionEmpty()) {
            if (this.control.getEntries().length != 0) {
                agentServiceEntry = (AgentServiceEntry)this.agentList.getSelectedValue();
            }
        } else {
            runnable = new Runnable(){

                @Override
                public void run() {
                    ServiceFrame.this.agentList.setSelectedIndex(0);
                    AgentServiceEntry agentServiceEntry = (AgentServiceEntry)ServiceFrame.this.agentList.getSelectedValue();
                    if (agentServiceEntry == null) {
                        return;
                    }
                    Object v = ServiceFrame.this.consoleOutputMap.get(agentServiceEntry.getLabel());
                    ServiceFrame.this.logBox.setSelectedItem(v);
                    ServiceFrame.this.displayLog(v);
                }
            };
        }
        final AgentServiceEntry agentServiceEntry2 = agentServiceEntry;
        if (runnable == null) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    ServiceFrame.this.updateAgentInformation(agentServiceEntry2);
                }
            };
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void clearAgentInfo() {
        if (this.agentServiceAM == null) {
            this.addAction.setEnabled(false);
        } else {
            this.addAction.setEnabled(true);
            this.defaultAction = this.addAction;
            this.defaultButton = this.b_addAgent;
            this.setDefaultButton(this.b_addAgent);
        }
        this.deleteAction.setEnabled(false);
        this.editAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.startAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        this.restartAction.setEnabled(false);
        this.showLogFileAction.setEnabled(false);
        this.showDiagnositicPageAction.setEnabled(false);
        this.showConsoleOutputAction.setEnabled(false);
        this.l_agentState.setText("");
        this.l_agentState.setIcon(null);
        this.l_agentLabel.setText("");
        this.l_agentConfig.setText("");
        this.l_autoStart.setText("");
        this.l_entserver_addr.setText("");
        this.l_entserver_port.setText("");
        this.l_agt_listen_port.setText("");
        this.l_agt_log_file.setText("");
        this.shutdownMap.clear();
    }

    private void updateAgentStateInfo(AgentServiceEntry agentServiceEntry) {
        AgentServiceEntry agentServiceEntry2 = agentServiceEntry;
        if (agentServiceEntry2 == null) {
            Object e = this.agentList.getSelectedValue();
            if (e instanceof AgentServiceEntry) {
                agentServiceEntry2 = (AgentServiceEntry)e;
            } else {
                return;
            }
        }
        this.addAction.setEnabled(true);
        boolean bl = this.isEntryAlive(agentServiceEntry2);
        this.deleteAction.setEnabled(!bl);
        this.editAction.setEnabled(!bl);
        this.copyAction.setEnabled(true);
        this.startAction.setEnabled(!bl);
        this.stopAction.setEnabled(bl);
        this.restartAction.setEnabled(bl);
        this.showDiagnositicPageAction.setEnabled(bl);
        this.showConsoleOutputAction.setEnabled(true);
        JLabel jLabel = this.getStateDescription(agentServiceEntry2, false, true, false);
        this.l_agentState.setText(jLabel.getText());
        this.l_agentState.setIcon(jLabel.getIcon());
        this.l_agentLabel.setText(agentServiceEntry2.getLabel());
        this.l_agentConfig.setText(agentServiceEntry2.getFilename());
        this.l_autoStart.setText(Convert.booleanToYesNo((boolean)agentServiceEntry2.getAutostart()));
        this.showLogFileAction.setEnabled(true);
        if (bl) {
            this.defaultAction = this.stopAction;
            this.defaultButton = this.b_StopAgent;
            this.setDefaultButton(this.b_StopAgent);
        } else {
            this.defaultAction = this.editAction;
            this.defaultButton = this.b_EditSettings;
            this.setDefaultButton(this.b_EditSettings);
        }
    }

    public void setDefaultButton(JButton jButton) {
        if (!this.agentList.hasFocus()) {
            jButton.requestFocusInWindow();
        }
        super.setDefaultButton(jButton);
    }

    private void updateEntServerInformation(PeerDescriptor peerDescriptor) {
        if (peerDescriptor != null) {
            String[] stringArray = peerDescriptor.getAddresses();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].trim().length() <= 0) continue;
                this.l_entserver_addr.setText(stringArray[i]);
                break;
            }
            this.l_entserver_port.setText(String.valueOf(peerDescriptor.getPort()));
        } else {
            this.l_entserver_addr.setText("N/A");
            this.l_entserver_port.setText("N/A");
        }
    }

    private void updatePeerConfigInformation(AgentPeerConfig agentPeerConfig) {
        if (agentPeerConfig != null) {
            this.l_agt_listen_port.setText(String.valueOf(agentPeerConfig.getListenPort()));
            String string = "log4j.appender.R.File";
            String string2 = (String)agentPeerConfig.getLog4jProperties().get(string);
            if (string2 != null) {
                this.l_agt_log_file.setText(string2);
            } else {
                this.l_agt_log_file.setText("Not specified");
            }
        } else {
            this.l_agt_listen_port.setText("N/A");
            this.l_agt_log_file.setText("N/A");
        }
    }

    private void updateAgentInformation(AgentServiceEntry agentServiceEntry) {
        if (agentServiceEntry == null) {
            this.clearAgentInfo();
        } else {
            this.updateAgentStateInfo(agentServiceEntry);
            AgentPeerConfig agentPeerConfig = null;
            PeerDescriptor peerDescriptor = null;
            try {
                agentPeerConfig = agentServiceEntry.loadPeerConfig();
                peerDescriptor = agentPeerConfig.getMaster();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateEntServerInformation(peerDescriptor);
            this.updatePeerConfigInformation(agentPeerConfig);
        }
    }

    public AgentServiceEntry getSelectedEntry() {
        Object e = this.agentList.getSelectedValue();
        if (e instanceof AgentServiceEntry) {
            return (AgentServiceEntry)e;
        }
        return null;
    }

    private JPanel buildAgentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.agentListModel = new EntryListModel();
        this.agentList = new JList(this.agentListModel);
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                AgentServiceEntry agentServiceEntry = (AgentServiceEntry)object;
                String string = null;
                string = agentServiceEntry == null ? (ServiceFrame.this.agentServiceAM == null ? ServiceFrame.SERVICE_DISCONNECTED : ServiceFrame.NO_AGENTS_DEFINED) : agentServiceEntry.getLabel();
                super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                if (object == null) {
                    this.setIcon(null);
                } else {
                    AgentProcessInfo agentProcessInfo = null;
                    agentProcessInfo = ServiceFrame.this.control.getProcess(agentServiceEntry);
                    ImageIcon imageIcon = SystemTrayControl.getAgentProcessInfoIcon(agentProcessInfo);
                    this.setIcon(imageIcon);
                    if (ServiceFrame.this.mo != null) {
                        this.addMouseListener(ServiceFrame.this.mo);
                    }
                }
                return this;
            }
        };
        this.agentList.setCellRenderer(defaultListCellRenderer);
        this.agentList.setSelectionMode(0);
        this.agentList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ServiceFrame.this.updateSelectedListItem();
                }
            }
        });
        this.agentList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ServiceFrame.this.deleteAction.isEnabled()) {
                                ServiceFrame.this.b_delAgent.doClick();
                            }
                        }
                    });
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.agentPopupMenu.add((Action)this.addAction);
        this.agentPopupMenu.add((Action)this.deleteAction);
        this.agentPopupMenu.add((Action)this.editAction);
        this.agentPopupMenu.add((Action)this.copyAction);
        this.agentPopupMenu.addSeparator();
        this.agentPopupMenu.add((Action)this.startAction);
        this.agentPopupMenu.add((Action)this.stopAction);
        this.agentPopupMenu.add((Action)this.restartAction);
        this.agentPopupMenu.addSeparator();
        this.agentPopupMenu.add((Action)this.showConsoleOutputAction);
        this.agentPopupMenu.add((Action)this.showDiagnositicPageAction);
        this.agentPopupMenu.addSeparator();
        AgentServiceEntrySource agentServiceEntrySource = new AgentServiceEntrySource(){

            @Override
            public AgentServiceEntry getEntry() {
                return ServiceFrame.this.getSelectedEntry();
            }
        };
        JMenu jMenu = this.control.getLoggingLevelMenu(this, agentServiceEntrySource);
        this.agentPopupMenu.add(jMenu);
        this.agentList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Object object = mouseEvent.getSource();
                if (object instanceof JList) {
                    Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                    int n = ServiceFrame.this.agentList.locationToIndex(point);
                    if (n <= ServiceFrame.this.agentList.getModel().getSize() && n != -1 && (object = ServiceFrame.this.agentList.getModel().getElementAt(n)) instanceof AgentServiceEntry) {
                        ServiceFrame.this.setStatusBarText(ServiceFrame.this.getQuickText((AgentServiceEntry)object), false);
                    }
                }
            }
        });
        this.agentList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ServiceFrame.this.agentServiceAM == null) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int n = ServiceFrame.this.agentList.locationToIndex(mouseEvent.getPoint());
                    ServiceFrame.this.agentList.setSelectedIndex(n);
                    ServiceFrame.this.agentPopupMenu.show(ServiceFrame.this.agentList, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getClickCount() > 1 && ServiceFrame.this.defaultAction != null && ServiceFrame.this.defaultAction.isEnabled()) {
                    ServiceFrame.this.defaultAction.actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "double-click"));
                }
            }
        });
        this.b_addAgent = new JButton((Action)this.addAction);
        this.showLogFileAction.setEnabled(false);
        this.b_showAgentLog = new JButton((Action)this.showLogFileAction);
        this.deleteAction.setEnabled(false);
        this.b_delAgent = new JButton((Action)this.deleteAction);
        this.editAction.setEnabled(false);
        this.b_EditSettings = new JButton((Action)this.editAction);
        this.copyAction.setEnabled(false);
        this.b_CopySettings = new JButton((Action)this.copyAction);
        this.startAction.setEnabled(false);
        this.b_StartAgent = new JButton((Action)this.startAction);
        this.stopAction.setEnabled(false);
        this.b_StopAgent = new JButton((Action)this.stopAction);
        this.restartAction.setEnabled(false);
        this.b_RestartAgent = new JButton((Action)this.restartAction);
        this.showServerDiagnositicPageAction.setEnabled(false);
        this.b_showServiceDiaog = new JButton((Action)this.showServerDiagnositicPageAction);
        JPanel jPanel2 = this.makeListButtonPanel();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Agent Information");
        jPanel3.setBorder(titledBorder);
        this.l_agentState = new DataLabel();
        this.l_agentLabel = new DataLabel();
        this.l_agentConfig = new DataLabel();
        this.l_autoStart = new DataLabel();
        this.l_entserver_addr = new DataLabel();
        this.l_entserver_port = new DataLabel();
        this.l_agt_listen_port = new DataLabel();
        this.l_agt_log_file = new DataLabel();
        jPanel3.add((Component)new JLabel("Status:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)this.l_agentState, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)new JLabel("Alias:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)this.l_agentLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)new JLabel("Configuration File:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)this.l_agentConfig, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)new JLabel("Auto Start:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)this.l_autoStart, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)new JLabel("Server Address:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)this.l_entserver_addr, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)new JLabel("Server Listen Port:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)this.l_entserver_port, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)new JLabel("Agent Listen Port:"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)this.l_agt_listen_port, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)new JLabel("Log File:"), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        jPanel3.add((Component)this.l_agt_log_file, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 18, 2, STANDARD_INSETS, 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jPanel4, new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 14, 0, STANDARD_INSETS, 0, 0));
        jPanel4.add((Component)this.b_showAgentLog, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 14, 0, STANDARD_INSETS, 0, 0));
        jPanel.setPreferredSize(new Dimension(700, 400));
        JScrollPane jScrollPane = new JScrollPane(this.agentList);
        jScrollPane.setPreferredSize(new Dimension(150, 200));
        jScrollPane.setMinimumSize(new Dimension(150, 200));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, STANDARD_INSETS, 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 1, PANEL_INSETS, 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 11, 1, STANDARD_INSETS, 0, 0));
        return jPanel;
    }

    private JPanel makeListButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = STANDARD_INSETS;
        jPanel.add((Component)this.b_addAgent, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.b_delAgent, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.b_EditSettings, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.b_CopySettings, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setMinimumSize(this.b_CopySettings.getPreferredSize());
        jPanel2.setPreferredSize(this.b_CopySettings.getPreferredSize());
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.b_StartAgent, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.b_StopAgent, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.b_RestartAgent, gridBagConstraints);
        return jPanel;
    }

    private void setupStatusBar(Container container) {
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(22, 22));
        jPanel.setMinimumSize(new Dimension(22, 22));
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(this.statusBorder);
        jPanel.add((Component)this.statusBarLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.statusPanel.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 0, 2, 0), 0, 0));
        container.add((Component)this.statusPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.timer.setRepeats(false);
        this.timer.setCoalesce(true);
        this.mo = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Object object = mouseEvent.getSource();
                if (object instanceof AbstractButton) {
                    AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                    if (abstractButton.getAction() != null) {
                        ServiceFrame.this.setStatusBarText((String)abstractButton.getAction().getValue("LongDescription"), false);
                    }
                } else if (object instanceof JLabel && ((JLabel)object).getIcon() instanceof ImageIcon) {
                    ServiceFrame.this.setStatusBarText(((ImageIcon)((JLabel)object).getIcon()).getDescription(), false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JLabel jLabel = new JLabel(ServiceFrame.this.statusBarText);
                jLabel.setIcon(ServiceFrame.this.statusBarIcon);
                ServiceFrame.this.setStatusBarText(jLabel, false);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                JLabel jLabel = new JLabel(ServiceFrame.this.statusBarText);
                jLabel.setIcon(ServiceFrame.this.statusBarIcon);
                ServiceFrame.this.setStatusBarText(jLabel, false);
            }
        };
        this.setMouseListenerOnContainer(container, this.mo);
        this.agentList.addMouseListener(this.mo);
    }

    protected JLabel getQuickText(AgentServiceEntry agentServiceEntry) {
        return this.getStateDescription(agentServiceEntry, false, true, true);
    }

    private void setMouseListenerOnContainer(Container container, MouseListener mouseListener) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof AbstractButton) {
                component.addMouseListener(mouseListener);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.setMouseListenerOnContainer((Container)component, mouseListener);
        }
    }

    public void setStatusBarText(final String string, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ServiceFrame.this.statusBarText.length() > 0) {
                    ServiceFrame.this.timer.restart();
                } else if (string.trim().length() > 0) {
                    ServiceFrame.this.timer.restart();
                } else {
                    ServiceFrame.this.timer.stop();
                }
                if (bl) {
                    ServiceFrame.this.statusBarText = string;
                    ServiceFrame.this.statusBarIcon = null;
                }
                ServiceFrame.this.statusBarLabel.setText(string);
                ServiceFrame.this.statusBarLabel.setIcon(null);
            }
        });
    }

    public void setStatusBarText(final JLabel jLabel, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = jLabel.getText();
                if (ServiceFrame.this.statusBarText.length() > 0) {
                    ServiceFrame.this.timer.restart();
                } else if (string.trim().length() > 0) {
                    ServiceFrame.this.timer.restart();
                } else {
                    ServiceFrame.this.timer.stop();
                }
                if (bl) {
                    ServiceFrame.this.statusBarText = string;
                    ServiceFrame.this.statusBarIcon = jLabel.getIcon();
                }
                ServiceFrame.this.statusBarLabel.setText(string);
                ServiceFrame.this.statusBarLabel.setIcon(jLabel.getIcon());
            }
        });
    }

    public void addStatusPanel(JPanel jPanel) {
        jPanel.setBorder(this.statusBorder);
        jPanel.setPreferredSize(new Dimension(150, 22));
        jPanel.setMinimumSize(new Dimension(150, 22));
        this.statusPanel.add((Component)jPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(1, 0, 2, 0), 0, 0));
    }

    private Component buildPropsPanel() {
        String string = System.getProperty("helpsystems.module.dir");
        if (string == null || string.length() == 0) {
            string = "lib";
        }
        JarAttributes jarAttributes = this.getJarInfo(string + "/transport-module.jar");
        JarAttributes jarAttributes2 = this.getJarInfo(string + "/schent-mp-module.jar");
        JarAttributes jarAttributes3 = this.getJarInfo(string + "/schent-mp-tray.jar");
        AboutInfoList aboutInfoList = new AboutInfoList();
        aboutInfoList.add(new AboutInfo("Version", jarAttributes3.getRelMod()));
        aboutInfoList.add(new AboutInfo("Copyright", "HelpSystems, LLC"));
        aboutInfoList.add(new AboutInfo("Phone", "(952) 746-4786"));
        aboutInfoList.add(new AboutInfo("Fax", "(952) 238-8414"));
        aboutInfoList.add(new AboutInfo("Website", "www.helpsystems.com/product-lines/automate"));
        aboutInfoList.add(new AboutInfo("=== Application Information ===", DIVIDER));
        aboutInfoList.add(new AboutInfo("Transport Module", jarAttributes.getBuildTimeStamp()));
        aboutInfoList.add(new AboutInfo("Schedule Enterprise Module", jarAttributes2.getBuildTimeStamp()));
        aboutInfoList.add(new AboutInfo("=== Java Properties ===", DIVIDER));
        aboutInfoList.addVirtualMachineProperties();
        aboutInfoList.add(new AboutInfo("=== System Environment ===", DIVIDER));
        aboutInfoList.addSystemProperties();
        AboutInfoPanel aboutInfoPanel = new AboutInfoPanel(aboutInfoList);
        aboutInfoPanel.resetColumnWidths(190, 535);
        aboutInfoPanel.setHonorKeyboardFocus(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel("Java Properties and System Environment"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, STANDARD_INSETS, 0, 0));
        jPanel.add((Component)this.b_showServiceDiaog, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, STANDARD_INSETS, 0, 0));
        jPanel.add((Component)aboutInfoPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, STANDARD_INSETS, 0, 0));
        return jPanel;
    }

    private JarAttributes getJarInfo(String string) {
        JarAttributes jarAttributes = new JarAttributes();
        try {
            JarFile jarFile = new JarFile(string);
            Manifest manifest = jarFile.getManifest();
            jarFile.close();
            if (manifest == null) {
                throw new IOException("The manifest in " + string + " is missing.");
            }
            Attributes attributes = manifest.getMainAttributes();
            Attributes attributes2 = manifest.getAttributes("Help/Systems");
            if (attributes == null) {
                throw new IOException("The manifest in " + string + " is missing the main section.");
            }
            if (attributes2 == null) {
                throw new IOException("The manifest in " + string + " is missing the 'Help/Systems' section.");
            }
            jarAttributes.specificationVersion = attributes.getValue("Specification-Version");
            jarAttributes.jarModuleName = attributes2.getValue("Module-Name");
            jarAttributes.moduleVersion = attributes2.getValue("Module-Version");
            jarAttributes.buildDate = attributes2.getValue("Build-Date");
            jarAttributes.buildTime = attributes2.getValue("Build-Time");
            jarAttributes.initClass = attributes2.getValue("Module-Init-Class");
        }
        catch (Throwable throwable) {
            logger.error((Object)("Error getting jar attributes: " + string), throwable);
        }
        return jarAttributes;
    }

    private Component buildLogPanel() {
        JPanel jPanel = new JPanel();
        this.threadDumpAction = this.makeThreadDumpAction();
        this.threadDumpButton = new JButton((Action)this.threadDumpAction);
        this.threadDumpAction.setEnabled(false);
        this.threadDumpButton.setToolTipText("Press the Thread Dump button to perform a thread dump.");
        this.ta_log = new JTextArea(80, 25);
        MouseAdapter mouseAdapter = new MouseAdapter(){
            JPopupMenu popup = null;
            JMenuItem miCopy = null;
            JMenuItem miSelectAll = null;
            JMenuItem miSave = null;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void setPopupMenuStates() {
                if (this.popup == null) {
                    this.popup = new JPopupMenu();
                    this.miCopy = new JMenuItem((Action)ServiceFrame.this.setupCopyAction(ServiceFrame.this.ta_log));
                    this.miCopy.setIcon(HSImages.getImage((String)"com/helpsystems/common/client/images/copy_16.png"));
                    this.popup.add(this.miCopy);
                    this.miSelectAll = new JMenuItem((Action)ServiceFrame.this.setupSelectAllAction(ServiceFrame.this.ta_log));
                    this.miSelectAll.setIcon(HSImages.getImage((String)"com/helpsystems/common/client/images/transparent_16.png"));
                    this.popup.add(this.miSelectAll);
                    this.miSave = new JMenuItem((Action)ServiceFrame.this.setupSaveAction(ServiceFrame.this.ta_log));
                    this.miSave.setIcon(HSImages.getImage((String)"com/helpsystems/common/client/images/disk_blue_16.png"));
                    this.popup.add(this.miSave);
                }
                boolean bl = ServiceFrame.this.ta_log.getSelectedText() != null;
                this.miCopy.setEnabled(bl);
                this.miSave.setEnabled(bl);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                this.setPopupMenuStates();
                if (mouseEvent.isPopupTrigger()) {
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.ta_log.addMouseListener(mouseAdapter);
        this.ta_log.setFont(new Font("monospaced", 0, 12));
        this.ta_log.setEditable(false);
        jPanel.setLayout(new GridBagLayout());
        this.logScrollPane = new JScrollPane(this.ta_log);
        this.logScrollPane.setAlignmentX(0.0f);
        this.setupLogBox();
        jPanel.add((Component)new JLabel("Select Agent Console to view:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, STANDARD_INSETS, 0, 0));
        jPanel.add((Component)this.logBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, STANDARD_INSETS, 0, 0));
        jPanel.add((Component)this.threadDumpButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, STANDARD_INSETS, 0, 0));
        jPanel.add((Component)this.logScrollPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 1, STANDARD_INSETS, 0, 0));
        return jPanel;
    }

    private void setupLogBox() {
        this.logBox = new JComboBox();
        this.logBox.setModel(new SortedPCOComboBoxModel());
        this.logBox.addActionListener(this.logListener);
        this.logBox.setEditable(false);
        this.logBox.setPreferredSize(new Dimension(120, 20));
        this.logBox.setMinimumSize(new Dimension(120, 20));
        SwingUtilities.updateComponentTreeUI(this.logBox);
        this.logBox.invalidate();
    }

    private void loadLogBox() {
        AgentServiceEntry[] agentServiceEntryArray;
        if (this.logBox != null) {
            this.lastSelectedLog = (ProcessConsoleOutput)this.logBox.getSelectedItem();
            this.logBox.removeActionListener(this.logListener);
            this.logBox.removeAllItems();
        }
        if ((agentServiceEntryArray = this.control.getEntries()).length < 1) {
            this.ta_log.setText("");
            this.threadDumpAction.setEnabled(false);
        }
        for (int i = 0; i < agentServiceEntryArray.length; ++i) {
            this.addToLogBox(agentServiceEntryArray[i]);
        }
        this.logBox.invalidate();
        this.logBox.addActionListener(this.logListener);
        this.logBox.updateUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLogBox(AgentServiceEntry agentServiceEntry) {
        if (agentServiceEntry != null && this.logBox != null && this.agentServiceAM != null) {
            Serializable serializable;
            ProcessConsoleOutput processConsoleOutput = new ProcessConsoleOutput(agentServiceEntry);
            AgentProcessInfo agentProcessInfo = this.control.getProcess(agentServiceEntry);
            if (agentProcessInfo != null && this.agentServiceAM != null) {
                serializable = agentProcessInfo.getEntry();
                HSSwingWorker hSSwingWorker = new HSSwingWorker((AgentServiceEntry)serializable, processConsoleOutput){
                    String[] lines;
                    final /* synthetic */ AgentServiceEntry val$entry;
                    final /* synthetic */ ProcessConsoleOutput val$pco;
                    {
                        this.val$entry = agentServiceEntry;
                        this.val$pco = processConsoleOutput;
                    }

                    public Object construct() {
                        try {
                            this.lines = ServiceFrame.this.agentServiceAM.getLog(this.val$entry);
                        }
                        catch (ActionFailedException actionFailedException) {
                            logger.debug((Object)("Unable to access console/process log for agent " + this.val$entry.getLabel()), (Throwable)actionFailedException);
                        }
                        return null;
                    }

                    public void finished() {
                        this.val$pco.addLines(this.lines);
                    }
                };
                hSSwingWorker.start();
            }
            this.logBox.removeItem(processConsoleOutput);
            this.logBox.addItem(processConsoleOutput);
            serializable = this.consoleOutputMap;
            synchronized (serializable) {
                this.consoleOutputMap.put(processConsoleOutput.alias, processConsoleOutput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromLogBox(AgentServiceEntry agentServiceEntry) {
        if (agentServiceEntry != null && this.logBox != null) {
            HashMap<String, ProcessConsoleOutput> hashMap = this.consoleOutputMap;
            synchronized (hashMap) {
                ProcessConsoleOutput processConsoleOutput = this.consoleOutputMap.get(agentServiceEntry.getLabel());
                if (processConsoleOutput != null) {
                    this.logBox.removeItem(processConsoleOutput);
                    this.consoleOutputMap.remove(processConsoleOutput.alias);
                }
            }
            if (this.logBox.getModel().getSize() > 0) {
                this.logBox.setSelectedIndex(0);
            }
            this.logBox.invalidate();
            this.logBox.repaint();
        }
    }

    private void updateLogBox(AgentServiceEntry agentServiceEntry) {
        ProcessConsoleOutput processConsoleOutput;
        Object object = this.logBox.getSelectedItem();
        this.removeFromLogBox(agentServiceEntry);
        this.addToLogBox(agentServiceEntry);
        if (object instanceof ProcessConsoleOutput && (processConsoleOutput = (ProcessConsoleOutput)object).getAgentServiceEntry().equals(agentServiceEntry)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServiceFrame.this.logBox.setSelectedItem(processConsoleOutput);
                }
            });
        }
    }

    private void updateLogBox(AgentServiceEntry agentServiceEntry, AgentServiceEntry agentServiceEntry2) {
        this.removeFromLogBox(agentServiceEntry);
        this.addToLogBox(agentServiceEntry2);
    }

    private void displayLog(Object object) {
        if (object instanceof ProcessConsoleOutput) {
            final ProcessConsoleOutput processConsoleOutput = (ProcessConsoleOutput)object;
            SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){
                StringBuffer sb = new StringBuffer();

                public void construct() {
                    String[] stringArray = processConsoleOutput.getOutPut();
                    if (stringArray == null || stringArray.length < 1 || stringArray[0] == null) {
                        this.sb.append(ServiceFrame.NO_CONSOLE_DEFINED);
                        this.sb.append("\n");
                    } else {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i] == null) continue;
                            this.sb.append(stringArray[i].toString());
                            this.sb.append("\n");
                        }
                    }
                }

                public void finished() {
                    ServiceFrame.this.ta_log.setText(this.sb.toString().trim());
                    switch (ServiceFrame.this.logToPosition) {
                        case 1: {
                            ServiceFrame.this.scrollToLogLine(ServiceFrame.this.ta_log.getLineCount());
                            break;
                        }
                        case 0: {
                            ServiceFrame.this.scrollToLogLine(1);
                            break;
                        }
                    }
                }
            };
            swingWorkerTarget.setForceFinishedCall(true);
            this.suspendAndRun(swingWorkerTarget);
        }
    }

    public void scrollToLogLine(int n) {
        try {
            Element element = this.ta_log.getDocument().getDefaultRootElement().getElement(n - 1);
            this.ta_log.setCaretPosition(element.getStartOffset());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void agentLogChanged(AgentServiceEntry agentServiceEntry, String[] stringArray) {
        if (this.logBox == null) return;
        ProcessConsoleOutput processConsoleOutput = null;
        String[] stringArray2 = this.consoleOutputMap;
        synchronized (this.consoleOutputMap) {
            processConsoleOutput = this.consoleOutputMap.get(agentServiceEntry.getLabel());
            if (processConsoleOutput != null) {
                processConsoleOutput.addLines(stringArray);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (processConsoleOutput != null && processConsoleOutput.equals(this.lastSelectedLog)) {
                this.displayLog(processConsoleOutput);
            }
            for (String string : stringArray) {
                if (!string.startsWith("Shutdown Request: ")) continue;
                this.shutdownMap.put(agentServiceEntry, string.substring("Shutdown Request: ".length()));
                this.updateAgentInformation(agentServiceEntry);
            }
            return;
        }
    }

    public void agentStarted(AgentServiceEntry agentServiceEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Agent ");
        stringBuffer.append(agentServiceEntry.getLabel());
        stringBuffer.append(" started.");
        JLabel jLabel = new JLabel(stringBuffer.toString());
        jLabel.setIcon(SystemTrayControl.getActiveIcon());
        this.setStatusBarText(jLabel, true);
        jLabel = null;
        this.updateGUI(agentServiceEntry);
    }

    public void agentEnded(AgentProcessInfo agentProcessInfo) {
        AgentServiceEntry agentServiceEntry = agentProcessInfo.getEntry();
        if (agentProcessInfo.getProcessExitValue() == -1) {
            return;
        }
        this.shutdownMap.remove(agentServiceEntry);
        StringBuffer stringBuffer = new StringBuffer();
        JLabel jLabel = new JLabel();
        stringBuffer.append("Agent ");
        stringBuffer.append(agentServiceEntry.getLabel());
        int n = agentProcessInfo.getProcessExitValue();
        if (n == 0 || n == 99) {
            stringBuffer.append(" ended.");
            jLabel.setIcon(SystemTrayControl.getInactiveIcon());
        } else if (n == 97) {
            stringBuffer.append(" is updating itself.");
            jLabel.setIcon(SystemTrayControl.getInactiveIcon());
        } else {
            stringBuffer.append(" failed. Cause: ");
            stringBuffer.append(SystemTrayControl.getFailureMessage(agentProcessInfo));
            stringBuffer.append("...");
            jLabel.setIcon(SystemTrayControl.getFailedIcon());
        }
        jLabel.setText(stringBuffer.toString());
        this.setStatusBarText(jLabel, true);
        jLabel = null;
        this.control.rebuildMenu(true);
    }

    private void updateGUI(AgentServiceEntry agentServiceEntry) {
        this.control.rebuildMenu(true);
        this.updateLogBox(agentServiceEntry);
    }

    private boolean isEntryAlive(AgentServiceEntry agentServiceEntry) {
        if (this.agentServiceAM == null) {
            return false;
        }
        AgentProcessInfo agentProcessInfo = this.control.getProcess(agentServiceEntry);
        return agentProcessInfo != null && agentProcessInfo.isAlive();
    }

    private JLabel getStateDescription(AgentServiceEntry agentServiceEntry, boolean bl, boolean bl2, boolean bl3) {
        JLabel jLabel = new JLabel();
        AgentProcessInfo agentProcessInfo = null;
        agentProcessInfo = this.control.getProcess(agentServiceEntry);
        ImageIcon imageIcon = SystemTrayControl.getAgentProcessInfoIcon(agentProcessInfo);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(agentServiceEntry.getLabel());
        } else {
            if (bl3) {
                stringBuffer.append(agentServiceEntry.getLabel());
                stringBuffer.append(" - ");
            }
            if (agentProcessInfo == null) {
                stringBuffer.append(STATUS_INACTIVE);
            } else if (agentProcessInfo.isAlive()) {
                if (this.shutdownMap.get(agentServiceEntry) != null) {
                    stringBuffer.append(this.shutdownMap.get(agentServiceEntry));
                } else {
                    stringBuffer.append(STATUS_ACTIVE);
                }
            } else if (agentProcessInfo.getProcessExitValue() > 0) {
                stringBuffer.append(STATUS_FAILED);
                if (bl2) {
                    stringBuffer.append(" - ");
                    stringBuffer.append(SystemTrayControl.getFailureMessage(agentProcessInfo));
                }
            } else {
                stringBuffer.append(STATUS_INACTIVE);
            }
        }
        jLabel.setText(stringBuffer.toString());
        jLabel.setIcon(imageIcon);
        if (this.mo != null) {
            jLabel.addMouseListener(this.mo);
        }
        return jLabel;
    }

    private HSAction makeAddAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){
                    AgentServiceEntry agentEntry = null;
                    Throwable t = null;

                    public void construct() {
                        this.agentEntry = AddAgentDialog.showAndGetServiceEntry(ServiceFrame.this, ServiceFrame.this.agentServiceAM);
                        if (this.agentEntry != null) {
                            ServiceFrame.this.agentListModel.addEntry(this.agentEntry);
                        }
                    }

                    public void finished() {
                        if (this.t != null) {
                            ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)this.t.getLocalizedMessage(), (Throwable)this.t);
                            return;
                        }
                        if (this.agentEntry != null) {
                            ServiceFrame.this.agentList.invalidate();
                            ServiceFrame.this.addToLogBox(this.agentEntry);
                            ServiceFrame.this.repaint();
                        }
                    }
                };
                swingWorkerTarget.setForceFinishedCall(true);
                ServiceFrame.this.suspendAndRun(swingWorkerTarget);
            }
        };
        hSAction.setName("Add");
        hSAction.setMnemonicKey(65);
        hSAction.setLongDescription("Add an agent.");
        return hSAction;
    }

    private HSAction makeEditAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AgentServiceEntry agentServiceEntry = null;
                try {
                    Object[] objectArray = ServiceFrame.this.agentList.getSelectedValues();
                    if (objectArray.length == 0) {
                        throw new IllegalStateException("An agent configuration entry must be selected.");
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        agentServiceEntry = (AgentServiceEntry)objectArray[i];
                        ServiceFrame.this.editAnEntry(agentServiceEntry);
                    }
                }
                catch (Throwable throwable) {
                    ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                    return;
                }
            }
        };
        hSAction.setName("Edit");
        hSAction.setMnemonicKey(69);
        hSAction.setLongDescription("Edit the selected agent.");
        return hSAction;
    }

    private HSAction makeThreadDumpAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ServiceFrame.this.agentServiceAM == null) {
                        return;
                    }
                    Object object = ServiceFrame.this.logBox.getSelectedItem();
                    if (!(object instanceof ProcessConsoleOutput)) {
                        return;
                    }
                    final AgentServiceEntry agentServiceEntry = ((ProcessConsoleOutput)object).getAgentServiceEntry();
                    if (agentServiceEntry == null) {
                        return;
                    }
                    SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){

                        public void construct() {
                            AgentProcessInfo agentProcessInfo = ServiceFrame.this.control.getProcess(agentServiceEntry);
                            if (agentProcessInfo == null || !agentProcessInfo.isAlive()) {
                                throw new RuntimeException(agentServiceEntry.getLabel() + " is not active.");
                            }
                            ServiceFrame.this.agentServiceAM.writeThreadDump(agentServiceEntry);
                        }
                    };
                    ServiceFrame.this.suspendAndRun(swingWorkerTarget);
                }
                catch (Throwable throwable) {
                    ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                    return;
                }
            }
        };
        hSAction.setName("Thread Dump");
        hSAction.setMnemonicKey(72);
        hSAction.setLongDescription("Perform a Thread Dump of the agent process.");
        return hSAction;
    }

    private void editAnEntry(final AgentServiceEntry agentServiceEntry) throws FileNotFoundException {
        SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){
            AgentServiceEntry agentEntry;
            ServerEntryConfigDialog secd;
            {
                this.agentEntry = agentServiceEntry;
                this.secd = null;
            }

            public void construct() {
                block5: {
                    try {
                        this.secd = new ServerEntryConfigDialog(ServiceFrame.this, this.agentEntry, 1);
                        if (ServiceFrame.this.agentServiceAM != null) {
                            this.secd.setValidator(ServiceFrame.this.agentServiceAM);
                            this.secd.setVisible(true);
                            this.agentEntry = this.secd.getAgentServiceEntry();
                            if (this.agentEntry != null) {
                                if (!agentServiceEntry.getLabel().equals(this.agentEntry.getLabel())) {
                                    ServiceFrame.this.updateLogBox(agentServiceEntry, this.agentEntry);
                                }
                                ServiceFrame.this.agentServiceAM.removeEntry(agentServiceEntry);
                                ServiceFrame.this.agentServiceAM.addEntry(this.agentEntry);
                            }
                            break block5;
                        }
                        throw new IllegalStateException("Edit cannot happen the Agent Server is disconnected.");
                    }
                    catch (Throwable throwable) {
                        ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                        return;
                    }
                }
            }

            public void finished() {
                if (this.agentEntry != null) {
                    ServiceFrame.this.updateGUI(this.agentEntry);
                }
            }
        };
        swingWorkerTarget.setForceFinishedCall(true);
        this.suspendAndRun(swingWorkerTarget);
    }

    private HSAction makeShowLogAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = ServiceFrame.this.agentList.getSelectedValues();
                if (objectArray.length == 0) {
                    throw new IllegalStateException("An agent configuration entry must be selected to display the agent log.");
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    AgentServiceEntry agentServiceEntry = (AgentServiceEntry)objectArray[i];
                    ServiceFrame.this.control.displayLog(agentServiceEntry, ServiceFrame.this);
                }
            }
        };
        hSAction.setName("Display Agent Log");
        hSAction.setMnemonicKey(76);
        hSAction.setLongDescription("Display the agent Log.");
        return hSAction;
    }

    private HSAction makeShowConsoleOutputAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AgentServiceEntry agentServiceEntry = null;
                try {
                    Object[] objectArray = ServiceFrame.this.agentList.getSelectedValues();
                    if (objectArray.length == 0) {
                        throw new IllegalStateException("An agent configuration entry must be selected.");
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        agentServiceEntry = (AgentServiceEntry)objectArray[i];
                        ServiceFrame.this.showAgentLog(agentServiceEntry);
                    }
                }
                catch (Throwable throwable) {
                    ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                    return;
                }
            }
        };
        hSAction.setName("Show Console Output");
        hSAction.setMnemonicKey(78);
        hSAction.setLongDescription("Open the Console Output for the selected agent.");
        return hSAction;
    }

    private HSAction makeShowDiagnosticPageAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AgentServiceEntry agentServiceEntry = null;
                try {
                    Object[] objectArray = ServiceFrame.this.agentList.getSelectedValues();
                    if (objectArray.length == 0) {
                        throw new IllegalStateException("An agent configuration entry must be selected.");
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        agentServiceEntry = (AgentServiceEntry)objectArray[i];
                        int n = agentServiceEntry.loadPeerConfig().getListenPort();
                        String string = "https://localhost:" + n + "/cp/HS_diagnostics.html";
                        try {
                            String[] stringArray = new String[]{"cmd.exe", "/c", "start", string};
                            URI uRI = new URI(string);
                            Desktop desktop = null;
                            if (Desktop.isDesktopSupported()) {
                                desktop = Desktop.getDesktop();
                            }
                            if (desktop == null) {
                                throw new IllegalStateException("The default browser is not supported.");
                            }
                            desktop.browse(uRI);
                            continue;
                        }
                        catch (Exception exception) {
                            ThrowableDialog.showThrowable(null, (String)("Unable to start a web browser.\nStart a web browser and point it at the address " + string), (String)"Unable to display diagnostic info", (Throwable)exception);
                        }
                    }
                }
                catch (Throwable throwable) {
                    ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                    return;
                }
            }
        };
        hSAction.setName("Show Diagnostic Page");
        hSAction.setMnemonicKey(87);
        hSAction.setLongDescription("Show the Diagnostic Page for the selected agent.");
        return hSAction;
    }

    private HSAction makeShowServerDiagnosticPageAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){

                    public void construct() {
                        StringBuilder stringBuilder = new StringBuilder();
                        try {
                            if (ServiceFrame.this.agentServiceAM == null) {
                                throw new IllegalStateException("The agent server is not connected.");
                            }
                            int n = ServiceFrame.this.agentServiceAM.getLocalListeningPort();
                            if (n == -1) {
                                throw new IllegalStateException("The agent server port is unavailable.");
                            }
                            stringBuilder.append("https://localhost:");
                            stringBuilder.append(n);
                            stringBuilder.append("/cp/HS_diagnostics.html");
                            String[] stringArray = new String[]{"cmd.exe", "/c", "start", stringBuilder.toString()};
                            URI uRI = new URI("https://localhost:" + n + "/cp/HS_diagnostics.html");
                            Desktop desktop = null;
                            if (Desktop.isDesktopSupported()) {
                                desktop = Desktop.getDesktop();
                            }
                            if (desktop == null) {
                                throw new IllegalStateException("The default browser is not supported.");
                            }
                            desktop.browse(uRI);
                        }
                        catch (Exception exception) {
                            ThrowableDialog.showThrowable(null, (String)("Unable to start a web browser.\nStart a web browser and point it at the address " + stringBuilder.toString()), (String)"Unable to display diagnostic info", (Throwable)exception);
                        }
                    }
                };
                ServiceFrame.this.suspendAndRun(swingWorkerTarget);
            }
        };
        hSAction.setName("Show Service Diagnostic Page");
        hSAction.setMnemonicKey(87);
        hSAction.setLongDescription("Show the Agent Server Diagnostic page.");
        return hSAction;
    }

    private HSAction makeDeleteAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object[] objectArray = ServiceFrame.this.agentList.getSelectedValues();
                    if (objectArray.length == 0) {
                        throw new IllegalStateException("An agent configuration entry must be selected for the remove action.");
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        final AgentServiceEntry agentServiceEntry = (AgentServiceEntry)objectArray[i];
                        final int n = ServiceFrame.this.agentList.getSelectedIndex();
                        String string = "Remove";
                        String string2 = "Are you sure you want to remove '" + agentServiceEntry.getLabel() + "'?" + "\n\nNote: The associated xml configuration file will not be deleted.";
                        int n2 = JOptionPane.showConfirmDialog((Component)((Object)ServiceFrame.this), string2, string, 0);
                        if (n2 != 0) continue;
                        SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){

                            public void construct() {
                                ServiceFrame.this.agentListModel.removeEntry(agentServiceEntry);
                                ServiceFrame.this.removeFromLogBox(agentServiceEntry);
                            }

                            public void finished() {
                                ServiceFrame.this.reselect(n);
                                ServiceFrame.this.agentList.invalidate();
                                ServiceFrame.this.repaint();
                            }
                        };
                        swingWorkerTarget.setForceFinishedCall(true);
                        ServiceFrame.this.suspendAndRun(swingWorkerTarget);
                    }
                }
                catch (Throwable throwable) {
                    ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                    return;
                }
            }
        };
        hSAction.setName("Remove");
        hSAction.setMnemonicKey(82);
        hSAction.setLongDescription("Remove the selected agent.");
        return hSAction;
    }

    private void reselect(int n) {
        int n2 = n;
        if (n > 0 && n >= this.agentListModel.getSize()) {
            --n2;
        }
        final int n3 = n2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServiceFrame.this.agentList.setSelectedIndex(n3);
            }
        });
    }

    private HSAction makeCopyAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object[] objectArray = ServiceFrame.this.agentList.getSelectedValues();
                    if (objectArray.length == 0) {
                        throw new IllegalStateException("An agent configuration entry must be selected for the copy action.");
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        final AgentServiceEntry agentServiceEntry = (AgentServiceEntry)objectArray[i];
                        SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){
                            AgentServiceEntry newAgentEntry = null;
                            boolean wasSaved = true;

                            public void construct() {
                                try {
                                    this.newAgentEntry = ServerEntryConfigDialog.copyServiceEntry(ServiceFrame.this, agentServiceEntry, ServiceFrame.this.agentServiceAM);
                                    if (this.newAgentEntry != null) {
                                        ServiceFrame.this.agentListModel.addEntry(this.newAgentEntry);
                                    }
                                }
                                catch (Throwable throwable) {
                                    ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                                    return;
                                }
                            }

                            public void finished() {
                                if (!this.wasSaved) {
                                    return;
                                }
                                if (this.newAgentEntry != null) {
                                    ServiceFrame.this.agentList.invalidate();
                                    ServiceFrame.this.addToLogBox(this.newAgentEntry);
                                    ServiceFrame.this.repaint();
                                }
                            }
                        };
                        swingWorkerTarget.setForceFinishedCall(true);
                        ServiceFrame.this.suspendAndRun(swingWorkerTarget);
                    }
                }
                catch (Throwable throwable) {
                    ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                    return;
                }
            }
        };
        hSAction.setName("Copy");
        hSAction.setMnemonicKey(67);
        hSAction.setLongDescription("Copy the selected agent.");
        return hSAction;
    }

    private HSAction makeStartAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AgentServiceEntry agentServiceEntry = null;
                try {
                    Object[] objectArray = ServiceFrame.this.agentList.getSelectedValues();
                    if (objectArray.length == 0) {
                        throw new IllegalStateException("An agent configuration entry must be selected for the start action.");
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        final AgentServiceEntry agentServiceEntry2 = agentServiceEntry = (AgentServiceEntry)objectArray[i];
                        SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){

                            public void construct() {
                                AgentProcessInfo agentProcessInfo = ServiceFrame.this.control.getProcess(agentServiceEntry2);
                                if (agentProcessInfo != null && agentProcessInfo.isAlive()) {
                                    throw new RuntimeException(agentServiceEntry2.getLabel() + " is already active.");
                                }
                                ServiceFrame.this.agentServiceAM.startAgent(agentServiceEntry2);
                            }
                        };
                        swingWorkerTarget.setForceFinishedCall(true);
                        ServiceFrame.this.suspendAndRun(swingWorkerTarget);
                    }
                }
                catch (Throwable throwable) {
                    ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                    return;
                }
            }
        };
        hSAction.setName("Start");
        hSAction.setMnemonicKey(83);
        hSAction.setLongDescription("Start the selected agent...");
        return hSAction;
    }

    private HSAction makeStopAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AgentServiceEntry agentServiceEntry = null;
                try {
                    Object[] objectArray = ServiceFrame.this.agentList.getSelectedValues();
                    if (objectArray.length == 0) {
                        throw new IllegalStateException("An agent configuration entry must be selected for the stop action.");
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        final AgentServiceEntry agentServiceEntry2 = agentServiceEntry = (AgentServiceEntry)objectArray[i];
                        SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){

                            public void construct() {
                                AgentProcessInfo agentProcessInfo = ServiceFrame.this.control.getProcess(agentServiceEntry2);
                                if (agentProcessInfo == null || !agentProcessInfo.isAlive()) {
                                    throw new RuntimeException(agentServiceEntry2.getLabel() + " is not active.");
                                }
                                ServiceFrame.this.control.stopAction((Component)((Object)ServiceFrame.this), agentServiceEntry2);
                            }
                        };
                        swingWorkerTarget.setForceFinishedCall(true);
                        ServiceFrame.this.suspendAndRun(swingWorkerTarget);
                    }
                }
                catch (Throwable throwable) {
                    ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                    return;
                }
            }
        };
        hSAction.setName("Stop");
        hSAction.setMnemonicKey(79);
        hSAction.setLongDescription("Stop the selected agent...");
        return hSAction;
    }

    private HSAction makeRestartAction() {
        HSAction hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object[] objectArray = ServiceFrame.this.agentList.getSelectedValues();
                    if (objectArray.length == 0) {
                        throw new IllegalStateException("An agent configuration entry must be selected for the restart action.");
                    }
                    for (int i = 0; i < objectArray.length && ServiceFrame.this.agentServiceAM != null; ++i) {
                        final AgentServiceEntry agentServiceEntry = (AgentServiceEntry)objectArray[i];
                        SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){

                            public void construct() {
                                AgentProcessInfo agentProcessInfo = ServiceFrame.this.control.getProcess(agentServiceEntry);
                                if (agentProcessInfo == null || !agentProcessInfo.isAlive()) {
                                    throw new RuntimeException(agentServiceEntry.getLabel() + " is not active.");
                                }
                                ServiceFrame.this.control.restartAction((Component)((Object)ServiceFrame.this), agentServiceEntry);
                            }
                        };
                        ServiceFrame.this.suspendAndRun(swingWorkerTarget);
                    }
                }
                catch (Throwable throwable) {
                    ThrowableDialog.showThrowable((Component)((Object)ServiceFrame.this), (String)throwable.getLocalizedMessage(), (Throwable)throwable);
                    return;
                }
            }
        };
        hSAction.setName("Restart");
        hSAction.setMnemonicKey(84);
        hSAction.setLongDescription("Stop and Restart the selected agent...");
        return hSAction;
    }

    public void showAgentLog(AgentServiceEntry agentServiceEntry) {
        if (agentServiceEntry == null) {
            return;
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.tabs.setSelectedComponent(this.tab_log);
        this.logBox.setSelectedItem(this.consoleOutputMap.get(agentServiceEntry.getLabel()));
    }

    public static IApplicationConfigManager getConfigurationManager() {
        return CommonMRHelper.getApplicationConfigManager((String)CONFIG_PRODUCT_NAME);
    }

    private void setupMinimumSizeListener() {
        if (this.minSizeListener == null) {
            this.minSizeListener = new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = ServiceFrame.this.getWidth();
                    int n2 = ServiceFrame.this.getHeight();
                    boolean bl = false;
                    if (n < MINIMUM_FRAME_SIZE.width) {
                        bl = true;
                        n = MINIMUM_FRAME_SIZE.width;
                    }
                    if (n2 < MINIMUM_FRAME_SIZE.height) {
                        bl = true;
                        n2 = MINIMUM_FRAME_SIZE.height;
                    }
                    if (bl) {
                        ServiceFrame.this.setSize(n, n2);
                    }
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                }

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                }
            };
            this.addComponentListener(this.minSizeListener);
        } else {
            logger.warn((Object)"Minimum size lister was already set.");
        }
    }

    public void showTab(int n) {
        if (n >= 0 && n < 2) {
            this.tabs.setSelectedIndex(n);
        }
        this.updateButtonState();
    }

    private void updateButtonState() {
        this.updateAgentStateInfo(null);
    }

    private void checkServiceConnection() {
        if (this.agentServiceAM == null) {
            throw new IllegalStateException("Not connected to the Agent Server.");
        }
    }

    public HSAction setupCopyAction(final JTextArea jTextArea) {
        HSAction hSAction = null;
        hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.copy();
            }
        };
        hSAction.setName("Copy to Clipboard");
        hSAction.setMnemonicKey(67);
        return hSAction;
    }

    public HSAction setupSelectAllAction(final JTextArea jTextArea) {
        HSAction hSAction = null;
        hSAction = new HSAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.selectAll();
                jTextArea.requestFocus();
            }
        };
        hSAction.setName("Select All");
        hSAction.setMnemonicKey(65);
        return hSAction;
    }

    public HSAction setupSaveAction(final JTextArea jTextArea) {
        HSAction hSAction = new HSAction(){
            String lastPath = "";
            File outputFile = null;
            Window parent = null;
            HSWindow hsParent = null;
            FileWriter outputFileWriter = null;

            public void actionPerformed(ActionEvent actionEvent) {
                this.parent = SwingUtilities.getWindowAncestor(jTextArea);
                this.hsParent = (HSWindow)this.parent;
                this.outputFile = this.getFile(jTextArea);
                if (this.outputFile == null) {
                    return;
                }
                this.hsParent.suspendAndRun((SwingWorkerTarget)new SaveWorker());
            }

            private File getFile(JTextArea jTextArea2) {
                String string;
                Window window = SwingUtilities.getWindowAncestor(jTextArea2);
                File file = null;
                if (window == null) {
                    return null;
                }
                JFileChooser jFileChooser = this.getFileChooser();
                do {
                    if (jFileChooser.showSaveDialog(window) != 0) {
                        return null;
                    }
                    file = jFileChooser.getSelectedFile();
                    if (file == null) {
                        return null;
                    }
                    string = jFileChooser.getSelectedFile().getAbsolutePath();
                    if (file.getName().lastIndexOf(46) == -1) {
                        string = string + ".txt";
                        file = new File(string);
                    }
                    this.saveLastPath(string);
                } while ((file = this.checkFile(file, window, string)) == null);
                return file;
            }

            private File checkFile(File file, Window window, String string) {
                if (file.exists()) {
                    if (!this.canReplace(window)) {
                        return null;
                    }
                } else {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException iOException) {
                        this.showSaveError(window, "Could not create the file." + string + "\n" + iOException.getMessage());
                        return null;
                    }
                }
                if (!file.canWrite()) {
                    this.showSaveError(window, "The file is read only.");
                    return null;
                }
                return file;
            }

            private JFileChooser getFileChooser() {
                JFileChooser jFileChooser = new JFileChooser(this.getLastPath());
                jFileChooser.setMultiSelectionEnabled(false);
                FileFilter fileFilter = CommonFileFilter.createTextFileFilter();
                jFileChooser.setFileFilter(fileFilter);
                jFileChooser.setDialogTitle("Save selected output to file");
                return jFileChooser;
            }

            private void showSaveError(final Window window, final String string) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(window, string, "Error", 0);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private boolean canReplace(Window window) {
                return JOptionPane.showConfirmDialog(window, "The File exists.  Overwrite file?", "Save Selected", 0, 2) == 0;
            }

            private String getLastPath() {
                IApplicationConfigManager iApplicationConfigManager = CommonMRHelper.getApplicationConfigManager((String)ServiceFrame.CONFIG_PRODUCT_NAME);
                if (iApplicationConfigManager != null) {
                    this.lastPath = iApplicationConfigManager.getProperty("TableUtilities_LAST_PATH");
                }
                return this.lastPath;
            }

            private void saveLastPath(String string) {
                IApplicationConfigManager iApplicationConfigManager = CommonMRHelper.getApplicationConfigManager((String)ServiceFrame.CONFIG_PRODUCT_NAME);
                if (iApplicationConfigManager != null) {
                    if (string == null) {
                        iApplicationConfigManager.setProperty("TableUtilities_LAST_PATH", "");
                    } else {
                        iApplicationConfigManager.setProperty("TableUtilities_LAST_PATH", string);
                    }
                }
            }

            class SaveWorker
            extends SwingWorkerTarget {
                public void construct() {
                    String string = jTextArea.getSelectedText();
                    boolean bl = this.writeToFile(string);
                    try {
                        outputFileWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!bl) {
                        outputFile.delete();
                    }
                }

                public boolean writeToFile(String string) {
                    try {
                        if (outputFileWriter == null) {
                            outputFileWriter = new FileWriter(outputFile);
                        }
                        if (outputFileWriter != null) {
                            outputFileWriter.write(string);
                            outputFileWriter.flush();
                        }
                    }
                    catch (IOException iOException) {
                        if (parent != null) {
                            this.showSaveError(parent, "Failed to save to file.\n" + iOException.getMessage());
                        }
                        return false;
                    }
                    return true;
                }

                public void finished() {
                    try {
                        if (outputFileWriter != null) {
                            outputFileWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        outputFileWriter = null;
                    }
                }
            }
        };
        hSAction.setName("Save Selected...");
        hSAction.setMnemonicKey(83);
        return hSAction;
    }

    static {
        logger = Logger.getLogger(ServiceFrame.class);
        STANDARD_INSETS = new Insets(6, 6, 6, 6);
        PANEL_INSETS = new Insets(0, 0, 0, 0);
        MINIMUM_FRAME_SIZE = new Dimension(600, 400);
    }

    class SortedPCOComboBoxModel
    extends DefaultComboBoxModel {
        SortedPCOComboBoxModel() {
        }

        @Override
        public void addElement(Object object) {
            this.insertElementAt(object, 0);
        }

        @Override
        public void insertElementAt(Object object, int n) {
            if (object instanceof ProcessConsoleOutput) {
                ProcessConsoleOutput processConsoleOutput;
                ProcessConsoleOutput processConsoleOutput2 = (ProcessConsoleOutput)object;
                int n2 = this.getSize();
                int n3 = 0;
                for (n3 = 0; n3 < n2 && ProcessConsoleOutput.NAME_COMPARATOR.compare(processConsoleOutput = (ProcessConsoleOutput)this.getElementAt(n3), processConsoleOutput2) <= 0; ++n3) {
                }
                super.insertElementAt(object, n3);
            }
        }
    }

    private class JarAttributes {
        String specificationVersion = "";
        String jarModuleName = "";
        String moduleVersion = "";
        String buildDate = "";
        String buildTime = "";
        String initClass = "";

        private JarAttributes() {
        }

        public String getBuildTimeStamp() {
            String string = null;
            String string2 = null;
            string = this.buildDate == null || this.buildDate.trim().length() == 0 ? "{unknown build date}" : this.buildDate;
            string2 = this.buildTime == null || this.buildTime.trim().length() == 0 ? "{unknown build time}" : this.buildTime;
            return string + "-" + string2;
        }

        public String getRelMod() {
            if (this.specificationVersion == null) {
                return "";
            }
            return this.specificationVersion;
        }
    }

    class EntryListModel
    extends AbstractListModel {
        EntryListModel() {
        }

        public void refresh() {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void addEntry(AgentServiceEntry agentServiceEntry) {
            ServiceFrame.this.checkServiceConnection();
            int n = this.getSize();
            ServiceFrame.this.agentServiceAM.addEntry(agentServiceEntry);
            this.fireIntervalAdded(agentServiceEntry, n, this.getSize());
            ServiceFrame.this.updateGUI(agentServiceEntry);
        }

        public void removeEntry(AgentServiceEntry agentServiceEntry) {
            ServiceFrame.this.checkServiceConnection();
            AgentProcessInfo agentProcessInfo = ServiceFrame.this.control.getProcess(agentServiceEntry);
            if (agentProcessInfo != null && agentProcessInfo.isAlive()) {
                ServiceFrame.this.agentServiceAM.shutdownAgent(agentProcessInfo.getEntry(), false, true);
            }
            int n = -1;
            AgentServiceEntry[] agentServiceEntryArray = ServiceFrame.this.control.getEntries();
            for (int i = 0; i < agentServiceEntryArray.length; ++i) {
                if (!agentServiceEntryArray[i].equals(agentServiceEntry)) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                ServiceFrame.this.checkServiceConnection();
                ServiceFrame.this.agentServiceAM.removeEntry(agentServiceEntry);
                this.fireIntervalRemoved(agentServiceEntry, n, n);
                ServiceFrame.this.updateGUI(agentServiceEntry);
            }
        }

        @Override
        public int getSize() {
            int n = ServiceFrame.this.control.getEntries().length;
            if (n == 0) {
                return 1;
            }
            return n;
        }

        @Override
        public AgentServiceEntry getElementAt(int n) {
            if (ServiceFrame.this.control.getEntries().length == 0 && n == 0) {
                return null;
            }
            ServiceFrame.this.checkServiceConnection();
            AgentServiceEntry agentServiceEntry = ServiceFrame.this.control.getEntries()[n];
            return agentServiceEntry;
        }
    }
}

