/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.tray;

import com.helpsystems.common.client.components.DataLabel;
import com.helpsystems.common.client.components.FinderButton;
import com.helpsystems.common.client.components.RestrictedInputTextField;
import com.helpsystems.common.client.images.HSImages;
import com.helpsystems.common.client.util.SwingWorkerTarget;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import com.helpsystems.enterprise.tray.AgentFileFinder;
import com.helpsystems.enterprise.tray.ServerEntryConfigDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ServerEntryConfigPanel {
    private JPanel main = new JPanel();
    private ServerEntryConfigDialog parentWindow = null;
    private JPanel pnlAlias = null;
    private DataLabel lblAlias = null;
    private DataLabel lblAliasDemo = null;
    private RestrictedInputTextField fldAlias = null;
    private DataLabel lblAgentConfigPath = null;
    private RestrictedInputTextField fldAgentConfigPath = null;
    private FinderButton btnAgentConfigPathFinder = new FinderButton();
    private JButton btnFileHelp = null;
    private DataLabel lblAutoStart = null;
    private JPanel pnlAutoStart = null;
    private JRadioButton btnNo = null;
    private JRadioButton btnYes = null;
    private ButtonGroup btnGrp = new ButtonGroup();
    private String SYSTEM_NAME = "";

    public ServerEntryConfigPanel(ServerEntryConfigDialog serverEntryConfigDialog) {
        this.parentWindow = serverEntryConfigDialog;
        this.initialize();
        this.setupListeners();
    }

    private void setupListeners() {
        this.btnAgentConfigPathFinder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){
                    String selectedFilePath = null;
                    AgentFileFinder aff;
                    {
                        this.aff = new AgentFileFinder((Window)((Object)ServerEntryConfigPanel.this.parentWindow));
                    }

                    public void construct() {
                        this.selectedFilePath = this.aff.showFileFinder(ServerEntryConfigPanel.this.fldAgentConfigPath.getName(), false);
                    }

                    public void finished() {
                        if (this.selectedFilePath != null) {
                            File file = new File(this.selectedFilePath);
                            String string = file.getName();
                            ServerEntryConfigPanel.this.fldAgentConfigPath.setText(string);
                            if (ServerEntryConfigPanel.this.fldAlias.getText().trim().length() < 1) {
                                ServerEntryConfigPanel.this.fldAlias.setText(AgentFileFinder.getFileName(this.selectedFilePath));
                            }
                            ServerEntryConfigPanel.this.parentWindow.loadNewPath(this.selectedFilePath);
                        }
                    }
                };
                swingWorkerTarget.setForceFinishedCall(true);
                ServerEntryConfigPanel.this.parentWindow.suspendAndRun(swingWorkerTarget);
            }
        });
        this.btnFileHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){

                    public void construct() {
                        String string = "The agent configuration files are stored in:\n" + DefaultConfigPath.getDisplayPath();
                        JOptionPane.showMessageDialog((Component)((Object)ServerEntryConfigPanel.this.parentWindow), string);
                    }

                    public void finished() {
                    }
                };
                swingWorkerTarget.setForceFinishedCall(true);
                ServerEntryConfigPanel.this.parentWindow.suspendAndRun(swingWorkerTarget);
            }
        });
    }

    public Component getMainPanel() {
        return this.main;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints4.gridy = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 3;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints5.gridwidth = 4;
        gridBagConstraints5.gridx = 0;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 3;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.weightx = 0.0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints6.gridwidth = 1;
        gridBagConstraints6.gridx = 2;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints7.gridy = 0;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints8.gridy = 0;
        this.lblAlias = new DataLabel();
        this.lblAliasDemo = new DataLabel();
        this.lblAgentConfigPath = new DataLabel();
        this.lblAlias.setText("Alias:");
        this.lblAgentConfigPath.setText("Agent Configuration File:");
        this.main.setLayout(new GridBagLayout());
        this.main.setSize(new Dimension(444, 184));
        this.main.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Server Entry Configuration"));
        this.main.add((Component)this.getPnlAlias(), gridBagConstraints5);
        this.main.add((Component)this.lblAgentConfigPath, gridBagConstraints4);
        this.main.add((Component)this.getFldAgentConfigPath(), gridBagConstraints3);
        this.main.add((Component)this.getFileHelpButton(), gridBagConstraints2);
        this.main.add((Component)this.getPnlAutoStart(), gridBagConstraints);
        this.btnAgentConfigPathFinder.setVisible(false);
        this.getSystemName();
    }

    private void getSystemName() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            this.SYSTEM_NAME = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.SYSTEM_NAME = null;
        }
    }

    private RestrictedInputTextField getFldAlias() {
        int n;
        int n2 = 12;
        if (this.SYSTEM_NAME != null && (n = 50 - (this.SYSTEM_NAME.length() + 1)) > 12) {
            n2 = n;
        }
        if (this.fldAlias == null) {
            this.fldAlias = new RestrictedInputTextField(n2, true, RestrictedInputTextField.FORCE_NEITHER);
            this.fldAlias.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    String string = ServerEntryConfigPanel.this.fldAlias.getText();
                    ServerEntryConfigPanel.this.setAliasDemo();
                    if (ServerEntryConfigPanel.this.fldAgentConfigPath.getText().trim().length() < 1 && string.trim().length() > 0) {
                        ServerEntryConfigPanel.this.fldAgentConfigPath.setText(string + ".xml");
                    }
                }
            });
        }
        return this.fldAlias;
    }

    private void setAliasDemo() {
        String string = this.fldAlias.getText();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.SYSTEM_NAME);
        stringBuffer.append("_");
        stringBuffer.append(string);
        int n = stringBuffer.toString().trim().length();
        if (n >= 50) {
            n = 50;
        }
        String string2 = stringBuffer.substring(0, n);
        this.lblAliasDemo.setText(string2.toUpperCase());
    }

    private RestrictedInputTextField getFldAgentConfigPath() {
        if (this.fldAgentConfigPath == null) {
            this.fldAgentConfigPath = new RestrictedInputTextField(255, false, RestrictedInputTextField.FORCE_NEITHER);
        }
        return this.fldAgentConfigPath;
    }

    private JPanel getPnlAlias() {
        if (this.pnlAlias == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints4.gridy = 0;
            this.pnlAlias = new JPanel();
            this.pnlAlias.setLayout(new GridBagLayout());
            this.pnlAlias.add((Component)this.lblAlias, gridBagConstraints4);
            this.pnlAlias.add((Component)this.getFldAlias(), gridBagConstraints3);
            this.pnlAlias.add((Component)new DataLabel("Agent Name:"), gridBagConstraints2);
            this.pnlAlias.add((Component)this.lblAliasDemo, gridBagConstraints);
        }
        return this.pnlAlias;
    }

    private JPanel getPnlAutoStart() {
        if (this.pnlAutoStart == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            this.lblAutoStart = new DataLabel();
            this.lblAutoStart.setText("Start the agent when the service starts?");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints3.gridy = 0;
            this.pnlAutoStart = new JPanel();
            this.pnlAutoStart.setLayout(new GridBagLayout());
            this.pnlAutoStart.add((Component)this.lblAutoStart, gridBagConstraints3);
            this.pnlAutoStart.add((Component)this.getBtnYes(), gridBagConstraints2);
            this.pnlAutoStart.add((Component)this.getBtnNo(), gridBagConstraints);
            this.btnGrp.add(this.btnYes);
            this.btnGrp.add(this.btnNo);
        }
        return this.pnlAutoStart;
    }

    private JRadioButton getBtnNo() {
        if (this.btnNo == null) {
            this.btnNo = new JRadioButton();
            this.btnNo.setText("No, I'll manually start it when needed.");
        }
        return this.btnNo;
    }

    private JRadioButton getBtnYes() {
        if (this.btnYes == null) {
            this.btnYes = new JRadioButton();
            this.btnYes.setText("Yes, start when the Service starts.");
        }
        return this.btnYes;
    }

    private JButton getFileHelpButton() {
        if (this.btnFileHelp == null) {
            ImageIcon imageIcon = HSImages.getImage((String)"com/helpsystems/common/client/images/help_16.png");
            int n = 20;
            this.btnFileHelp = new JButton(imageIcon);
            this.btnFileHelp.setMaximumSize(new Dimension(n, n));
            this.btnFileHelp.setMinimumSize(new Dimension(n, n));
            this.btnFileHelp.setPreferredSize(new Dimension(n, n));
        }
        return this.btnFileHelp;
    }

    public void loadConfig(AgentServiceEntry agentServiceEntry) {
        this.fldAlias.setText(agentServiceEntry.getLabel());
        this.setAliasDemo();
        this.fldAgentConfigPath.setText(agentServiceEntry.getFilename());
        this.btnYes.setSelected(agentServiceEntry.getAutostart());
        this.btnNo.setSelected(!agentServiceEntry.getAutostart());
    }

    public AgentServiceEntry getConfig() {
        AgentServiceEntry agentServiceEntry = new AgentServiceEntry();
        try {
            agentServiceEntry.setLabel(this.fldAlias.getText());
            String string = this.fldAgentConfigPath.getText();
            if (string.indexOf("\\") > -1 || string.indexOf("/") > -1) {
                throw new IllegalArgumentException("The File Name cannot contain path separator characters (/ or \\).");
            }
            agentServiceEntry.setFilename(this.fldAgentConfigPath.getText());
            agentServiceEntry.setAutostart(this.btnYes.isSelected());
            return agentServiceEntry;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
    }

    public void setFileNameEnabled(boolean bl) {
        this.fldAgentConfigPath.setEnabled(bl);
    }

    public String getNewFileName() {
        return this.fldAgentConfigPath.getText();
    }
}

