/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.tray;

import com.helpsystems.common.client.components.FinderButton;
import com.helpsystems.common.client.components.HSJDialog;
import com.helpsystems.common.client.components.HelpMapID;
import com.helpsystems.common.client.components.RestrictedInputTextField;
import com.helpsystems.common.client.components.throwabledialog.ThrowableDialog;
import com.helpsystems.common.client.images.HSImages;
import com.helpsystems.common.client.util.SwingWorkerTarget;
import com.helpsystems.enterprise.RBEHelpManager;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import com.helpsystems.enterprise.service.AgentServiceAM;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import com.helpsystems.enterprise.tray.AgentFileFinder;
import com.helpsystems.enterprise.tray.ServerEntryConfigDialog;
import com.helpsystems.enterprise.tray.ServiceFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class AddAgentDialog
extends HSJDialog {
    private AgentServiceEntry agentServiceEntry = null;
    private JPanel mainPanel = null;
    private JLabel jLabel = null;
    private JRadioButton rbAddNew = null;
    private JRadioButton rbAddExisting = null;
    private ButtonGroup btnGroup = new ButtonGroup();
    private JLabel lblAgentFile = null;
    private RestrictedInputTextField fldFileName = null;
    private FinderButton btnFileFinder = null;
    private JButton btnFileHelp = null;
    private JPanel pnlButton = null;
    private JButton btnOK = new JButton("OK");
    private JButton bntCancel = new JButton("Cancel");
    private ActionListener buttonListener = null;
    private ServiceFrame parent = null;
    private AgentServiceAM agentServiceAM = null;

    public AddAgentDialog() {
        this.initialize();
    }

    public AddAgentDialog(ServiceFrame serviceFrame, AgentServiceAM agentServiceAM) {
        super((Frame)((Object)serviceFrame));
        this.parent = serviceFrame;
        this.agentServiceAM = agentServiceAM;
        this.initialize();
    }

    private void initialize() {
        this.setDefaultHelp((HelpMapID)RBEHelpManager.SKYSCH_ADD_AGENT);
        this.buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddAgentDialog.this.updateSelected();
            }
        };
        this.setSize(new Dimension(322, 187));
        this.setTitle("Add Agent");
        this.setContentPane(this.getMainPanel());
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AddAgentDialog.this.addAction();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ThrowableDialog.showThrowable((Component)((Object)AddAgentDialog.this.parent), (String)"The filename was not found.", (Throwable)fileNotFoundException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ThrowableDialog.showThrowable((Component)((Object)AddAgentDialog.this.parent), (String)"A valid XML file is required for adding a new Agent.", (Throwable)illegalArgumentException);
                }
                catch (ClassCastException classCastException) {
                    ThrowableDialog.showThrowable((Component)((Object)AddAgentDialog.this.parent), (String)"The selected file is not an Agent configuration file.", (Throwable)classCastException);
                }
                catch (Exception exception) {
                    ThrowableDialog.showThrowable((Component)((Object)AddAgentDialog.this.parent), (String)"A valid XML file is required for adding a new Agent.", (Throwable)exception);
                }
            }
        });
        this.bntCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddAgentDialog.this.agentServiceEntry = null;
                AddAgentDialog.this.cancelButtonAction();
            }
        });
        this.setCancelButton(this.bntCancel);
        this.setDefaultButton(this.btnOK);
        this.updateSelected();
    }

    private void addAction() throws FileNotFoundException {
        if (this.rbAddNew.isSelected()) {
            ServerEntryConfigDialog serverEntryConfigDialog = new ServerEntryConfigDialog(this, 0);
            serverEntryConfigDialog.setValidator(this.agentServiceAM);
            serverEntryConfigDialog.load(null);
            serverEntryConfigDialog.setVisible(true);
            this.agentServiceEntry = serverEntryConfigDialog.getAgentServiceEntry();
        } else {
            final String string = this.fldFileName.getText();
            if (string != null && string.trim().length() > 0) {
                SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){
                    Throwable th = null;
                    AgentServiceEntry ase = new AgentServiceEntry();
                    ServerEntryConfigDialog secd = null;

                    public void construct() {
                        if (string.indexOf("\\") > -1 || string.indexOf("/") > -1) {
                            this.th = new IllegalArgumentException("The File Name cannot contain path separator characters (/ or \\).");
                            return;
                        }
                        String string2 = DefaultConfigPath.getDefaultPath() + File.separator + string;
                        File file = new File(string2);
                        if (!file.exists() || !file.isFile()) {
                            this.th = new IllegalArgumentException("File " + string + " does not exist in '" + DefaultConfigPath.getDefaultPath() + "'.");
                            return;
                        }
                        this.ase.setFilename(string);
                        this.ase.setLabel(AgentFileFinder.getFileName(string));
                        this.ase.setAutostart(true);
                        this.secd = new ServerEntryConfigDialog(AddAgentDialog.this, 0);
                        this.secd.setValidator(AddAgentDialog.this.agentServiceAM);
                        try {
                            this.secd.load(this.ase);
                            this.secd.pack();
                        }
                        catch (ClassCastException classCastException) {
                            this.th = classCastException;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.th = fileNotFoundException;
                        }
                    }

                    public void finished() {
                        if (this.th == null) {
                            this.secd.setVisible(true);
                            AddAgentDialog.this.agentServiceEntry = this.secd.getAgentServiceEntry();
                            if (AddAgentDialog.this.agentServiceEntry != null) {
                                AddAgentDialog.this.cancelButtonAction();
                            }
                        } else {
                            ThrowableDialog.showThrowable((Component)((Object)AddAgentDialog.this), (String)"Error", (String)this.th.getLocalizedMessage(), (Throwable)this.th);
                        }
                    }
                };
                swingWorkerTarget.setForceFinishedCall(true);
                this.suspendAndRun(swingWorkerTarget);
            } else {
                throw new IllegalArgumentException("A valid XML file is required for adding a new Agent.");
            }
        }
        if (this.agentServiceEntry != null) {
            this.cancelButtonAction();
        }
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 7;
            gridBagConstraints.anchor = 14;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 5;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 5;
            gridBagConstraints3.gridy = 4;
            gridBagConstraints3.insets = new Insets(0, 6, 6, 6);
            gridBagConstraints3.anchor = 17;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 6;
            gridBagConstraints4.gridy = 4;
            gridBagConstraints4.insets = new Insets(0, 6, 6, 6);
            gridBagConstraints4.anchor = 17;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 3;
            gridBagConstraints5.gridy = 4;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 6, 6, 6);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.gridy = 4;
            gridBagConstraints6.insets = new Insets(0, 26, 6, 6);
            gridBagConstraints6.anchor = 17;
            this.lblAgentFile = new JLabel();
            this.lblAgentFile.setText("File Name:");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridwidth = 6;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 2;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridwidth = 6;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 1;
            this.jLabel = new JLabel();
            this.jLabel.setText("");
            this.mainPanel = new JPanel();
            this.mainPanel.setPreferredSize(new Dimension(500, 165));
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.jLabel, gridBagConstraints9);
            this.mainPanel.add((Component)this.getRbAddNew(), gridBagConstraints8);
            this.mainPanel.add((Component)this.getRbAddExisting(), gridBagConstraints7);
            this.mainPanel.add((Component)this.lblAgentFile, gridBagConstraints6);
            this.mainPanel.add((Component)this.getFldFileName(), gridBagConstraints5);
            this.mainPanel.add((Component)this.getBtnFileFinder(), gridBagConstraints3);
            this.mainPanel.add((Component)this.getBtnFileHelp(), gridBagConstraints4);
            this.mainPanel.add((Component)this.getPnlButton(), gridBagConstraints);
        }
        return this.mainPanel;
    }

    private JRadioButton getRbAddNew() {
        if (this.rbAddNew == null) {
            this.rbAddNew = new JRadioButton();
            this.rbAddNew.setText("Create a new Agent");
            this.btnGroup.add(this.rbAddNew);
            this.rbAddNew.addActionListener(this.buttonListener);
            this.rbAddNew.setSelected(true);
        }
        return this.rbAddNew;
    }

    private JRadioButton getRbAddExisting() {
        if (this.rbAddExisting == null) {
            this.rbAddExisting = new JRadioButton();
            this.rbAddExisting.setText("Create an Agent from a configuration file");
            this.rbAddExisting.addActionListener(this.buttonListener);
            this.btnGroup.add(this.rbAddExisting);
        }
        return this.rbAddExisting;
    }

    private void updateSelected() {
        boolean bl = this.rbAddExisting.isSelected();
        this.fldFileName.setEnabled(bl);
        this.btnFileFinder.setEnabled(bl);
        this.lblAgentFile.setEnabled(bl);
        boolean bl2 = this.rbAddNew.isSelected();
        if (this.rbAddExisting.isSelected()) {
            bl2 = this.fldFileName.getText().trim().length() > 0;
        }
        this.btnOK.setEnabled(bl2);
    }

    private JTextField getFldFileName() {
        if (this.fldFileName == null) {
            this.fldFileName = new RestrictedInputTextField();
        }
        this.fldFileName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                AddAgentDialog.this.btnOK.setEnabled(AddAgentDialog.this.fldFileName.getText().trim().length() > 0);
            }
        });
        return this.fldFileName;
    }

    private JButton getBtnFileFinder() {
        if (this.btnFileFinder == null) {
            this.btnFileFinder = new FinderButton();
            this.btnFileFinder.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){
                        String selectedFilePath = null;
                        AgentFileFinder aff;
                        {
                            this.aff = new AgentFileFinder((Window)((Object)AddAgentDialog.this));
                        }

                        public void construct() {
                            String string = DefaultConfigPath.getDefaultPath() + File.separator + "agent.xml";
                            this.selectedFilePath = this.aff.showFileFinder(string, false);
                        }

                        public void finished() {
                            if (this.selectedFilePath != null) {
                                File file = new File(this.selectedFilePath);
                                AddAgentDialog.this.fldFileName.setText(file.getName());
                            }
                        }
                    };
                    swingWorkerTarget.setForceFinishedCall(true);
                    AddAgentDialog.this.suspendAndRun(swingWorkerTarget);
                }
            });
        }
        return this.btnFileFinder;
    }

    private JButton getBtnFileHelp() {
        if (this.btnFileHelp == null) {
            ImageIcon imageIcon = HSImages.getImage((String)"com/helpsystems/common/client/images/help_16.png");
            int n = 20;
            this.btnFileHelp = new JButton(imageIcon);
            this.btnFileHelp.setMaximumSize(new Dimension(n, n));
            this.btnFileHelp.setMinimumSize(new Dimension(n, n));
            this.btnFileHelp.setPreferredSize(new Dimension(n, n));
            this.btnFileHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingWorkerTarget swingWorkerTarget = new SwingWorkerTarget(){

                        public void construct() {
                            String string = "The agent configuration file must exist in:\n" + DefaultConfigPath.getDisplayPath();
                            JOptionPane.showMessageDialog((Component)((Object)AddAgentDialog.this), string);
                        }

                        public void finished() {
                        }
                    };
                    swingWorkerTarget.setForceFinishedCall(true);
                    AddAgentDialog.this.suspendAndRun(swingWorkerTarget);
                }
            });
        }
        return this.btnFileHelp;
    }

    private JPanel getPnlButton() {
        if (this.pnlButton == null) {
            JPanel jPanel = new JPanel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.anchor = 14;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.insets = new Insets(6, 6, 6, 6);
            gridBagConstraints3.anchor = 14;
            gridBagConstraints3.gridy = 0;
            this.pnlButton = new JPanel();
            this.pnlButton.setLayout(new GridBagLayout());
            this.pnlButton.add((Component)jPanel, gridBagConstraints);
            this.pnlButton.add((Component)this.btnOK, gridBagConstraints2);
            this.pnlButton.add((Component)this.bntCancel, gridBagConstraints3);
        }
        return this.pnlButton;
    }

    public AgentServiceEntry showAndGetServiceEntry() {
        this.showCentered();
        return this.agentServiceEntry;
    }

    public static AgentServiceEntry showAndGetServiceEntry(ServiceFrame serviceFrame, AgentServiceAM agentServiceAM) {
        AddAgentDialog addAgentDialog = new AddAgentDialog(serviceFrame, agentServiceAM);
        addAgentDialog.setVisible(true);
        return addAgentDialog.agentServiceEntry;
    }
}

