/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.tl.ConnectRequest;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.HeavyweightPeerConfig;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.SimpleConfig;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.ex.PeerConnectException;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.enterprise.service.AgentProcessEvent;
import com.helpsystems.enterprise.service.AgentProcessInfo;
import com.helpsystems.enterprise.service.AgentProcessListener;
import com.helpsystems.enterprise.service.AgentServiceAMImpl;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ServicePeer
extends HeavyweightPeer {
    private static final Logger logger = Logger.getLogger(ServicePeer.class);
    private AgentServiceAMImpl agentService;
    private boolean readyForConnections;

    ServicePeer(AgentServiceAMImpl agentServiceAMImpl, int n) throws PeerStartupException {
        super(ServicePeer.createPeerDescriptor(n), (Serializable)((Object)"AgentService"), (HeavyweightPeerConfig)ServicePeer.createConfig(n));
        this.startup();
        ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin((Peer)this));
        this.agentService = agentServiceAMImpl;
        agentServiceAMImpl.addListener(new AgentProcessListener(){

            @Override
            public void logGrew(AgentProcessInfo agentProcessInfo, String[] stringArray) {
                ServicePeer.this.addEvent(new AgentProcessEvent(agentProcessInfo, stringArray));
            }

            @Override
            public void processStarted(AgentProcessInfo agentProcessInfo) {
                ServicePeer.this.addEvent(new AgentProcessEvent(2, agentProcessInfo));
            }

            @Override
            public void processEnded(AgentProcessInfo agentProcessInfo) {
                ServicePeer.this.addEvent(new AgentProcessEvent(3, agentProcessInfo));
            }
        });
        this.readyForConnections = true;
    }

    private static PeerDescriptor createPeerDescriptor(int n) {
        return PeerDescriptor.createLocalPeerDescriptor((int)n, (int)7);
    }

    private static SimpleConfig createConfig(int n) {
        SimpleConfig simpleConfig = new SimpleConfig();
        simpleConfig.setListenPort(n);
        return simpleConfig;
    }

    protected void checkCredentials(ConnectRequest connectRequest) throws PeerConnectException {
        logger.debug((Object)("Connection request came in: " + connectRequest));
        if (!this.readyForConnections) {
            throw new PeerConnectException("The service is starting up, and is not yet capable of accepting connections.");
        }
    }

    protected String getHtmlSection(String string) {
        if ("log".equals(string)) {
            return ServicePeer.getLogTail((String)"agentService.log", (int)5000);
        }
        if ("general".equals(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.getHtmlSection(string));
            stringBuilder.append("<br>");
            stringBuilder.append("<h2>Agent Entries</h2>");
            AgentServiceEntry[] agentServiceEntryArray = this.agentService.getEntries();
            if (agentServiceEntryArray.length == 0) {
                stringBuilder.append("None defined.");
            } else {
                stringBuilder.append("<table border=\"0\" cellspacing=\"3\">");
                stringBuilder.append("<tr><td><b>State</b></td><td><b>Agent</b></td></tr>");
                for (AgentServiceEntry agentServiceEntry : agentServiceEntryArray) {
                    stringBuilder.append("<tr><td>");
                    AgentProcessInfo agentProcessInfo = this.agentService.getProcess(agentServiceEntry);
                    if (agentProcessInfo != null) {
                        if (agentProcessInfo.isAlive()) {
                            stringBuilder.append("Running");
                        } else if (agentProcessInfo.getProcessExitValue() == 0) {
                            stringBuilder.append("Stopped");
                        } else {
                            stringBuilder.append("Failed");
                        }
                    } else {
                        stringBuilder.append("Stopped");
                    }
                    stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    stringBuilder.append("</td><td>");
                    stringBuilder.append(this.makeLink(agentServiceEntry, agentProcessInfo));
                    stringBuilder.append("</td></tr>");
                }
                stringBuilder.append("</table>");
            }
            return stringBuilder.toString();
        }
        return super.getHtmlSection(string);
    }

    private String makeLink(AgentServiceEntry agentServiceEntry, AgentProcessInfo agentProcessInfo) {
        boolean bl = false;
        if (agentProcessInfo != null) {
            bl = agentProcessInfo.isAlive();
        }
        return agentServiceEntry.makeLink(agentServiceEntry.getLabel(), bl);
    }

    static {
        logger.setLevel(Level.TRACE);
    }
}

