/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import com.helpsystems.enterprise.service.FileExistsException;
import com.helpsystems.enterprise.service.TestXMLSerializableClass;
import java.io.File;
import java.io.FileNotFoundException;
import junit.framework.TestCase;
import org.w3c.dom.Document;

public class AgentServiceEntryTest
extends TestCase {
    static final String FILENAME = "C:\\temp\\mypeer.xml";
    AgentServiceEntry ase;
    AgentPeerConfig apc;

    protected void setUp() throws Exception {
        super.setUp();
        this.apc = AgentPeerConfig.getDefaultAgentPeer();
        this.ase = new AgentServiceEntry();
        this.ase.setFilename(FILENAME);
        this.ase.savePeerConfig(this.apc, true);
    }

    protected void tearDown() throws Exception {
        this.ase = null;
        this.apc = null;
        File file = new File(FILENAME);
        try {
            file.delete();
        }
        catch (Exception exception) {
            System.out.println("Unable to delete C:\\temp\\mypeer.xml");
        }
        super.tearDown();
    }

    public void testSetAutostart() {
        this.ase.setAutostart(true);
        AgentServiceEntryTest.assertTrue((boolean)this.ase.getAutostart());
        this.ase.setAutostart(false);
        AgentServiceEntryTest.assertFalse((boolean)this.ase.getAutostart());
    }

    public void testSetLabel() {
        this.ase.setLabel("someLabel");
        AgentServiceEntryTest.assertEquals((String)"someLabel", (String)this.ase.getLabel());
    }

    public void testSetFilename() {
        this.ase.setFilename("someFilename");
        AgentServiceEntryTest.assertEquals((String)"someFilename", (String)this.ase.getFilename());
    }

    public void testLoadPeerConfigNullFilenameThrowsNullPointerException() throws Exception {
        AgentServiceEntry agentServiceEntry = new AgentServiceEntry();
        try {
            agentServiceEntry.loadPeerConfig();
            AgentServiceEntryTest.fail((String)"loadPeerConfig(null) didn't throw an expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testLoadPeerConfigBogusFilenameThrowsFileNotFoundException() {
        AgentServiceEntry agentServiceEntry = new AgentServiceEntry();
        agentServiceEntry.setFilename("C:\\does\\not\\exist\\bogus.xml");
        try {
            agentServiceEntry.loadPeerConfig();
            AgentServiceEntryTest.fail((String)"loadPeerConfig(bogus) didn't throw an expected exception");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testLoadPeerConfigFilenameIsDirectoryThrowsRuntimeException() throws Exception {
        AgentServiceEntry agentServiceEntry = new AgentServiceEntry();
        agentServiceEntry.setFilename("C:\\temp");
        try {
            agentServiceEntry.loadPeerConfig();
            AgentServiceEntryTest.fail((String)"loadPeerConfig(directory) didn't throw an expected exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testEquals() {
        this.ase.setLabel("label");
        AgentServiceEntryTest.assertFalse((boolean)this.ase.equals(null));
        AgentServiceEntryTest.assertFalse((boolean)this.ase.equals(new Object()));
        AgentServiceEntryTest.assertTrue((boolean)this.ase.equals(this.ase));
        AgentServiceEntry agentServiceEntry = new AgentServiceEntry();
        agentServiceEntry.setLabel(this.ase.getLabel());
        AgentServiceEntryTest.assertEquals((Object)this.ase, (Object)agentServiceEntry);
        agentServiceEntry.setLabel("asldkfajsdlkfasjf");
        AgentServiceEntryTest.assertFalse((boolean)this.ase.equals(agentServiceEntry));
    }

    public void testDoNotInvoke() {
        String[] stringArray = this.ase.doNotInvoke();
        AgentServiceEntryTest.assertEquals((int)2, (int)stringArray.length);
    }

    public void testHashCode() {
        AgentServiceEntryTest.assertNull((Object)this.ase.getLabel());
        AgentServiceEntryTest.assertEquals((int)-1, (int)this.ase.hashCode());
        String string = "asldfkjasdkf";
        this.ase.setLabel(string);
        AgentServiceEntryTest.assertEquals((int)string.hashCode(), (int)this.ase.hashCode());
    }

    public void testLoadPeerConfigHandlesBadXMLFile() throws Exception {
        this.ase.setFilename("");
        try {
            this.ase.loadPeerConfig();
            AgentServiceEntryTest.fail((String)"loadPeerConfig() allowed zero length filename");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.ase.setFilename("C:\\temp\\mybadpeer.xml");
        try {
            this.ase.loadPeerConfig();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testCannotLoadOtherObjectTypeAsPeerConfig() throws Exception {
        String string = "C:\\temp\\myother.xml";
        TestXMLSerializableClass testXMLSerializableClass = new TestXMLSerializableClass("abcde", "fghij", 23);
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        try {
            XMLUtil.writeXML((Document)XMLReflector.writeObject((XMLSerializable)testXMLSerializableClass), (String)string2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error saving serializable test object: " + string2, throwable);
        }
        this.ase.setFilename(string);
        try {
            this.ase.loadPeerConfig();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        file.delete();
    }

    public void testSavePeerConfig() {
        this.ase = new AgentServiceEntry();
        try {
            this.ase.savePeerConfig(this.apc, false);
            AgentServiceEntryTest.fail((String)"savePeerConfig() should have thrown NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            AgentServiceEntryTest.fail((String)"savePeerConfig() with null filename threw the wrong exception type");
        }
        this.ase.setFilename("");
        try {
            this.ase.savePeerConfig(this.apc, false);
            AgentServiceEntryTest.fail((String)"savePeerConfig() should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            AgentServiceEntryTest.fail((String)"savePeerConfig() with empty filename threw the wrong exception type");
        }
        this.ase.setFilename("C:\\temp");
        try {
            this.ase.savePeerConfig(this.apc, false);
        }
        catch (FileExistsException fileExistsException) {
            // empty catch block
        }
        this.ase.setFilename(FILENAME);
        try {
            this.ase.savePeerConfig(this.apc, false);
        }
        catch (FileExistsException fileExistsException) {
            // empty catch block
        }
    }

    public void testGetLogFileName() {
        String string = "logs\\mypeer.log";
        String string2 = this.ase.getLogFileName();
        AgentServiceEntryTest.assertEquals((String)string, (String)string2);
        this.ase.setFilename("anotherpeer.xml");
        string = "logs\\anotherpeer.log";
        string2 = this.ase.getLogFileName();
        AgentServiceEntryTest.assertEquals((String)string, (String)string2);
    }

    public void testMakeLink() throws Exception {
        String string = "<a href=\"https://localhost:2222/cp/main.html#general\">CoolText:2222</a>";
        this.apc.setListenPort(2222);
        this.ase.savePeerConfig(this.apc, true);
        String string2 = "CoolText";
        String string3 = this.ase.makeLink(string2, true);
        AgentServiceEntryTest.assertEquals((String)string, (String)string3);
        string3 = this.ase.makeLink(string2, false);
        AgentServiceEntryTest.assertEquals((String)string2, (String)string3);
        this.ase.setFilename("C:\\temp\\some\\bogus\\file\\name.xml");
        string3 = this.ase.makeLink(string2, false);
        AgentServiceEntryTest.assertTrue((boolean)string3.startsWith(string2 + " - Error:"));
    }
}

