/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import com.helpsystems.enterprise.service.AgentServiceEntryComparator;
import com.helpsystems.enterprise.service.DuplicatePortNumberException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class AgentServiceConfig
implements XMLSerializable {
    private static final Logger logger = Logger.getLogger(AgentServiceConfig.class);
    public static final String DEFAULT_FILE_NAME = "agentService.config";
    private static final AgentServiceEntryComparator AGENT_SERVICE_ENTRY_COMPARATOR = new AgentServiceEntryComparator();
    public static final int DEFAULT_LOCAL_PORT = 57471;
    private List<AgentServiceEntry> entryList = new ArrayList<AgentServiceEntry>();
    private int localListenPort = 57471;

    public boolean okToAddEntry(AgentServiceEntry agentServiceEntry) {
        return this.okToAddEntry(agentServiceEntry, 0, true);
    }

    public boolean okToAddEntry(AgentServiceEntry agentServiceEntry, int n, boolean bl) {
        if (this.findEntry(agentServiceEntry.getLabel()) != null) {
            throw new IllegalArgumentException("The Service already contains an entry with the label '" + agentServiceEntry.getLabel() + "'");
        }
        if (this.findNameEntry(agentServiceEntry.getFilename()) != null) {
            throw new IllegalArgumentException("The Service already contains an entry with the Agent configuration file '" + agentServiceEntry.getFilename() + "'");
        }
        if (!bl && this.findLocalPort(n) != null) {
            throw new DuplicatePortNumberException("The Service already contains an entry using the port number " + n);
        }
        return true;
    }

    public void addEntry(AgentServiceEntry agentServiceEntry) {
        this.addEntry(agentServiceEntry, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(AgentServiceEntry agentServiceEntry, int n, boolean bl) {
        ValidationHelper.checkForNull((String)"Entry", (Object)agentServiceEntry);
        this.okToAddEntry(agentServiceEntry, n, bl);
        List<AgentServiceEntry> list = this.entryList;
        synchronized (list) {
            this.entryList.add(agentServiceEntry);
            this.sortList();
        }
    }

    public AgentServiceEntry findLocalPort(int n) {
        AgentServiceEntry[] agentServiceEntryArray;
        for (AgentServiceEntry agentServiceEntry : agentServiceEntryArray = this.getEntries()) {
            AgentPeerConfig agentPeerConfig = null;
            try {
                agentPeerConfig = agentServiceEntry.loadPeerConfig();
            }
            catch (FileNotFoundException fileNotFoundException) {
                agentPeerConfig = null;
            }
            if (agentPeerConfig == null || agentPeerConfig.getListenPort() != n) continue;
            return agentServiceEntry;
        }
        return null;
    }

    public AgentServiceEntry findEntry(String string) {
        AgentServiceEntry[] agentServiceEntryArray;
        for (AgentServiceEntry agentServiceEntry : agentServiceEntryArray = this.getEntries()) {
            if (!Equal.isEqual((Object)agentServiceEntry.getLabel().toLowerCase(), (Object)string.toLowerCase())) continue;
            return agentServiceEntry;
        }
        return null;
    }

    public AgentServiceEntry findNameEntry(String string) {
        AgentServiceEntry[] agentServiceEntryArray;
        for (AgentServiceEntry agentServiceEntry : agentServiceEntryArray = this.getEntries()) {
            if (!Equal.isEqual((Object)agentServiceEntry.getFilename().toLowerCase(), (Object)string.toLowerCase())) continue;
            return agentServiceEntry;
        }
        return null;
    }

    public AgentServiceEntry[] getEntries() {
        AgentServiceEntry[] agentServiceEntryArray = new AgentServiceEntry[this.entryList.size()];
        this.entryList.toArray(agentServiceEntryArray);
        return agentServiceEntryArray;
    }

    public AgentServiceEntry getEntry(int n) {
        return this.entryList.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortList() {
        List<AgentServiceEntry> list = this.entryList;
        synchronized (list) {
            Collections.sort(this.entryList, AGENT_SERVICE_ENTRY_COMPARATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEntry(AgentServiceEntry agentServiceEntry) {
        boolean bl = false;
        List<AgentServiceEntry> list = this.entryList;
        synchronized (list) {
            bl = this.entryList.remove(agentServiceEntry);
            if (bl) {
                this.sortList();
            }
        }
        return bl;
    }

    public int getLocalListenPort() {
        return this.localListenPort;
    }

    public void setLocalListenPort(int n) {
        this.localListenPort = n;
    }

    public String[] doNotInvoke() {
        return new String[0];
    }

    public static void saveAgentServiceConfig(AgentServiceConfig agentServiceConfig, String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Agent service configuration file path is null.");
        }
        if (string.length() == 0) {
            throw new IllegalStateException("Agent service configuration file path blank.");
        }
        logger.trace((Object)("Saving AgentServiceConfig: " + string));
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new RuntimeException("Agent service configuration file '" + string + "' already exists as a directory.");
            }
            if (!bl) {
                throw new RuntimeException("Agent service configuration file '" + string + "' already exists.");
            }
        }
        String string2 = file.getAbsolutePath();
        try {
            XMLUtil.writeXML((Document)XMLReflector.writeObject((XMLSerializable)agentServiceConfig), (String)string2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error saving agent service configuration file: " + string2, throwable);
        }
    }
}

