/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.common.core.util.Convert;
import com.helpsystems.enterprise.service.AgentProcessInfo;
import com.helpsystems.enterprise.service.AgentServiceAMImpl;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AgentProcess {
    private static final int LOG_LIMIT = 1000;
    private static final Logger logger = Logger.getLogger(AgentProcess.class);
    private Process process;
    private BufferedReader stdOut;
    private ScheduledFuture placeholder;
    private AgentServiceEntry entry;
    private PrintWriter stdIn;
    private List<String> logList;
    private boolean isAlive;
    private AgentServiceAMImpl agentService;
    private int exitValue = -1;
    private String computerNameOverride = null;
    private static final File UPDATE_TEMP_DIR;

    AgentProcess(AgentServiceEntry agentServiceEntry, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, AgentServiceAMImpl agentServiceAMImpl) throws IOException {
        this(agentServiceEntry, scheduledThreadPoolExecutor, agentServiceAMImpl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AgentProcess(AgentServiceEntry agentServiceEntry, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, AgentServiceAMImpl agentServiceAMImpl, String string) throws IOException {
        boolean bl;
        this.entry = agentServiceEntry;
        this.agentService = agentServiceAMImpl;
        this.computerNameOverride = string;
        this.logList = new ArrayList<String>();
        File file = new File(agentServiceEntry.getFilePath());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Object[] objectArray = new String[]{System.getProperty("user.dir") + "\\Automate Schedule Agent Process.exe", file.getAbsolutePath()};
        this.log("Starting agent with command: " + Arrays.deepToString(objectArray));
        processBuilder.command(Arrays.asList(objectArray));
        Map<String, String> map = processBuilder.environment();
        String string2 = agentServiceEntry.getLabel();
        boolean bl2 = this.computerNameOverride != null;
        boolean bl3 = bl = string2 != null && string2.length() > 0;
        if (bl2) {
            map.put("COMPUTERNAME", this.computerNameOverride);
            this.log("Setting COMPUTERNAME to " + this.computerNameOverride);
        }
        if (bl) {
            if (bl2 && !string2.equalsIgnoreCase(string) || !bl2) {
                if (!map.containsKey("HS_AGENT_ALIAS")) {
                    map.put("HS_AGENT_ALIAS", string2);
                    this.log("Setting HS_AGENT_ALIAS to " + string2);
                }
            } else {
                this.log("Agent name: " + string2 + " matches computer name: " + string + ".  Using computer name only.");
            }
        }
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(new File(System.getProperty("user.dir")));
        this.process = processBuilder.start();
        this.stdOut = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        this.stdIn = new PrintWriter(new OutputStreamWriter(this.process.getOutputStream()));
        this.isAlive = true;
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor2 = scheduledThreadPoolExecutor;
        synchronized (scheduledThreadPoolExecutor2) {
            this.placeholder = scheduledThreadPoolExecutor.scheduleWithFixedDelay(new ProcessOutputRunner(), 0L, 1L, TimeUnit.SECONDS);
        }
    }

    public String getCurrentComputerName() {
        if (this.computerNameOverride != null && this.computerNameOverride.trim().length() > 0) {
            return this.computerNameOverride;
        }
        String string = System.getenv().get("COMPUTERNAME");
        if (string == null || string.trim().length() < 1) {
            System.out.println("Computer name is missing.");
            return "";
        }
        return string;
    }

    public void runThreadDump() {
        if (!this.isAlive()) {
            return;
        }
        this.write("dump");
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) {
        if (!this.isAlive()) {
            throw new RuntimeException("Process is not active");
        }
        PrintWriter printWriter = this.stdIn;
        synchronized (printWriter) {
            this.stdIn.println(string);
            this.stdIn.flush();
        }
    }

    private void log(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.log(new String[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        List<String> list = this.logList;
        synchronized (list) {
            while (this.logList.size() + stringArray.length > 1000) {
                this.logList.remove(0);
            }
            for (String string : stringArray) {
                this.logList.add(string);
            }
        }
        this.agentService.fireLogEvent(this, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLog() {
        List<String> list = this.logList;
        synchronized (list) {
            String[] stringArray = new String[this.logList.size()];
            this.logList.toArray(stringArray);
            return stringArray;
        }
    }

    private void copyOutput() {
        try {
            String[] stringArray;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            while (this.stdOut.ready() && (stringArray = this.stdOut.readLine()) != null) {
                arrayList.add(stringArray);
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            this.log(stringArray);
        }
        catch (IOException iOException) {
            logger.debug((Object)"Unable to copy output data from the process", (Throwable)iOException);
        }
        try {
            this.exitValue = this.process.exitValue();
            this.isAlive = false;
            if (this.placeholder != null) {
                this.placeholder.cancel(false);
            }
            this.agentService.fireProcessEndedEvent(this);
            if (this.exitValue == 99) {
                this.agentService.startAgent(this.entry);
                this.exitValue = -1;
            }
            if (this.exitValue == 97) {
                this.exitValue = -1;
                this.startAutoUpdate();
            }
            if (this.exitValue > -1) {
                this.log("Process exited with code: " + this.exitValue);
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    private void startAutoUpdate() {
        if (UPDATE_TEMP_DIR == null) {
            this.log("Unable to perform automatic update, auto-update temp dir is missing.");
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                AgentProcess.this.runAutoUpdate();
            }
        };
        thread.setName("Updating agent " + this.entry.getLabel());
        thread.start();
    }

    private void runAutoUpdate() {
        try {
            this.log("Attempting to start Agent auto-update");
            Object[] objectArray = new String[]{System.getenv().get("ComSpec"), "/C", "start /B auto-update.bat"};
            this.log("Starting installer in directory " + UPDATE_TEMP_DIR.getAbsolutePath() + " with command: " + Arrays.deepToString(objectArray));
            ProcessBuilder processBuilder = new ProcessBuilder((String[])objectArray);
            processBuilder.directory(UPDATE_TEMP_DIR);
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            this.stdOut = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        }
        catch (Throwable throwable) {
            this.isAlive = false;
            this.log("Unable to start auto-update: " + Convert.dumpStackToString((Throwable)throwable));
        }
    }

    public AgentServiceEntry getEntry() {
        return this.entry;
    }

    public int getProcessExitValue() {
        return this.exitValue;
    }

    public void shutdown(boolean bl) {
        if (!this.isAlive()) {
            return;
        }
        if (bl) {
            this.write("shutdown now");
        } else {
            this.write("shutdown");
        }
    }

    public void shutdownAndRestart(boolean bl) {
        if (!this.isAlive()) {
            return;
        }
        String string = "shutdown restart";
        if (bl) {
            string = "shutdown restart now";
        }
        this.write(string);
    }

    public AgentProcessInfo getInfo() {
        AgentProcessInfo agentProcessInfo = new AgentProcessInfo();
        agentProcessInfo.setProcessExitValue(this.exitValue);
        agentProcessInfo.setIsAlive(this.isAlive);
        agentProcessInfo.setEntry(this.entry);
        return agentProcessInfo;
    }

    public void setLoggingLevel(int n) {
        Level level = Level.INFO;
        switch (n) {
            case 5000: {
                level = Level.TRACE;
                break;
            }
            case 10000: {
                level = Level.DEBUG;
                break;
            }
            default: {
                level = Level.INFO;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LOGGING");
        stringBuffer.append(" ");
        stringBuffer.append(level.toString());
        this.write(stringBuffer.toString());
    }

    static {
        String string = System.getProperty("java.io.tmpdir") + '/' + "Skybot-auto-update";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        UPDATE_TEMP_DIR = file.exists() ? file : null;
    }

    class ProcessOutputRunner
    implements Runnable {
        ProcessOutputRunner() {
        }

        @Override
        public void run() {
            AgentProcess.this.copyOutput();
        }
    }
}

