/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.preconditions;

import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.peer.preconditions.AbstractJobConditionValidator;
import org.apache.log4j.Logger;
import org.hyperic.sigar.SigarException;

public class CheckDriveSpace
extends AbstractJobConditionValidator {
    private static final long KB = 1L;
    private static final long MB = 1024L;
    private static final long GB = 0x100000L;
    private static final long TB = 0x40000000L;
    private static final int UNIT_KB = 1;
    private static final int UNIT_MB = 2;
    private static final int UNIT_GB = 3;
    private static final int UNIT_TB = 4;
    private static final Logger logger = Logger.getLogger(CheckDriveSpace.class);

    public boolean checkCondition(JobCondition jobCondition) {
        try {
            return jobCondition.isConditionChoice() ? this.isAvailableDriveSpace(jobCondition) : !this.isAvailableDriveSpace(jobCondition);
        }
        catch (SigarException sigarException) {
            logger.debug((Object)"SigarException from isAvailableDriveSpace() method", (Throwable)sigarException);
            sigarException.printStackTrace();
            return false;
        }
    }

    private boolean isAvailableDriveSpace(JobCondition jobCondition) throws SigarException {
        return this.getDriveFreeSpaceWithUnit(jobCondition) >= (long)jobCondition.getConditionVar2();
    }

    private long getDriveFreeSpaceWithUnit(JobCondition jobCondition) throws SigarException {
        switch (jobCondition.getConditionVar1()) {
            case 1: {
                return this.getDriveFreeSpace(jobCondition) / 1L;
            }
            case 2: {
                return this.getDriveFreeSpace(jobCondition) / 1024L;
            }
            case 3: {
                return this.getDriveFreeSpace(jobCondition) / 0x100000L;
            }
            case 4: {
                return this.getDriveFreeSpace(jobCondition) / 0x40000000L;
            }
        }
        throw new IllegalArgumentException("job Condition Var type is not valid: " + jobCondition.getConditionVar1());
    }

    private long getDriveFreeSpace(JobCondition jobCondition) throws SigarException {
        return this.getSigarObject().getFileSystemUsage(jobCondition.getConditionData()).getFree();
    }

    public String toString(JobCondition jobCondition) {
        return "Checking Drive Space.";
    }
}

