/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.preconditions;

import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.peer.preconditions.AbstractJobConditionValidator;
import org.apache.log4j.Logger;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.SigarException;

public class CheckDrive
extends AbstractJobConditionValidator {
    private static final Logger logger = Logger.getLogger(CheckDrive.class);

    public boolean checkCondition(JobCondition jobCondition) {
        try {
            return jobCondition.isConditionChoice() ? this.existsDrive(jobCondition) : !this.existsDrive(jobCondition);
        }
        catch (SigarException sigarException) {
            logger.debug((Object)"SigarException from existDrive() method", (Throwable)sigarException);
            sigarException.printStackTrace();
            return false;
        }
    }

    public boolean existsDrive(JobCondition jobCondition) throws SigarException {
        FileSystem[] fileSystemArray;
        for (FileSystem fileSystem : fileSystemArray = this.getSigarObject().getFileSystemList()) {
            if (!fileSystem.getDirName().equals(jobCondition.getConditionData().trim())) continue;
            return true;
        }
        return false;
    }

    public String toString(JobCondition jobCondition) {
        return "Checking Drive existence.";
    }
}

