/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.ha;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.ReplicationStatistics;
import com.helpsystems.enterprise.core.busobj.SystemSetup;
import com.helpsystems.enterprise.core.dm.ReplicationDM;
import com.helpsystems.enterprise.core.dm.SkybotPeerInfoAM;
import com.helpsystems.enterprise.core.dm.SystemSetupDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.messages.SystemMessage;
import com.helpsystems.enterprise.core.messages.SystemMessageQueue;
import com.helpsystems.enterprise.peer.AgentPeer;
import org.apache.log4j.Logger;

public class ReplicationHeartbeatRunner
implements Runnable {
    private static final Logger logger = Logger.getLogger(ReplicationHeartbeatRunner.class);
    public static final String HEARTBEAT_THREAD_NAME = "ReplicationHeartbeatRunner";
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long HEARRTBEAT_INTERVAL = 120000L;
    private static final long NOTIFICATION_INTERVAL = 3600000L;
    private boolean stop = false;
    private AgentPeer serverPeer = null;
    long nextHeartbeatNotificationTime = 0L;
    long nextStandByClockNotificationTime = 0L;
    private Runnable heartbeatNotifier = null;

    public ReplicationHeartbeatRunner(AgentPeer agentPeer, Runnable runnable) {
        this.serverPeer = agentPeer;
        this.heartbeatNotifier = runnable;
    }

    @Override
    public void run() {
        this.nextHeartbeatNotificationTime = System.currentTimeMillis() + 120000L;
        while (true) {
            try {
                while (true) {
                    if (this.stop) {
                        return;
                    }
                    long l = System.currentTimeMillis();
                    this.processStandbyValidation(l);
                    this.waitForNextInterval(l);
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)"An error occurred in the Heartbeat process.", throwable);
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private void processStandbyValidation(long l) {
        try {
            SystemSetupDM systemSetupDM;
            SystemSetup systemSetup;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Processing standby server validations.");
            }
            if ((systemSetup = (systemSetupDM = (SystemSetupDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SystemSetupDM")).get()) != null) {
                if (systemSetup.getStandbyServer() != null && systemSetup.getStandbyServer().trim().length() > 0) {
                    this.updateReplicationHeartbeat(l);
                    this.checkStandbyClock(l, systemSetup.getStandbyServer().trim());
                } else {
                    logger.debug((Object)"The server is not configured with a standby server.");
                }
            } else {
                logger.error((Object)"The system setup information is null.");
            }
        }
        catch (Throwable throwable) {
            logger.warn((Object)"Error processing standby server validations.", throwable);
        }
    }

    private void updateReplicationHeartbeat(long l) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Updating replication heartbeat for standby synchronization verification.");
            }
            this.heartbeatNotifier.run();
            ReplicationDM replicationDM = (ReplicationDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReplicationDM");
            replicationDM.updateReplicationHeartbeat(1L, l);
            try {
                ReplicationStatistics replicationStatistics = replicationDM.getReplicationStatistics();
                if (replicationStatistics != null && logger.isDebugEnabled()) {
                    logger.debug((Object)("Replication Statistics: " + replicationStatistics.toString()));
                }
            }
            catch (NoDataException noDataException) {
                logger.warn((Object)"Replication statistics are not available. Replication is probably not active.");
                if (l >= this.nextHeartbeatNotificationTime) {
                    this.nextHeartbeatNotificationTime = l + 3600000L;
                    SystemMessage systemMessage = RosettaMsg.REPLICATION_IS_NOT_ACTIVE_MESSAGE.newSystemMessage();
                    SystemMessage systemMessage2 = RosettaMsg.REPLICATION_IS_NOT_ACTIVE_SUBJECT.newSystemMessage();
                    SystemMessageQueue.write((SystemMessage)systemMessage, (String)"AT", (SystemMessage)systemMessage2);
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)"Error retrieving replication statistics.", throwable);
            }
        }
        catch (Throwable throwable) {
            logger.warn((Object)"Error updating standby DB replication heartbeat.", throwable);
        }
    }

    private void checkStandbyClock(long l, String string) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Checking standby clock time for standby synchronization verification.");
            }
            SkybotPeerInfoAM skybotPeerInfoAM = null;
            PeerID[] peerIDArray = this.serverPeer.getConnectedStandbyServer();
            if (peerIDArray != null && peerIDArray.length > 0) {
                PeerID peerID = peerIDArray[0];
                skybotPeerInfoAM = (SkybotPeerInfoAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.SkybotPeerInfoAM");
                long l2 = System.currentTimeMillis();
                long l3 = skybotPeerInfoAM.getPeerTime();
                long l4 = System.currentTimeMillis();
                long l5 = 5L;
                long l6 = 10L;
                if (l4 - l2 <= l5 * 1000L) {
                    String string2;
                    String string3;
                    String string4;
                    if (l3 < l2 - l6 * 60000L) {
                        string4 = ScheduleLogger.formatTimeStampSecs((long)l3);
                        string3 = ScheduleLogger.formatTimeStampSecs((long)l2);
                        string2 = "Standby peer time (" + string4 + ") was more than " + l6 + " minutes behind the server time (" + string3 + ").";
                        this.notifyStandbyClockWarning(l, string4, string3, string2);
                    }
                    if (l3 > l4 + l6 * 60000L) {
                        string4 = ScheduleLogger.formatTimeStampSecs((long)l3);
                        string3 = ScheduleLogger.formatTimeStampSecs((long)l4);
                        string2 = "Standby peer time (" + string4 + ") was more than " + l6 + " minutes ahead of the server time (" + string3 + ").";
                        this.notifyStandbyClockWarning(l, string4, string3, string2);
                    }
                } else {
                    logger.warn((Object)("Standby peer response for current time request took longer than " + l5 + " seconds.  Ignoring clock synch validation."));
                }
            } else {
                logger.debug((Object)"There are no connected standby peers for clock validation.");
            }
        }
        catch (Throwable throwable) {
            logger.warn((Object)"Error checking standby clock synchronization.", throwable);
        }
    }

    private void notifyStandbyClockWarning(long l, String string, String string2, String string3) {
        logger.warn((Object)string3);
        if (l >= this.nextStandByClockNotificationTime) {
            this.nextStandByClockNotificationTime = l + 3600000L;
            String[] stringArray = new String[]{string, string2};
            SystemMessage systemMessage = RosettaMsg.STANDBY_CLOCK_IS_NOT_IN_SYNC_SUBJECT.newSystemMessage();
            SystemMessage systemMessage2 = RosettaMsg.STANDBY_CLOCK_IS_NOT_IN_SYNC_MESSAGE.newSystemMessage(stringArray);
            SystemMessageQueue.write((SystemMessage)systemMessage2, (String)"AT", (SystemMessage)systemMessage);
        }
    }

    private void waitForNextInterval(long l) {
        long l2 = l / 120000L * 120000L + 120000L;
        long l3 = l2 - l + 250L;
        do {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Waiting " + l3 + "ms for next Replication Heartbeat interval: " + ScheduleLogger.formatTimeStampSecs((long)l2)));
            }
            if (l3 > 0L) {
                try {
                    Thread.sleep(l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            l = System.currentTimeMillis();
            l3 = 3000L;
        } while (l2 > l);
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean bl) {
        this.stop = bl;
    }
}

