/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.dataset.CachingDataSet;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.event.PeerEventListener;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.dm.AgentStatusAM;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.helpsystems.enterprise.peer.AgentUpdater;
import org.apache.log4j.Logger;

public class TemporaryAgentUpdateInitiator {
    private static final Logger LOGGER = Logger.getLogger(TemporaryAgentUpdateInitiator.class);

    public static void listenIn(AgentPeer agentPeer) {
        agentPeer.addListener((SimpleEventListener)new PeerEventListener(){

            protected void peerConnected(PeerID peerID, PeerID peerID2) {
                String string = peerID.getPeerDescriptor().getComputerName();
                if (string != null && string.endsWith(":a-Upd97")) {
                    TemporaryAgentUpdateInitiator.updateConnectedAgents();
                }
            }

            protected void peerDisconnected(PeerID peerID, PeerID peerID2) {
            }
        });
    }

    public static void updateConnectedAgents() {
        AgentProxy[] agentProxyArray = null;
        try {
            agentProxyArray = TemporaryAgentUpdateInitiator.listAgents();
        }
        catch (Exception exception) {
            LOGGER.debug((Object)"Unable to retrieve a listing of agents from the database.", (Throwable)exception);
            return;
        }
        for (AgentProxy agentProxy : agentProxyArray) {
            if (agentProxy.getRuntimeState() != 1) continue;
            try {
                AgentUpdater.update(agentProxy.getOid(), "System");
                LOGGER.info((Object)("Beginning automatic update of agent " + agentProxy.getName()));
            }
            catch (Exception exception) {
                LOGGER.debug((Object)("Unable to update Agent " + agentProxy.getName()), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgentProxy[] listAgents() throws Exception {
        AgentProxy[] agentProxyArray = null;
        DataSet dataSet = null;
        try {
            AgentStatusAM agentStatusAM = (AgentStatusAM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentStatusAM");
            dataSet = agentStatusAM.getDataSet(null, null, (SortField)new GenericSortField(10101, 0));
            CachingDataSet cachingDataSet = new CachingDataSet(dataSet);
            agentProxyArray = new AgentProxy[cachingDataSet.size()];
            for (int i = 0; i < agentProxyArray.length; ++i) {
                agentProxyArray[i] = (AgentProxy)cachingDataSet.get(i);
            }
        }
        finally {
            try {
                dataSet.close();
            }
            catch (Exception exception) {}
        }
        return agentProxyArray;
    }
}

