/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.util.InterruptibleProcess;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.EnterpriseService;
import com.helpsystems.enterprise.core.busobj.ServicePeerDefinition;
import com.helpsystems.enterprise.core.busobj.sap.SAPEventMonitor;
import com.helpsystems.enterprise.core.dm.sap.SAPEventMonitorDM;
import com.helpsystems.enterprise.core.dm.sap.SAPServerHelperAM;
import com.helpsystems.enterprise.core.util.StringUtilities;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SAPEventMonitorProcess
implements Runnable,
InterruptibleProcess,
EnterpriseService {
    private static Logger logger = Logger.getLogger(SAPEventMonitorProcess.class);
    private static final String SERVICE_NAME = "SAP Event Monitor";
    public static final String THREAD_NAME = "SAP Event Monitor thread";
    private boolean isShutdown = false;
    private ServicePeerDefinition peerDef = null;
    private PeerID serverPeerID = null;
    private Thread serviceThread = null;
    private int numberMonitorsProcessed = 0;
    private SAPEventMonitor currentMonitor = null;
    private long SLEEP_TIME = 10000L;
    ArrayList<SAPEventMonitor> list = new ArrayList();
    private static DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();

    public void interrupt() {
        if (!this.isShutdown) {
            this.isShutdown = true;
        }
        if (this.serviceThread != null && !this.serviceThread.isInterrupted()) {
            try {
                this.serviceThread.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isInterruptible() {
        return !this.isShutdown;
    }

    public boolean wasInterrupted() {
        return this.isShutdown;
    }

    public String getServiceInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getFullServiceInfo());
        return stringBuffer.toString();
    }

    private String getFullServiceInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getListing());
        return stringBuffer.toString();
    }

    private Object getListing() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<H2>SAP Event Monitors:</h2>");
        ArrayList<Object> arrayList = new ArrayList();
        try {
            arrayList = this.getMonitors(true);
        }
        catch (Throwable throwable) {
            stringBuffer.append("<BR>");
            stringBuffer.append("Unable to retrieve list of SAP Event Monitors.");
            stringBuffer.append(throwable.getStackTrace());
            return stringBuffer.toString();
        }
        stringBuffer.append("<table border=2 CELLPADDING=4><tr>");
        stringBuffer.append("<th BGCOLOR=\"#99CCFF\">Event Name</th>");
        stringBuffer.append("<th BGCOLOR=\"#99CCFF\">Event Description</th>");
        stringBuffer.append("<th BGCOLOR=\"#99CCFF\">Enabled</th>");
        stringBuffer.append("<th BGCOLOR=\"#99CCFF\">Number of Filters</th></tr>");
        if (arrayList.isEmpty()) {
            stringBuffer.append("<tr><td COLSPAN=4 align=\"center\">");
            stringBuffer.append("No SAP Event Monitors.");
            stringBuffer.append("</td><tr></table>");
            return stringBuffer.toString();
        }
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            SAPEventMonitor sAPEventMonitor;
            SAPEventMonitor sAPEventMonitor2 = sAPEventMonitor = (SAPEventMonitor)iterator.next();
            stringBuffer.append("<tr>");
            stringBuffer.append("<td>");
            stringBuffer.append(StringUtilities.getHumanizedText((String)sAPEventMonitor2.getName()));
            stringBuffer.append("</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(sAPEventMonitor2.getDescription());
            stringBuffer.append("</td>");
            stringBuffer.append("<td>");
            if (sAPEventMonitor2.isDisabled()) {
                stringBuffer.append("No");
            } else {
                stringBuffer.append("Yes");
            }
            stringBuffer.append("</td>");
            stringBuffer.append("<td>");
            stringBuffer.append(sAPEventMonitor2.getDataFilter().getCriteria().length);
            stringBuffer.append("</td>");
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    private ArrayList<SAPEventMonitor> getMonitors(boolean bl) {
        ArrayList<SAPEventMonitor> arrayList = new ArrayList<SAPEventMonitor>();
        SAPEventMonitorDM sAPEventMonitorDM = (SAPEventMonitorDM)ManagerRegistry.getManager((String)"ENTERPRISE.SAPEventMonitorDM");
        if (sAPEventMonitorDM != null) {
            SAPEventMonitor[] sAPEventMonitorArray = null;
            try {
                sAPEventMonitorArray = sAPEventMonitorDM.getList(bl);
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Unable to retrieve the list of SAP Event Monitors.", throwable);
                return arrayList;
            }
            if (sAPEventMonitorArray != null && sAPEventMonitorArray.length > 0) {
                for (int i = 0; i < sAPEventMonitorArray.length; ++i) {
                    try {
                        arrayList.add(sAPEventMonitorArray[i]);
                        continue;
                    }
                    catch (Throwable throwable) {
                        logger.debug((Object)"Unable to retrieve the list of SAP Event Monitors.", throwable);
                    }
                }
            } else {
                logger.debug((Object)"No SAP Event Monitors found to process.");
            }
        } else {
            logger.debug((Object)"No SAP Event Monitors found to process.");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Found " + arrayList.size() + " SAPEventMonitor to process..."));
        }
        return arrayList;
    }

    public String getServiceLogFileName() {
        return this.getPeerDef().getServiceLogFileName();
    }

    private ServicePeerDefinition getPeerDef() {
        if (this.peerDef == null) {
            this.peerDef = SAPEventMonitorProcess.getServicePeerDefinition();
        }
        return this.peerDef;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public int getServicePort() {
        return this.getPeerDef().getProductIIDInt();
    }

    private static String getFormattedNumber(long l) {
        df.applyPattern("###,###,###,###,###,###");
        return df.format(l);
    }

    public String getServiceStatistics() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr><td><b>Connected to Automate Schedule Server:</b></td><td>");
        if (this.serverPeerID == null) {
            stringBuffer.append("Not connected...");
        } else {
            stringBuffer.append(this.serverPeerID.getPeerDescriptor().getPeerName());
        }
        stringBuffer.append("<tr><td><b>Number SAP Events Monitors processed:</b></td><td>");
        if (this.numberMonitorsProcessed == 0) {
            stringBuffer.append("None");
        } else {
            stringBuffer.append(SAPEventMonitorProcess.getFormattedNumber(this.numberMonitorsProcessed));
        }
        stringBuffer.append("</td></tr>");
        stringBuffer.append("<tr><td><b>Processing SAP Event Monitor: </b></td><td>");
        if (this.currentMonitor == null) {
            stringBuffer.append("None");
        } else {
            stringBuffer.append(StringUtilities.getHumanizedText((String)this.currentMonitor.getName()));
        }
        stringBuffer.append("</td></tr>");
        return stringBuffer.toString();
    }

    public void registerServiceToServerPeer(PeerID peerID) {
        this.serverPeerID = peerID;
    }

    public void setServicePort(int n) {
        this.getPeerDef().setPortNumber(n);
    }

    public void startService() {
        this.run();
    }

    public boolean getLocalService() {
        return true;
    }

    @Override
    public void run() {
        int n = 0;
        Thread.currentThread().setName(THREAD_NAME);
        long l = 0L;
        while (!this.isShutdown) {
            try {
                SAPServerHelperAM sAPServerHelperAM = (SAPServerHelperAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPServerHelperAM");
                long l2 = System.currentTimeMillis();
                sAPServerHelperAM.processSAPEventHistoryRecords(l);
                l = l2;
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (Throwable throwable) {
                logger.error((Object)"SAP Event Monitor has encounted an error processing events.", throwable);
            }
        }
        System.exit(n);
    }

    public static ServicePeerDefinition getServicePeerDefinition() {
        String[] stringArray = new String[]{};
        ServicePeerDefinition servicePeerDefinition = new ServicePeerDefinition();
        servicePeerDefinition.setName("SAPEventMonitorProcess");
        servicePeerDefinition.setDescription("The SAP Event Monitor Service.");
        servicePeerDefinition.setClassName("com.helpsystems.enterprise.peer.SAPEventMonitorProcess");
        servicePeerDefinition.setPortNumber(-1234);
        servicePeerDefinition.setArguments(stringArray);
        return servicePeerDefinition;
    }
}

