/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.cmdlineobj.FileTransferInfo;
import com.helpsystems.enterprise.core.dm.FileTransferInfoAM;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class FileTransferInfoFetcher {
    private static final Logger logger = Logger.getLogger(FileTransferInfoFetcher.class);
    private ArrayList<FileTransferInfo> allInfo;
    int threadCount;
    long whenStarted = System.currentTimeMillis();

    public FileTransferInfoFetcher(Peer peer) {
        PeerID[] peerIDArray;
        this.allInfo = new ArrayList();
        PeerID peerID = peer.getRemotePeerID();
        for (PeerID peerID2 : peerIDArray = peer.getPeersFromRoutingTable()) {
            if (!peerID2.getHardwareHash().equals(peerID.getHardwareHash())) continue;
            if (peerID2.equals((Object)peerID)) {
                this.fetchTransferInfo(peerID);
                continue;
            }
            if (peerID2.getPeerDescriptor().getType() != 3) continue;
            final PeerID peerID3 = peerID2;
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread.currentThread().setName("Fetching file transfer info from " + peerID3);
                    FileTransferInfoFetcher.this.fetchTransferInfo(peerID3);
                    ArrayList arrayList = FileTransferInfoFetcher.this.allInfo;
                    synchronized (arrayList) {
                        --FileTransferInfoFetcher.this.threadCount;
                        FileTransferInfoFetcher.this.allInfo.notifyAll();
                    }
                }
            });
            ++this.threadCount;
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchTransferInfo(PeerID peerID) {
        try {
            FileTransferInfoAM fileTransferInfoAM = null;
            fileTransferInfoAM = peerID == null ? (FileTransferInfoAM)ManagerRegistry.getManager((String)"ENTERPRISE.FileTransferInfoAM") : (FileTransferInfoAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID, (String)"ENTERPRISE.FileTransferInfoAM");
            FileTransferInfo[] fileTransferInfoArray = fileTransferInfoAM.getList();
            ArrayList<FileTransferInfo> arrayList = this.allInfo;
            synchronized (arrayList) {
                this.allInfo.addAll(Arrays.asList(fileTransferInfoArray));
            }
        }
        catch (Exception exception) {
            String string = null;
            string = peerID == null ? "this agent" : peerID.toString();
            logger.debug((Object)("Unable to retrieve file transfer info from " + string), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileTransferInfo[] get() {
        ArrayList<FileTransferInfo> arrayList = this.allInfo;
        synchronized (arrayList) {
            long l = this.whenStarted + 5000L;
            while (this.threadCount > 0 && System.currentTimeMillis() < l) {
                try {
                    this.allInfo.wait(1000L);
                }
                catch (Exception exception) {}
            }
            FileTransferInfo[] fileTransferInfoArray = new FileTransferInfo[this.allInfo.size()];
            this.allInfo.toArray(fileTransferInfoArray);
            return fileTransferInfoArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileTransferInfo[] get(AgentPeer agentPeer) {
        ArrayList<FileTransferInfo> arrayList = this.allInfo;
        synchronized (arrayList) {
            long l = this.whenStarted + 5000L;
            while (this.threadCount > 0 && System.currentTimeMillis() < l) {
                try {
                    this.allInfo.wait(1000L);
                }
                catch (Exception exception) {}
            }
            PeerDescriptor peerDescriptor = agentPeer.getPeerDescriptor();
            ArrayList<FileTransferInfo> arrayList2 = new ArrayList<FileTransferInfo>();
            for (FileTransferInfo fileTransferInfoArray2 : this.allInfo) {
                if (fileTransferInfoArray2.getRemotePeerName().equals(peerDescriptor.getComputerName())) continue;
                arrayList2.add(fileTransferInfoArray2);
            }
            FileTransferInfo[] fileTransferInfoArray = new FileTransferInfo[arrayList2.size()];
            arrayList2.toArray(fileTransferInfoArray);
            return fileTransferInfoArray;
        }
    }
}

