/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.enterprise.peer.AgentPeerConfig;
import junit.framework.TestCase;

public class AgentPeerConfigTest
extends TestCase {
    static final String testAddress = "192.168.1.90";
    static final String testLicenseKey = "o&I<APY28eua.uoTy,45peAo*u";
    AgentPeerConfig config;

    protected void setUp() throws Exception {
        super.setUp();
        this.config = new AgentPeerConfig();
    }

    protected void tearDown() throws Exception {
        this.config = null;
        super.tearDown();
    }

    public void testGetLicenseKey() {
        this.config.setLicenseKey(testLicenseKey);
        AgentPeerConfigTest.assertEquals((String)testLicenseKey, (String)this.config.getLicenseKey());
    }

    public void testDefaultModeIsServer() {
        AgentPeerConfigTest.assertEquals((Object)((Object)AgentPeerConfig.AgentMode.SERVER), (Object)((Object)this.config.getMode()));
    }

    public void testGetMode() {
        this.config.setMode(AgentPeerConfig.AgentMode.CLIENT);
        AgentPeerConfigTest.assertEquals((Object)((Object)AgentPeerConfig.AgentMode.CLIENT), (Object)((Object)this.config.getMode()));
        this.config.setMode(AgentPeerConfig.AgentMode.SERVER);
        AgentPeerConfigTest.assertEquals((Object)((Object)AgentPeerConfig.AgentMode.SERVER), (Object)((Object)this.config.getMode()));
        this.config.setMode(null);
        AgentPeerConfigTest.assertEquals(null, (Object)((Object)this.config.getMode()));
    }

    public void testGetModeAsString() {
        this.config.setModeAsString(AgentPeerConfig.AgentMode.SERVER.toString());
        AgentPeerConfigTest.assertEquals((String)AgentPeerConfig.AgentMode.SERVER.toString(), (String)this.config.getModeAsString());
        this.config.setModeAsString(AgentPeerConfig.AgentMode.CLIENT.toString());
        AgentPeerConfigTest.assertEquals((String)AgentPeerConfig.AgentMode.CLIENT.toString(), (String)this.config.getModeAsString());
        this.config.setMode(null);
        AgentPeerConfigTest.assertEquals((String)"", (String)this.config.getModeAsString());
    }

    public void testSetModeAsStringWithInvalidValue() {
        try {
            this.config.setModeAsString("garbage");
            AgentPeerConfigTest.fail((String)"setModeAsString() accepted bad value.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetMaster() {
        PeerDescriptor peerDescriptor = new PeerDescriptor(testAddress, 1234, 4, "Windows XP");
        this.config.setMaster(peerDescriptor);
        AgentPeerConfigTest.assertEquals((Object)peerDescriptor, (Object)this.config.getMaster());
    }

    public void testGetMulticastAddress() {
        this.config.setMulticastAddress(testAddress);
        AgentPeerConfigTest.assertEquals((String)testAddress, (String)this.config.getMulticastAddress());
    }

    public void testGetNotifyPort() {
        this.config.setNotifyPort(2345);
        AgentPeerConfigTest.assertEquals((int)2345, (int)this.config.getNotifyPort());
    }

    public void testSetNotifyPortToNegativeValue() {
        this.config.setNotifyPort(-2389);
        AgentPeerConfigTest.assertEquals((int)7479, (int)this.config.getNotifyPort());
    }

    public void testDefaultMulticastAddress() {
        this.config.setMulticastAddress("   ");
        AgentPeerConfigTest.assertEquals((String)"230.9.11.1", (String)this.config.getMulticastAddress());
    }

    public void testGetMulticastPort() {
        this.config.setMulticastPort(8484);
        AgentPeerConfigTest.assertEquals((int)8484, (int)this.config.getMulticastPort());
    }

    public void testDefaultMulticastPort() {
        this.config.setMulticastPort(0);
        AgentPeerConfigTest.assertEquals((int)7472, (int)this.config.getMulticastPort());
    }

    public void testGetMulticastIdentifier() {
        String string = "SomeMulticastIdentifier";
        this.config.setMulticastIdentifier(string);
        AgentPeerConfigTest.assertEquals((String)string, (String)this.config.getMulticastIdentifier());
    }

    public void testDoNotInvoke() {
        String[] stringArray = this.config.doNotInvoke();
        if (stringArray.length == 0) {
            AgentPeerConfigTest.fail((String)"doNotInvoke() didn't get any methods");
        }
        boolean bl = false;
        for (String string : stringArray) {
            if (!"getMode".equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            AgentPeerConfigTest.fail((String)"doNotInvoke() list didn't include getMode");
        }
    }
}

